<?php
/**
 * Site Options
 */

$wp_customize->add_panel( 'bizindustries_theme_options',
		array(
			'priority'       => 30,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => esc_html__( 'Theme Options', 'bizindustries' ),
			'description'    => '',
		)
	);

$wp_customize->add_panel( 'bizindustries_frontpage_options',
	array(
		'priority'       => 40,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => esc_html__( 'Front Page Settings', 'bizindustries' ),
		'description'    => '',
	)
);

$wp_customize->add_panel( 'contact_page_template',
	array(
		'priority'       => 50,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => esc_html__( 'Contact Page Settings', 'bizindustries' ),
		'description'    => '',
	)
);

if ( ! function_exists( 'wp_get_custom_css' ) ) {  // Back-compat for WordPress < 4.7.

	/* Custom CSS Settings
	----------------------------------------------------------------------*/
	$wp_customize->add_section(
		'bizindustries_custom_code',
		array(
			'title' => __( 'Custom CSS', 'bizindustries' ),
			'panel' => 'bizindustries_theme_options',
		)
	);
	$wp_customize->add_setting(
		'bizindustries_custom_css',
		array(
			'default'           => '',
			'sanitize_callback' => 'bizindustries_sanitize_css',
			'type'              => 'option',
		)
	);
	$wp_customize->add_control(
		'bizindustries_custom_css',
		array(
			'label'   => __( 'Custom CSS', 'bizindustries' ),
			'section' => 'bizindustries_custom_code',
			'type'    => 'textarea'
		)
	);
} else {
	$wp_customize->get_section( 'custom_css' )->priority = 994;
}