<?php
/**
 * Site Identity.
 */
$font_array = array(
	''                       => esc_html__( 'Default', 'bizindustries' ),
	'Abril Fatface'          => esc_html__( 'Abril Fatface', 'bizindustries' ),
	'Acme'                   => esc_html__( 'Acme', 'bizindustries' ),
	'Anton'                  => esc_html__( 'Anton', 'bizindustries' ),
	'Architects Daughter'    => esc_html__( 'Architects Daughter', 'bizindustries' ),
	'Arimo'                  => esc_html__( 'Arimo', 'bizindustries' ),
	'Arsenal'                => esc_html__( 'Arsenal', 'bizindustries' ),
	'Arvo'                   => esc_html__( 'Arvo', 'bizindustries' ),
	'Alegreya'               => esc_html__( 'Alegreya', 'bizindustries' ),
	'Alfa Slab One'          => esc_html__( 'Alfa Slab One', 'bizindustries' ),
	'Averia Serif Libre'     => esc_html__( 'Averia Serif Libre', 'bizindustries' ),
	'Bangers'                => esc_html__( 'Bangers', 'bizindustries' ),
	'Boogaloo'               => esc_html__( 'Boogaloo', 'bizindustries' ),
	'Bad Script'             => esc_html__( 'Bad Script', 'bizindustries' ),
	'Bitter'                 => esc_html__( 'Bitter', 'bizindustries' ),
	'Bree Serif'             => esc_html__( 'Bree Serif', 'bizindustries' ),
	'BenchNine'              => esc_html__( 'BenchNine', 'bizindustries' ),
	'Cabin'                  => esc_html__( 'Cabin', 'bizindustries' ),
	'Carattere'              => esc_html__( 'Carattere', 'bizindustries' ),
	'Cardo'                  => esc_html__( 'Cardo', 'bizindustries' ),
	'Courgette'              => esc_html__( 'Courgette', 'bizindustries' ),
	'Cherry Swash'           => esc_html__( 'Cherry Swash', 'bizindustries' ),
	'Cormorant Garamond'     => esc_html__( 'Cormorant Garamond', 'bizindustries' ),
	'Crimson Text'           => esc_html__( 'Crimson Text', 'bizindustries' ),
	'Cuprum'                 => esc_html__( 'Cuprum', 'bizindustries' ),
	'Cookie'                 => esc_html__( 'Cookie', 'bizindustries' ),
	'Chewy'                  => esc_html__( 'Chewy', 'bizindustries' ),
	'Days One'               => esc_html__( 'Days One', 'bizindustries' ),
	'Dosis'                  => esc_html__( 'Dosis', 'bizindustries' ),
	'Droid Sans'             => esc_html__( 'Droid Sans', 'bizindustries' ),
	'Economica'              => esc_html__( 'Economica', 'bizindustries' ),
	'Fredoka One'            => esc_html__( 'Fredoka One', 'bizindustries' ),
	'Fjalla One'             => esc_html__( 'Fjalla One', 'bizindustries' ),
	'Francois One'           => esc_html__( 'Francois One', 'bizindustries' ),
	'Frank Ruhl Libre'       => esc_html__( 'Frank Ruhl Libre', 'bizindustries' ),
	'Gloria Hallelujah'      => esc_html__( 'Gloria Hallelujah', 'bizindustries' ),
	'Great Vibes'            => esc_html__( 'Great Vibes', 'bizindustries' ),
	'Handlee'                => esc_html__( 'Handlee', 'bizindustries' ),
	'Hammersmith One'        => esc_html__( 'Hammersmith One', 'bizindustries' ),
	'Inconsolata'            => esc_html__( 'Inconsolata', 'bizindustries' ),
	'Indie Flower'           => esc_html__( 'Indie Flower', 'bizindustries' ),
	'IM Fell English SC'     => esc_html__( 'IM Fell English SC', 'bizindustries' ),
	'Julius Sans One'        => esc_html__( 'Julius Sans One', 'bizindustries' ),
	'Josefin Slab'           => esc_html__( 'Josefin Slab', 'bizindustries' ),
	'Josefin Sans'           => esc_html__( 'Josefin Sans', 'bizindustries' ),
	'Kanit'                  => esc_html__( 'Kanit', 'bizindustries' ),
	'Lobster'                => esc_html__( 'Lobster', 'bizindustries' ),
	'Lato'                   => esc_html__( 'Lato', 'bizindustries' ),
	'Lora'                   => esc_html__( 'Lora', 'bizindustries' ),
	'Libre Baskerville'      => esc_html__( 'Libre Baskerville', 'bizindustries' ),
	'Lobster Two'            => esc_html__( 'Lobster Two', 'bizindustries' ),
	'Merriweather'           => esc_html__( 'Merriweather', 'bizindustries' ),
	'Monda'                  => esc_html__( 'Monda', 'bizindustries' ),
	'Montserrat'             => esc_html__( 'Montserrat', 'bizindustries' ),
	'Muli'                   => esc_html__( 'Muli', 'bizindustries' ),
	'Marck Script'           => esc_html__( 'Marck Script', 'bizindustries' ),
	'Noto Serif'             => esc_html__( 'Noto Serif', 'bizindustries' ),
	'Open Sans'              => esc_html__( 'Open Sans', 'bizindustries' ),
	'Overpass'               => esc_html__( 'Overpass', 'bizindustries' ),
	'Overpass Mono'          => esc_html__( 'Overpass Mono', 'bizindustries' ),
	'Oxygen'                 => esc_html__( 'Oxygen', 'bizindustries' ),
	'Orbitron'               => esc_html__( 'Orbitron', 'bizindustries' ),
	'Patua One'              => esc_html__( 'Patua One', 'bizindustries' ),
	'Pacifico'               => esc_html__( 'Pacifico', 'bizindustries' ),
	'Padauk'                 => esc_html__( 'Padauk', 'bizindustries' ),
	'Playball'               => esc_html__( 'Playball', 'bizindustries' ),
	'Playfair Display'       => esc_html__( 'Playfair Display', 'bizindustries' ),
	'Poppins'       		 => esc_html__( 'Poppins', 'bizindustries' ),
	'PT Sans'                => esc_html__( 'PT Sans', 'bizindustries' ),
	'Philosopher'            => esc_html__( 'Philosopher', 'bizindustries' ),
	'Permanent Marker'       => esc_html__( 'Permanent Marker', 'bizindustries' ),
	'Poiret One'             => esc_html__( 'Poiret One', 'bizindustries' ),
	'Quicksand'              => esc_html__( 'Quicksand', 'bizindustries' ),
	'Quattrocento Sans'      => esc_html__( 'Quattrocento Sans', 'bizindustries' ),
	'Raleway'                => esc_html__( 'Raleway', 'bizindustries' ),
	'Rubik'                  => esc_html__( 'Rubik', 'bizindustries' ),
	'Rokkitt'                => esc_html__( 'Rokkitt', 'bizindustries' ),
	'Russo One'              => esc_html__( 'Russo One', 'bizindustries' ),
	'Righteous'              => esc_html__( 'Righteous', 'bizindustries' ),
	'Slabo'                  => esc_html__( 'Slabo', 'bizindustries' ),
	'Source Sans Pro'        => esc_html__( 'Source Sans Pro', 'bizindustries' ),
	'Shadows Into Light Two' => esc_html__( 'Shadows Into Light Two', 'bizindustries'),
	'Shadows Into Light'     => esc_html__( 'Shadows Into Light', 'bizindustries' ),
	'Sacramento'             => esc_html__( 'Sacramento', 'bizindustries' ),
	'Shrikhand'              => esc_html__( 'Shrikhand', 'bizindustries' ),
	'STIX Two Text'          => esc_html__( 'STIX Two Text', 'bizindustries' ),
	'Tangerine'              => esc_html__( 'Tangerine', 'bizindustries' ),
	'Ubuntu'                 => esc_html__( 'Ubuntu', 'bizindustries' ),
	'VT323'                  => esc_html__( 'VT323', 'bizindustries' ),
	'Varela Round'           => esc_html__( 'Varela Round', 'bizindustries' ),
	'Vampiro One'            => esc_html__( 'Vampiro One', 'bizindustries' ),
	'Vollkorn'               => esc_html__( 'Vollkorn', 'bizindustries' ),
	'Volkhov'                => esc_html__( 'Volkhov', 'bizindustries' ),
	'Yanone Kaffeesatz'      => esc_html__( 'Yanone Kaffeesatz', 'bizindustries' )
);

// Logo, title and description chooser
$wp_customize->add_setting( 'site_logo_option',
	array (
		'default'           => '',
		'sanitize_callback' => 'bizindustries_sanitize_logo',
		'transport'         => 'refresh'
	)
);
$wp_customize->add_control( 'site_logo_option',
	array(
		'label'     	=> esc_html__( 'Site Logo Options', 'bizindustries' ),
		'section'   	=> 'title_tagline',
		'type'      	=> 'radio',
		'description'	=> esc_html__( 'Choose your preferred option.', 'bizindustries' ),
		'choices'   => array (
			'logo-only'     => esc_html__( 'Display logo image only.', 'bizindustries' ),
			'title-only' 	=> esc_html__( 'Display Site title only.', 'bizindustries' ),
			'title-img' 	=> esc_html__( 'Display logo image & Site title.', 'bizindustries' ),
			'title-desc' 	=> esc_html__( 'Display site title & tagline.', 'bizindustries' )
		)
	)
);

// Title Font family
$wp_customize->add_setting( 'site_title_font_family',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_choices',
		'default'           => '',
		'transport'			=> 'postMessage',
	)
);
$wp_customize->add_control( 'site_title_font_family', 
	array(
		'type'     => 'select',
		'label'    => esc_html__( 'Site Title Font Family','bizindustries'),
		'section'  => 'title_tagline',
		'choices'  => $font_array,
		'active_callback' 		=> 'callback_bizindustries_site_title'
	)
);

// Site Title Font Size
$wp_customize->add_setting( 'site_title_font_size',
	array(
        'sanitize_callback' => 'bizindustries_sanitize_number_range',
		'default'           => '',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control( new Bizindusties_Customizer_Range_Value_Control( 
	$wp_customize, 'site_title_font_size', 
		array(
			'type'          => 'range',
			'section'       => 'title_tagline',
			'label'         => esc_html__( 'Site Title Font Size', 'bizindustries' ),
			'input_attrs'    => array(
				'min'    => 12,
				'max'    => 60,
				'step'   => 1,
				'suffix' => 'px', //optional suffix
			),
			'active_callback' 		=> 'callback_bizindustries_site_title'
		)
	)
);

// Site Title Color
$wp_customize->add_setting( 'site_title_color',
	array(
		'sanitize_callback'    => 'sanitize_hex_color_no_hash',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => ''
	) );
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'site_title_color',
		array(
			'label'       => esc_html__( 'Site Title Color', 'bizindustries' ),
			'section'     => 'title_tagline',
			//'description' => esc_html__( 'Only set if you don\'t use an image logo.', 'bizindustries' ),
			'active_callback' 		=> 'callback_bizindustries_site_title'
		)
	) 
);

// Tagline Font family
$wp_customize->add_setting( 'tagline_font_family',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_choices',
		'default'           => '',
		'transport'			=> 'postMessage',
	)
);
$wp_customize->add_control( 'tagline_font_family', 
	array(
		'type'     => 'select',
		'label'    => esc_html__( 'Tagline Font Family','bizindustries'),
		'section'  => 'title_tagline',
		'choices'  => $font_array,
		'active_callback' 		=> 'callback_bizindustries_logo_tagline'
	)
);

// Title Font Size
$wp_customize->add_setting( 'tagline_font_size',
	array(
        'sanitize_callback' => 'bizindustries_sanitize_number_range',
		'default'           => '',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control( new Bizindusties_Customizer_Range_Value_Control( 
	$wp_customize, 'tagline_font_size', 
		array(
			'type'          => 'range',
			'section'       => 'title_tagline',
			'label'         => esc_html__( 'Tagline Font Size', 'bizindustries' ),
			'input_attrs'    => array(
				'min'    => 8,
				'max'    => 36,
				'step'   => 1,
				'suffix' => 'px', //optional suffix
			),
			'active_callback' 		=> 'callback_bizindustries_logo_tagline'
		)
	)
);

//Tagline Color
$wp_customize->add_setting( 'tagline_text_color',
	array(
		'sanitize_callback'    => 'sanitize_hex_color_no_hash',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => ''
	) );
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'tagline_text_color',
		array(
			'label'       => esc_html__( 'Tagline Color', 'bizindustries' ),
			'section'     => 'title_tagline',
			'description' => '',
			'active_callback' 	=> 'callback_bizindustries_logo_tagline'
		)
	) 
);

// Site Title Callback
function callback_bizindustries_site_title() {
	
	if ( 'title-only' == get_theme_mod( 'site_logo_option') || 'title-desc' == get_theme_mod( 'site_logo_option' ) || 'title-img' == get_theme_mod( 'site_logo_option' ) ) {
		return true;
	} else {
		return false;
	}
	
}
// Site Tagline Callback
function callback_bizindustries_logo_tagline() {
	
	if ( 'title-desc' == get_theme_mod( 'site_logo_option' ) ) {
		return true;
	} else {
		return false;
	}
	
}
