<?php

/* Single Settings
----------------------------------------------------------------------*/
$wp_customize->add_section( 'single_post_settings',
	array(
		'priority'    => 8,
		'title'       => esc_html__( 'Single Post Settings', 'bizindustries' ),
		'description' => '',
		'panel'       => 'bizindustries_theme_options',
	)
);

// Blog Layout settings
$wp_customize->add_setting( 'blog_single_layout',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => 'right-sidebar',
		//'transport'			=> 'postMessage'
	)
);

$wp_customize->add_control( 'blog_single_layout',
	array(
		'type'        => 'select',
		'label'       => esc_html__( 'Single post page layout', 'bizindustries' ),
		'description' => esc_html__( 'Single post page Layout, apply for single blog post page only.', 'bizindustries' ),
		'section'     => 'single_post_settings',
		'choices'     => array(
			'right-sidebar' => esc_html__( 'Right sidebar', 'bizindustries' ),
			'left-sidebar'  => esc_html__( 'Left sidebar', 'bizindustries' ),
			'no-sidebar'    => esc_html__( 'No sidebar', 'bizindustries' ),
		)
	)
);

// Thumbnail
$wp_customize->add_setting( 'single_post_thumb_display',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => 1,
	)
);
$wp_customize->add_control( 'single_post_thumb_display',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Display post thumbnail', 'bizindustries' ),
		'section'     => 'single_post_settings',
		'description' => esc_html__( 'Check this box to show post thumbnail on single post.', 'bizindustries' )
	)
);

// Display Post Meta.
$wp_customize->add_setting( 'single_post_meta_display',
	array(
		'default'			=> 1,
		'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control( 'single_post_meta_display',
	array(
		'section'		=> 'single_post_settings',
		'type'			=> 'checkbox',
		'label'			=> __( 'Display post meta.', 'bizindustries' ),
		'description'	=> __( 'Check/Uncheck to show/hide post meta such as post date, author, category...', 'bizindustries' )
	)
);	

// Display Post Date
$wp_customize->add_setting(
	'single_post_date_display',
	array(
		'default'			=> 1,
		'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control(
	'single_post_date_display',
	array(
		'label'			=> esc_html__( 'Display post date.', 'bizindustries' ),
		'section'		=> 'single_post_settings',
		'type'			=> 'checkbox',
		'description'	=> esc_html__( 'Check/Uncheck this box to show/hide post date', 'bizindustries' )
	)
);

	// Display Related Post
	$wp_customize->add_setting( 'related_post_display',
		array(
			'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			'default'           => 1,
		)
	);
	$wp_customize->add_control( 'related_post_display',
		array(
			'type'        => 'checkbox',
			'label'       => esc_html__( 'Display related posts', 'bizindustries' ),
			'section'     => 'single_post_settings',
			'description' => esc_html__( 'Check/uncheck this box to show/hide related posts.', 'bizindustries' )
		)
	);

	/** Related Posts label */
	$wp_customize->add_setting( 'related_posts_label',
		array(
			'default'           => esc_html__( 'You May Also Like...', 'bizindustries' ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control( 'related_posts_label',
		array(
			'label'         => esc_html__( 'Related Posts Title', 'bizindustries' ),
			'description'   => esc_html__( 'Option to change title for related posts.', 'bizindustries' ),
			'section'       => 'single_post_settings',
			'type'          => 'text',
			'active_callback' =>function () {
				if ( get_theme_mod( 'related_post_display' ) ) {
					return true;
				} else {
					return false;
				}
			}
		)
	);

	// Related Post Choice
	$wp_customize->add_setting( 'related_post_choice',
		 array(
			'default'   => 'category',
			'sanitize_callback' => 'bizindustries_sanitize_choices',
		)
	);
	$wp_customize->add_control( 'related_post_choice', 
		array(
			'label'    => esc_html__( 'Display Related Posts By:', 'bizindustries' ),
			'section'  => 'single_post_settings',
			'type'     => 'radio',
			'choices'  => array(
				'category' => esc_html__( 'Categories ', 'bizindustries' ),
				'choice2' => esc_html__( 'Tags', 'bizindustries' ),
			),
			'active_callback' =>function () {
				if ( get_theme_mod( 'related_post_display') ) {
					return true;
				} else {
					return false;
				}
			}
		)
	);
