<?php

/**
 * Page Settings
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */
$wp_customize->add_section( 'page_settings',
	array(
		'priority'    => 9,
		'title'       => esc_html__( 'Page Settings', 'bizindustries' ),
		'panel'       => 'bizindustries_theme_options',
	)
);

// Page Layout
$wp_customize->add_setting( 'page_layout',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => 'no-sidebar',
	)
);
$wp_customize->add_control( 'page_layout',
	array(
		'type'        => 'select',
		'label'       => esc_html__( 'Page Layout', 'bizindustries' ),
		'description' => esc_html__( 'Page Layout, apply for all pages, exclude blog related pages and custom page templates.', 'bizindustries' ),
		'section'     => 'page_settings',
		'choices'     => array(
			'right-sidebar' => esc_html__( 'Right sidebar', 'bizindustries' ),
			'left-sidebar'  => esc_html__( 'Left sidebar', 'bizindustries' ),
			'no-sidebar'    => esc_html__( 'No sidebar', 'bizindustries' ),
		)
	)
);

// Display comments on page.
$wp_customize->add_setting( 'page_comments_display',
	array(
		'default'			=> 1,
		'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control( 'page_comments_display',
	array(
		'label'			=> esc_html__( 'Display page comments.', 'bizindustries' ),
		'section'		=> 'page_settings',
		'type'			=> 'checkbox',
		'description'	=> esc_html__( 'Check/Uncheck this box to show/hide comments on page', 'bizindustries' )
	)
);