<?php
/* Header
----------------------------------------------------------------------*/
$wp_customize->add_section( 'bizindustries_header_settings',
	array(
		'title'       => esc_html__( 'Header Settings', 'bizindustries' ),
		'description' => '',
		'panel'       => 'bizindustries_theme_options',
		'priority'    => 4,
	)
);

$wp_customize->add_setting( 'header_top_display', 
	array(
	  'default'           =>  false,
	  'sanitize_callback' => 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control( 'header_top_display', 
	array(
	  'label'         => esc_html__( 'Show/hide header top', 'bizindustries' ),
	  'description'   => esc_html__( 'Check/Uncheck this box to show/hide header top bar.', 'bizindustries' ),
	  'section'       => 'bizindustries_header_settings',
	  'type'          => 'checkbox',
	)
);


// Header Style
if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
	$wp_customize->add_setting( 'header_style',
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => 'style-2',
			//'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control( 'header_style',
		array(
			'type'    => 'select',
			'label'   => esc_html__( 'Header style', 'bizindustries' ),
			'section' => 'bizindustries_header_settings',
			'choices' => array(
				'style-1' => esc_html__( 'Style One', 'bizindustries' ),
				'style-2'  => esc_html__( 'Style Two', 'bizindustries' ),
			),
			'active_callback' => function(){
				 if(get_theme_mod('header_top_display')){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	);
}
// Header container width.
$wp_customize->add_setting(
	'header_container_width',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => 'container',
		//'transport'         => 'postMessage',
	)
);

$wp_customize->add_control(
	'header_container_width',
	array(
		'type'    => 'select',
		'label'   => esc_html__( 'Header container width', 'bizindustries' ),
		'section' => 'bizindustries_header_settings',
		'choices' => array(
			'container-fluid' => esc_html__( 'Full Width', 'bizindustries' ),
			'container'  => esc_html__( 'Contained', 'bizindustries' ),
		),
	)
);
if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
// Disable Sticky Header
$wp_customize->add_setting( 'site_sticky_header',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => true,
	)
);
$wp_customize->add_control( 'site_sticky_header',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Make Header Sticky', 'bizindustries' ),
		'section'     => 'bizindustries_header_settings',
		'description' => esc_html__( 'Check/uncheck this box to enable/disable sticky header when scroll.', 'bizindustries' ),
		'active_callback' => function(){
			 if(get_theme_mod('header_top_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);
}
// Display Phone Number
$wp_customize->add_setting( 'header_display_phone',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => true,
	)
);
$wp_customize->add_control( 'header_display_phone',
	array(
	'type'        => 'checkbox',
		'label'       => esc_html__( 'Display Phone Number?', 'bizindustries' ),
		'section'     => 'bizindustries_header_settings',
		'description' => esc_html__( 'Check/uncheck this box to show/hide phone number on header top area.', 'bizindustries' ),
		'active_callback' => function(){
			 if(get_theme_mod('header_top_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);

// Phone Number
$wp_customize->add_setting( 'header_phone',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => esc_html__( '123-456-7890', 'bizindustries' ),
		'transport'			=> 'postMessage'
	)
);
$wp_customize->add_control( 'header_phone',
	array(
		'label'       => esc_html__( 'Phone', 'bizindustries' ),
		'description' => '',
		'type'        => 'text',
		'section'     => 'bizindustries_header_settings',
		'active_callback' => function(){
			 if(get_theme_mod('header_top_display') && get_theme_mod('header_display_phone')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);
$wp_customize->selective_refresh->add_partial( 'header_phone', array(
	'selector'        => '.top-info .phone',
	'render_callback' => 'bizindustries_get_phone',
) );


// Display email address
$wp_customize->add_setting( 'header_display_email',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => true,
	)
);
$wp_customize->add_control( 'header_display_email',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Display email address?', 'bizindustries' ),
		'section'     => 'bizindustries_header_settings',
		'description' => esc_html__( 'Check/uncheck this box to show/hide email address on header top area.', 'bizindustries' ),
		'active_callback' => function(){
			 if(get_theme_mod('header_top_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);

// Phone Number
$wp_customize->add_setting( 'header_email',
	array(
		'sanitize_callback' => 'sanitize_email',
		'default'           => esc_html__( 'help@bizindustries.com', 'bizindustries' ),
		'transport'			=> 'postMessage'
	)
);
$wp_customize->add_control( 'header_email',
	array(
		'label'       => esc_html__( 'Email Address', 'bizindustries' ),
		'description' => '',
		'type'        => 'text',
		'section'     => 'bizindustries_header_settings',
		'active_callback' => function(){
			 if(get_theme_mod('header_top_display') && get_theme_mod('header_display_email')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);
$wp_customize->selective_refresh->add_partial( 'header_email', array(
	'selector'        => '.top-info .email',
	'render_callback' => 'bizindustries_get_email',
) );

// Display top menu
$wp_customize->add_setting( 'header_secondary_nav_display',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => false,
	)
);
$wp_customize->add_control( 'header_secondary_nav_display',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Display secondry menu?', 'bizindustries' ),
		'section'     => 'bizindustries_header_settings',
		'description' => esc_html__( 'Check/uncheck this box to show/hide secondary menu on header top area', 'bizindustries' ),
		'active_callback' => function(){
			 if(get_theme_mod('header_top_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);

// Display Solical Icons
$wp_customize->add_setting( 'header_social_icon_display',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => false,
	)
);
$wp_customize->add_control( 'header_social_icon_display',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Display social icons?', 'bizindustries' ),
		'section'     => 'bizindustries_header_settings',
		'description' => esc_html__( 'Check/uncheck this box to show/hide social icons on header top area.', 'bizindustries' ),
		'active_callback' => function(){
			 if(get_theme_mod('header_top_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);

// Social Repeater 
$wp_customize->add_setting( 
	new Bizindustries_Control_Repeater_Setting( 
		$wp_customize, 
		'social_links', 
		array(
			'default' => '',
			'sanitize_callback' => array( 'Bizindustries_Control_Repeater_Setting', 'sanitize_repeater_setting' ),
		) 
	) 
);

$wp_customize->add_control(
	new Bizindustries_Control_Repeater(
		$wp_customize,
		'social_links',
		array(
			'section'       => 'bizindustries_header_settings',
			'label'         => esc_html__( 'Social Links', 'bizindustries' ),
			'fields'  => array(
				'icon' => array(
					'type'        => 'select',
					'label'       => esc_html__( 'Social Media', 'bizindustries' ),
					'choices'     => bizindustries_get_social_icons()
				),
				'link' => array(
					'type'        => 'url',
					'label'       => esc_html__( 'Link', 'bizindustries' ),
					'description' => esc_html__( 'Example: https://facebook.com', 'bizindustries' ),
				),
				'checkbox' => array(
					'type'        => 'checkbox',
					'label'       => esc_html__( 'Open link in new tab', 'bizindustries' ),
				)
			),
			'row_label' => array(
				'type'  => 'field',
				'value' => esc_html__( 'links', 'bizindustries' ),
				'field' => 'link'
			),
			'active_callback' => function(){
				 if( get_theme_mod('header_social_icon_display') && get_theme_mod('header_top_display') ){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	)
);

// Display Cart Icons
$wp_customize->add_setting( 'header_cart_icon_display',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => true,
	)
);
$wp_customize->add_control( 'header_cart_icon_display',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Display cart icon?', 'bizindustries' ),
		'section'     => 'bizindustries_header_settings',
		'description' => esc_html__( 'Check/uncheck this box to show/hide cart icons on header area.', 'bizindustries' ),
	)
);

// Display top menu
$wp_customize->add_setting( 'header_search_icon_display',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => true,
	)
);
$wp_customize->add_control( 'header_search_icon_display',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Display Search Icon?', 'bizindustries' ),
		'section'     => 'bizindustries_header_settings',
		'description' => esc_html__( 'Check/uncheck this box to show/hide search icon on header area', 'bizindustries' ),
	)
);

// Header BG Color
$wp_customize->add_setting( 'header_top_bg_color',
	array(
		'sanitize_callback'    => 'sanitize_hex_color_no_hash',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => ''
	) 
);
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'header_top_bg_color',
		array(
			'label'                 => esc_html__( 'Header top background', 'bizindustries' ),
			'section'               => 'bizindustries_header_settings',
		    'description' => esc_html__( 'Set background color for header top area', 'bizindustries' ),
			'active_callback' => function(){
				 if(get_theme_mod('header_top_display')){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	) 
);

/* Banner Image
----------------------------------------------------------------------
*/
// Page Banner Image 
$wp_customize->add_setting( 'bizindustries_page_banner',
	array(
		'default'           => get_template_directory_uri() . '/assets/img/banner/banner.jpg',
		'sanitize_callback' => 'bizindustries_sanitize_image',
	)
);
$wp_customize->add_control( 
	new WP_Customize_Image_Control( $wp_customize, 'bizindustries_page_banner',
		array(
			'label'         => esc_html__( 'Page Banner Image ', 'bizindustries' ),
			'description'   => esc_html__( 'Upload Banner Image for Pages. Recommended size is 1920px by 375px.', 'bizindustries' ),
			'section'       => 'header_image',
			'type'          => 'image',
		)
	)
);

// Archive Banner Image 
$wp_customize->add_setting( 'bizindustries_archive_banner',
	array(
		'default'           => get_template_directory_uri() . '/assets/img/banner/banner.jpg',
		'sanitize_callback' => 'bizindustries_sanitize_image',
	)
);
$wp_customize->add_control( 
	new WP_Customize_Image_Control( $wp_customize, 'bizindustries_archive_banner',
		array(
			'label'         => esc_html__( 'Archive Page Banner Image ', 'bizindustries' ),
			'description'   => esc_html__( 'Upload Banner Image for Archive Pages. Recommended size is 1920px by 375px.', 'bizindustries' ),
			'section'       => 'header_image',
			'type'          => 'image',
		)
	)
);

// Search Banner Image 
$wp_customize->add_setting( 'bizindustries_search_banner',
	array(
		'default'           => get_template_directory_uri() . '/assets/img/banner/banner.jpg',
		'sanitize_callback' => 'bizindustries_sanitize_image',
	)
);
$wp_customize->add_control( 
	new WP_Customize_Image_Control( $wp_customize, 'bizindustries_search_banner',
		array(
			'label'         => esc_html__( 'Search Page Banner Image', 'bizindustries' ),
			'description'   => esc_html__( 'Upload Banner Image for Search Page. Recommended size is 1920px by 375px', 'bizindustries' ),
			'section'       => 'header_image',
			'type'          => 'image',
		)
	)
);

// 404 Banner Image 
$wp_customize->add_setting( 'bizindustries_404_banner',
	array(
		'default'           => get_template_directory_uri() . '/assets/img/banner/banner.jpg',
		'sanitize_callback' => 'bizindustries_sanitize_image',
	)
);
$wp_customize->add_control( 
	new WP_Customize_Image_Control( $wp_customize, 'bizindustries_404_banner',
		array(
			'label'         => esc_html__( '404 Page Banner Image', 'bizindustries' ),
			'description'   => esc_html__( 'Upload Banner Image for 404 Page. Recommended size is 1920px by 375px', 'bizindustries' ),
			'section'       => 'header_image',
			'type'          => 'image',
		)
	)
);
