<?php
/* Global Settings
----------------------------------------------------------------------*/
$wp_customize->add_section( 'bizindustries_global_settings',
	array(
		'priority'    => 1,
		'title'       => esc_html__( 'Global Settings', 'bizindustries' ),
		'panel'       => 'bizindustries_theme_options',
	)
);

// Animations
$wp_customize->add_setting( 'bizindustries_animation_disable',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => true,
	)
);
$wp_customize->add_control( 'bizindustries_animation_disable',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Enable animation effect', 'bizindustries' ),
		'section'     => 'bizindustries_global_settings',
		'description' => esc_html__( 'Check/Uncheck this box to ebabke/disable all elements animation when scroll.', 'bizindustries' )
	)
);

// Preloader Disable
$wp_customize->add_setting( 'bizindustries_preloader_display',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => false,
	)
);
$wp_customize->add_control( 'bizindustries_preloader_display',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Show Preloader', 'bizindustries' ),
		'section'     => 'bizindustries_global_settings',
		'description' => esc_html__( 'Check/Uncheck this box to show/hide preloader.', 'bizindustries' )
	)
);

// Display Phone Number
$wp_customize->add_setting( 'preloader_text',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => __('Bizindustries Ltd', 'bizindustries'),
	)
);
$wp_customize->add_control( 'preloader_text',
	array(
		'type'        => 'text',
		'label'       => esc_html__( 'Preloading Text', 'bizindustries' ),
		'section'     => 'bizindustries_global_settings',
		'active_callback' => function(){
			 if(get_theme_mod('bizindustries_preloader_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);

// BG Color
$wp_customize->add_setting( 'preloader_bg_color',
	array(
		'sanitize_callback'    => 'sanitize_hex_color_no_hash',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '#062C3C'
	) 
);
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'preloader_bg_color',
		array(
			'label'                 => esc_html__( 'Preloader background', 'bizindustries' ),
			'section'               => 'bizindustries_global_settings',
			'active_callback' => function(){
				 if(get_theme_mod('bizindustries_preloader_display')){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	) 
);

// Backto Top Disable
$wp_customize->add_setting( 'bizindustries_backto_top_display',
	array(
		'sanitize_callback' => 'bizindustries_sanitize_checkbox',
		'default'           => true,
	)
);
$wp_customize->add_control( 'bizindustries_backto_top_display',
	array(
		'type'        => 'checkbox',
		'label'       => esc_html__( 'Display Back to Top Button', 'bizindustries' ),
		'section'     => 'bizindustries_global_settings',
		'description' => esc_html__( 'Check/uncheck this box to show/hide back to top button.', 'bizindustries' )
	)
);


