<?php


/* Footer Widgets Settings
----------------------------------------------------------------------*/
$wp_customize->add_section( 'footer_widgets_settings',
	array(
		'title'       => esc_html__( 'Footer Settings', 'bizindustries' ),
		'panel'       => 'bizindustries_theme_options',
		'priority'    => 11,
	)
);

// Widget Layout
$wp_customize->add_setting( 'footer_layout',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '',
		// 'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'footer_layout',
	array(
		'type'        => 'select',
		'label'       => esc_html__( 'Wigets Layout', 'bizindustries' ),
		'section'     => 'footer_widgets_settings',
		'description' => esc_html__( 'Number footer columns to display.', 'bizindustries' ),
		'choices'     => array(
			'4' => 4,
			'3' => 3,
			'2' => 2,
			'1' => 1,
			'0' => esc_html__( 'Disable footer widgets', 'bizindustries' ),
		)
	)
);

for ( $i = 1; $i <= 4; $i ++ ) {
	$df = 12;
	if ( $i > 1 ) {
		$_n = 12 / $i;
		$df = array();
		for ( $j = 0; $j < $i; $j ++ ) {
			$df[ $j ] = $_n;
		}
		$df = join( '+', $df );
	}
	$wp_customize->add_setting( 'footer_custom_' . $i . '_columns',
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => $df,
		)
	);
	$wp_customize->add_control( 'footer_custom_' . $i . '_columns',
		array(
		    /* translators: Custom footer columns width */
			'label'       => $i == 1 ? __( 'Custom footer 1 column width', 'bizindustries' ) : sprintf( __( 'Custom footer %s columns width', 'bizindustries' ), $i ),
			'section'     => 'footer_widgets_settings',
			'description' => esc_html__( 'Enter int numbers and sum of them must smaller or equal 12, separated by "+"', 'bizindustries' ),
		)
	);
}

// Widget Background
$wp_customize->add_setting( 'footer_widgets_bg_color',
	array(
		'sanitize_callback' => 'sanitize_hex_color',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'           => '#07364a',
	)
);
$wp_customize->add_control( new WP_Customize_Color_Control(
		$wp_customize,
		'footer_widgets_bg_color',
		array(
			'label'   => esc_html__( 'Background Color', 'bizindustries' ),
			'section' => 'footer_widgets_settings',
			'active_callback' => function(){
				 $footer_layout = get_theme_mod('footer_layout');
				 if('0' !=$footer_layout){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	)
);

// Widget Title Color
$wp_customize->add_setting( 'footer_widgets_title_color',
	array(
		'sanitize_callback' => 'sanitize_hex_color',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'           => '',
	)
);
$wp_customize->add_control( new WP_Customize_Color_Control(
		$wp_customize,
		'footer_widgets_title_color',
		array(
			'label'   => esc_html__( 'Title Color', 'bizindustries' ),
			'section' => 'footer_widgets_settings',
			'active_callback' => function(){
				 $footer_layout = get_theme_mod('footer_layout');
				 if('0' !=$footer_layout){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	)
);

// Copyright Text Color
$wp_customize->add_setting( 'footer_widgets_text_color', 
	array(
		'sanitize_callback'    => 'sanitize_hex_color',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '',
	) 
);
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'footer_widgets_text_color',
		array(
			'label'       => esc_html__( 'Text Color', 'bizindustries' ),
			'section'     => 'footer_widgets_settings',
			'description' => '',
			'active_callback' => function(){
				 $footer_layout = get_theme_mod('footer_layout');
				 if('0' !=$footer_layout){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	) 
);

// Widgets Link Color
$wp_customize->add_setting( 'footer_widgets_link_color',
	array(
		'sanitize_callback'    => 'sanitize_hex_color',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '',
	) 
);
$wp_customize->add_control( new WP_Customize_Color_Control(
	$wp_customize, 'footer_widgets_link_color',
		array(
			'label'       => esc_html__( 'Link Color', 'bizindustries' ),
			'section'     => 'footer_widgets_settings',
			'description' => '',
			'active_callback' => function(){
				 $footer_layout = get_theme_mod('footer_layout');
				 if('0' !=$footer_layout){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	) 
);

// Widget Link Hover Color
$wp_customize->add_setting( 'footer_widgets_link_hcolor', 
	array(
		'sanitize_callback'    => 'sanitize_hex_color',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '',
	) 
);
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'footer_widgets_link_hcolor',
		array(
			'label'       => esc_html__( 'Link Hover Color', 'bizindustries' ),
			'section'     => 'footer_widgets_settings',
			'description' => '',
			'active_callback' => function(){
				 $footer_layout = get_theme_mod('footer_layout');
				 if('0' !=$footer_layout){
					return true;
				 } else {
					 return false;
				 }
			},
		)
	) 
);

/* Footer Copyright Settings
----------------------------------------------------------------------*/

$wp_customize->add_section( 'footer_copyright_settings',
	array(
		'title'       => esc_html__( 'Copyright Info', 'bizindustries' ),
		'description' => '',
		'panel'       => 'bizindustries_theme_options',
		'priority'    => 12,
	)
);

// Copyright Text
$wp_customize->add_setting( 'footer_copyright_text',
	 array(
	    'default'			  => '',
		'transport'			  => 'postMessage',
		'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('footer_copyright_text',
	array(
		'label'    => esc_html__('Copyright Text', 'bizindustries'),
		'section'  => 'footer_copyright_settings',
		'type'     => 'text'
	)
);


// Copyright Background Color
$wp_customize->add_setting( 'footer_copyright_bg_color',
	array(
		'sanitize_callback'    => 'sanitize_hex_color',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '',
	)
);
$wp_customize->add_control( new WP_Customize_Color_Control(
	$wp_customize, 'footer_copyright_bg_color',
		array(
			'label'       => esc_html__( 'Background Color', 'bizindustries' ),
			'section'     => 'footer_copyright_settings',
			'description' => '',
		)
	) 
);

// Copyright Text Color
$wp_customize->add_setting( 'footer_copyright_text_color', 
	array(
		'sanitize_callback'    => 'sanitize_hex_color',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '',
	) 
);
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'footer_copyright_text_color',
		array(
			'label'       => esc_html__( 'Text Color', 'bizindustries' ),
			'section'     => 'footer_copyright_settings',
			'description' => '',
		)
	) 
);


