<?php
/* Colors
----------------------------------------------------------------------*/
$wp_customize->add_section( 'site_color_settings',
	array(
		'priority'    => 2,
		'title'       => esc_html__( 'Color Settings', 'bizindustries' ),
		'description' => '',
		'panel'       => 'bizindustries_theme_options',
	)
);

// Primary Color
$wp_customize->add_setting( 'site_primary_color', array(
		'sanitize_callback'    => 'sanitize_hex_color_no_hash',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '#ea5151'
	)
);
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'site_primary_color',
		array(
			'label'       => esc_html__( 'Primary Color', 'bizindustries' ),
			'section'     => 'site_color_settings',
			'description' => '',
		)
	) 
);

// Secondary Color
$wp_customize->add_setting( 'site_secondary_color', array(
		'sanitize_callback'    => 'sanitize_hex_color_no_hash',
		'sanitize_js_callback' => 'maybe_hash_hex_color',
		'default'              => '#07364a'
	)
);
$wp_customize->add_control( new WP_Customize_Color_Control( 
	$wp_customize, 'site_secondary_color',
		array(
			'label'       => esc_html__( 'Secondary Color', 'bizindustries' ),
			'section'     => 'site_color_settings',
			'description' => '',
		)
	) 
);
if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
	// Heading Color
	$wp_customize->add_setting( 'site_heading_color', 
		array(
			'sanitize_callback'	=> 'sanitize_hex_color',
			'default' => '#112034',
			'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'site_heading_color', 
			array(
				'label' => esc_html__('Headings Color', 'bizindustries'),
				'section' => 'site_color_settings',
			)
		)
	);

	// Body Text Color
	$wp_customize->add_setting( 'body_text_color', 
		array(
			'sanitize_callback'	=> 'sanitize_hex_color',
			'default'           => '#232D41',
			'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'body_text_color', 
			array(
				'label'   => esc_html__('Body Text Color', 'bizindustries'),
				'section' => 'site_color_settings',
			)
		)
	);

	// Button BG Color
	$wp_customize->add_setting( 'site_btn_bg_color', array(
			'sanitize_callback'    => 'sanitize_hex_color_no_hash',
			'sanitize_js_callback' => 'maybe_hash_hex_color',
			'default'              => '#ea5151'
		)
	);
	$wp_customize->add_control( new WP_Customize_Color_Control( 
		$wp_customize, 'site_btn_bg_color',
			array(
				'label'       => esc_html__( 'Button BG Color', 'bizindustries' ),
				'section'     => 'site_color_settings',
				'description' => '',
			)
		) 
	);

	// Button BG Hover Color
	$wp_customize->add_setting( 'site_btn_bg_hcolor', array(
			'sanitize_callback'    => 'sanitize_hex_color_no_hash',
			'sanitize_js_callback' => 'maybe_hash_hex_color',
			'default'              => '#07364A'
		)
	);
	$wp_customize->add_control( new WP_Customize_Color_Control( 
		$wp_customize, 'site_btn_bg_hcolor',
			array(
				'label'       => esc_html__( 'Button Hover BG Color', 'bizindustries' ),
				'section'     => 'site_color_settings',
				'description' => '',
			)
		) 
	);
	
	// Button Text Color
	$wp_customize->add_setting( 'site_btn_text_color', 
		array(
			'sanitize_callback'	=> 'sanitize_hex_color',
			'default'           => '',
			'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'site_btn_text_color', 
			array(
				'label'   => esc_html__('Button Text Color', 'bizindustries'),
				'section' => 'site_color_settings',
			)
		)
	);
	// Button Hover text color
	$wp_customize->add_setting( 'site_btn_hover_text_color', 
		array(
			'sanitize_callback'	=> 'sanitize_hex_color',
			'default'           => '',
			'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'site_btn_hover_text_color', 
			array(
				'label'   => esc_html__('Button Hover Text Color', 'bizindustries'),
				'section' => 'site_color_settings',
			)
		)
	);
}
if(false==bizindustries_set_to_premium()){
	// Know more for options
	$wp_customize->add_setting(
		'typo_note_control',
		array(
			'default'           => '',
			'sanitize_callback' => 'wp_kses_post' 
		)
	);
	$wp_customize->add_control(
		new Bizindustries_Note_Control( 
			$wp_customize,
			'typo_note_control',
			array(
				'section'	  => 'site_color_settings',
				 /* translators: %s: More Color Options: */
				'description' => sprintf( __( 'More Color Options: %1$sKnow More.%2$s', 'bizindustries' ), '<a href="' . esc_url( 'https://bootitems.com/bizindustries/' ) . '" target="_blank">', '</a>' ),
			)
		)
	);
}