<?php
/**
 * Blog Post Settings
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */
$wp_customize->add_section( 'blog_settings',
	array(
		'priority'    => 7,
		'title'       => esc_html__( 'Blog/Archive Settings', 'bizindustries' ),
		'description' => '',
		'panel'       => 'bizindustries_theme_options',
		)
);

// Blog Page Title
$wp_customize->add_setting( 'blog_page_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => esc_html__( 'News & Resources', 'bizindustries' ),
		'transport'         => 'postMessage',
	)
);
$wp_customize->add_control( 'blog_page_title',
	array(
		'label'       => esc_html__( 'Blog Page Title', 'bizindustries' ),
		'section'     => 'blog_settings',
	)
);

// Blog Layout settings
$wp_customize->add_setting( 'blog_layout',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => 'right-sidebar',
	)
);
$wp_customize->add_control( 'blog_layout',
	array(
		'type'        => 'select',
		'label'       => esc_html__( 'Blog Page Layout', 'bizindustries' ),
		'description' => esc_html__( 'Blog page layout, apply for all blog related pages such as blog, archieve and search page.', 'bizindustries' ),
		'section'     => 'blog_settings',
		'choices'     => array(
			'right-sidebar' => esc_html__( 'Right sidebar', 'bizindustries' ),
			'left-sidebar'  => esc_html__( 'Left sidebar', 'bizindustries' ),
			'no-sidebar'    => esc_html__( 'No sidebar', 'bizindustries' ),
		)
	)
);

// Post Column settings
$wp_customize->add_setting( 'blog_columns',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => 'two-columns',
	)
);
$wp_customize->add_control( 'blog_columns',
	array(
		'type'        => 'select',
		'label'       => esc_html__( 'Posts Column', 'bizindustries' ),
		'description' => esc_html__( 'Select number of columns that you want to show on blog relaged pages. ', 'bizindustries' ),
		'section'     => 'blog_settings',
		'choices'     => array(
			'three-columns' => esc_html__( 'Three Columns', 'bizindustries' ),
			'two-columns'  => esc_html__( 'Two Columns', 'bizindustries' ),
			'single-column'    => esc_html__( 'Single Column', 'bizindustries' ),
		)
	)
);

// Blog Style settings
$wp_customize->add_setting( 'blog_post_style',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => 'masonry',
	)
);
$wp_customize->add_control( 'blog_post_style',
	array(
		'type'        => 'select',
		'label'       => esc_html__( 'Post Style', 'bizindustries' ),
		'section'     => 'blog_settings',
		'choices'     => array(
			'masonry' => esc_html__( 'Masonry', 'bizindustries' ),
			'equal-height'  => esc_html__( 'Equal Height', 'bizindustries' ),
		)
	)
);

// Display Post Thumbnail.
$wp_customize->add_setting( 'post_thumbnail_display',
	array(
		'default'			=> true,
		'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control( 'post_thumbnail_display',
	array(
		'section'		=> 'blog_settings',
		'type'			=> 'checkbox',
		'label'			=> __( 'Display blog post thumbnails.', 'bizindustries' ),
		'description'	=> __( 'Check/Uncheck this box to show/hide post thumbnails on main blog page', 'bizindustries' )
	)
);	

// Display Post Content.
$wp_customize->add_setting( 'post_content_display',
	array(
		'default'			=> true,
		'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control( 'post_content_display',
	array(
		'section'		=> 'blog_settings',
		'type'			=> 'checkbox',
		'label'			=> __( 'Display post excerpts', 'bizindustries' ),
		'description'	=> __( 'Check/Uncheck this box to show/hide post content', 'bizindustries' )
	)
);

// Excerpt count control and setting
$wp_customize->add_setting( 'post_excerpt_count', 
	array(
		'sanitize_callback' => 'bizindustries_sanitize_number_range',
		'validate_callback' => 'validate_excerpt_count',
		'default'          	=> 20,
	) 
);
$wp_customize->add_control( 'post_excerpt_count', 
	array(
		'label'             => esc_html__( 'Excerpt Length', 'bizindustries' ),
		'description'       => esc_html__( 'Note: Min 1 & Max 50.', 'bizindustries' ),
		'section'           => 'blog_settings',
		'type'				=> 'number',
		'input_attrs'		=> array(
			'min'	=> 1,
			'max'	=> 50,
			),
		'active_callback' => function(){
			 if(get_theme_mod('post_content_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	) 
);

// Post dots
$wp_customize->add_setting( 'post_excerpt_dots',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '',
	)
);
$wp_customize->add_control( 'post_excerpt_dots',
	array(
		'label'       => esc_html__( 'Excerpt Suffix', 'bizindustries' ),
		'section'     => 'blog_settings',
		'description'       => esc_html__( 'Defines the three dots \'[...]\' that are appended automatically to excerpts.', 'bizindustries' ),
		'active_callback' => function(){
			 if(get_theme_mod('post_content_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);

// Display Read More
$wp_customize->add_setting( 'post_readmore_display',
	array(
		'default'			=> true,
		'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control( 'post_readmore_display',
	array(
		'section'		=> 'blog_settings',
		'type'			=> 'checkbox',
		'label'			=> __( 'Display read more', 'bizindustries' ),
		'description'	=> __( 'Check/Uncheck this box to show/hide read more button', 'bizindustries' )
	)
);

// Read More text
$wp_customize->add_setting( 'post_read_more_text',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => esc_html__( 'Read More', 'bizindustries' ),
		'transport'			=> 'postMessage'
	)
);
$wp_customize->add_control( 'post_read_more_text',
	array(
		'label'       => esc_html__( 'Read More Text', 'bizindustries' ),
		'section'     => 'blog_settings',
		'description'       => esc_html__( 'Defines the \'Read More\' link text appended to post excerpts.', 'bizindustries' ),
		'active_callback' => function(){
			 if(get_theme_mod('post_readmore_display')){
				return true;
			 } else {
				 return false;
			 }
		},
	)
);

// Meta sortable
$wp_customize->add_setting( 'blog_meta_sort', 
		array(
			'sanitize_callback' => 'bizindustries_sanitize_sort',
			'default'           => array( 'blog_author', 'blog_category','blog_date','blog_comment'),
		)
	);

$wp_customize->add_control( new Bizindustries_Control_Sortable( $wp_customize, 'blog_meta_sort', 
	array(
		'label' => esc_html__( 'Post Meta', 'bizindustries'  ),
		'section' => 'blog_settings',
		'settings' => 'blog_meta_sort',
		'type'=> 'sortable',
		'choices'  => array(
				'blog_author' => esc_html__( 'Author', 'bizindustries'  ),
				'blog_category' => esc_html__( 'Category', 'bizindustries'  ),
				'blog_date' => esc_html__( 'Date', 'bizindustries'  ),
				'blog_comment' => esc_html__( 'Comment', 'bizindustries'  ),
			),
		'description'	=> __( 'Drag and drop to rearange. Click on eye icon to hide a specific meta', 'bizindustries' )
		) 
	) 
);

// Display Date Meta.
$wp_customize->add_setting( 'post_date_display',
	array(
		'default'			=> true,
		'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
	)
);
$wp_customize->add_control( 'post_date_display',
	array(
		'section'		=> 'blog_settings',
		'type'			=> 'checkbox',
		'label'			=> __( 'Display Date', 'bizindustries' ),
	)
);

// Pagination - Pagination Type
$wp_customize->add_setting(
	'pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'bizindustries' ),
		'section'         => 'blog_settings',
		'type'            => 'select',
		'choices'         => array(
			'numeric' => __( 'Default(Numeric)', 'bizindustries' ),
			'default' => __( 'Older/Newer', 'bizindustries' ),

		),
	)
);
