<?php 
	
	
// Section Order sortable
$wp_customize->add_section( 'bizindustries_section_orders',
	array(
		'priority'    => 90,
		'title'       => esc_html__( 'Section Order', 'bizindustries' ),
		'description' => '',
		'panel'       => 'bizindustries_frontpage_settings',
		)
);

$wp_customize->add_setting( 'bizindustries_sections_sort', 
		array(
		'sanitize_callback' => 'bizindustries_sanitize_sort',
			'default'           => array( 'slider', 'services', 'products', 'slogan', 'choose', 'reviews', 'cta', 'team', 'news', 'brands','contact'),
		)
	);

$wp_customize->add_control( new Bizindustries_Control_Sortable( $wp_customize, 'bizindustries_sections_sort', 
	array(
		'label' => esc_html__( 'Sort Sections', 'bizindustries'  ),
		'section' => 'bizindustries_section_orders',
		'type'=> 'sortable',
		'choices'  => array(
			'slider' => esc_html__( 'Slider', 'bizindustries'  ),
			'services' => esc_html__( 'Services', 'bizindustries'  ),
			'products' => esc_html__( 'Our Products', 'bizindustries'  ),
			'slogan' => esc_html__( 'Slogan', 'bizindustries'  ),
			'choose' => esc_html__( 'Why Choose', 'bizindustries'  ),
			'reviews' => esc_html__( 'Reviews', 'bizindustries'  ),
			'cta' => esc_html__( 'Call to Action', 'bizindustries'  ),
			'team' => esc_html__( 'Our Team', 'bizindustries'  ),
			'news' => esc_html__( 'Latest News', 'bizindustries'  ),
			'brands' => esc_html__( 'Brands Logos', 'bizindustries'  ),
			'contact' => esc_html__( 'Contact Us', 'bizindustries'  ),
			),
		'description'	=> __( 'Drag and drop to rearange. Click on eye icon to hide a specific section', 'bizindustries' )
		) 
	) 
);
