<?php 
/**
* Team Section Settings
* @since 1.0.0
* ----------------------------------------------------------------------
*/
	$wp_customize->add_section( 'team_section_settings',
		array(
			'title'       => esc_html__( 'Team Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority' => 6,
			'divider' => 'before',
		)
	);
		$wp_customize->add_setting( 'teams_section_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'teams_section_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide Team Section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide teams section on front page.', 'bizindustries' ),
			  'section'       => 'team_section_settings',
			  'settings'      => 'teams_section_enable',
			  'type'          => 'checkbox',
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'team_heading', 
			array(
				'default'           => esc_html__('Our Team', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'team_heading', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'team_section_settings',
				'type'    => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Section subheading
		$wp_customize->add_setting( 'team_subheading', 
			array(
				'default'           => esc_html__('Leaders', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'team_subheading', 
			array(
				'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'description'=> '',
				'section'    => 'team_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		
		// Section Description
		$wp_customize->add_setting( 'team_description', 
			array(
				'default'           => esc_html__('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'team_description', 
			array(
				'label'      => esc_html__('Section Description', 'bizindustries'),
				'description'=> '',
				'section'    => 'team_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		$is_premium = bizindustries_set_to_premium(); 
		// Team
		$wp_customize->add_setting( 
			new Bizindustries_Control_Repeater_Setting( 
				$wp_customize, 
				'bizindustries_teams', 
				array(
					'default' => '',
					'sanitize_callback' => array( 'Bizindustries_Control_Repeater_Setting', 'sanitize_repeater_setting' ),
				) 
			) 
		);
		$wp_customize->add_control(
			new Bizindustries_Control_Repeater(
				$wp_customize,
				'bizindustries_teams',
				array(
					'section'       => 'team_section_settings',
					'label'         => esc_html__( 'Team', 'bizindustries' ),
					'fields'  => array(

						'name' => array(
							'type'        => 'text',
							'label'       => esc_html__( 'Name', 'bizindustries' ),
						),
						'position' => array(
							'type'        => 'text',
							'label'       => esc_html__( 'Position', 'bizindustries' ),
						),
						'image' => array(
							'type'    => 'image',
							'label'   => __( 'Upload Image', 'bizindustries' ),
						),
						'facebook_link' => array(
							'type'        => 'url',
							'label'       => esc_html__( 'Facebook Link', 'bizindustries' ),
							'description' => esc_html__( 'Example: https://facebook.com/username', 'bizindustries' ),
						),
						'twitter_link' => array(
							'type'        => 'url',
							'label'       => esc_html__( 'Twitter Link', 'bizindustries' ),
							'description' => esc_html__( 'Example: https://twitter.com/username', 'bizindustries' ),
						),
						'linkedin_link' => array(
							'type'        => 'url',
							'label'       => esc_html__( 'Linkedin Link', 'bizindustries' ),
							'description' => esc_html__( 'Example: https://linkedin.com/username', 'bizindustries' ),
						),
						'instagram_link' => array(
							'type'        => 'url',
							'label'       => esc_html__( 'Instagram Link', 'bizindustries' ),
							'description' => esc_html__( 'Example: https://instagram.com/username', 'bizindustries' ),
						),
						'dribble_link' => array(
							'type'        => 'url',
							'label'       => esc_html__( 'Dribble Link', 'bizindustries' ),
							'description' => esc_html__( 'Example: https://dribble.com/username', 'bizindustries' ),
						),
					),
					'row_label' => array(
						'type'  => 'field',
						'value' => esc_html__( 'member', 'bizindustries' ),
						'field' => 'name'
					),
					'choices' => array(
						'limit' => $is_premium==false?4:'',
					),
					'active_callback' => function(){
						 if( get_theme_mod('teams_section_enable') ){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			)
		);
if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		// Enable Carousel
		$wp_customize->add_setting( 'team_carousel_enable',
			array(
				'default'			=> false,
				'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'team_carousel_enable',
			array(
				'section'		=> 'team_section_settings',
				'type'			=> 'checkbox',
				'label'			=> __( 'Enable Carousel?', 'bizindustries' ),
				'active_callback' => function(){
					if( get_theme_mod('teams_section_enable') ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);	

		// Carousel Autoplay
		$wp_customize->add_setting( 'team_carousel_autoplay',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'team_carousel_autoplay',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel Autoplay?', 'bizindustries' ),
				'section'     => 'team_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel autoplay.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true && get_theme_mod('team_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Slide Duration
		$wp_customize->add_setting( 'team_carousel_duration', 
			array(
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
				'validate_callback' => 'bizindustries_validate_duration',
				'default'          	=> 3000,
			) 
		);
		$wp_customize->add_control( 'team_carousel_duration', 
			array(
				'label'             => esc_html__( 'Carousel Duration', 'bizindustries' ),
				'description'       => esc_html__( 'Set the time in milisecond', 'bizindustries' ),
				'section'           => 'team_section_settings',
				'type'				=> 'number',
				'input_attrs'		=> array(
					'min'	=> 1000,
					'max'	=> 20000,
					'step'	=> 500,
				),
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true && get_theme_mod('team_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Carousel Loop
		$wp_customize->add_setting( 'team_carousel_loop_enable',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'team_carousel_loop_enable',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel loop?', 'bizindustries' ),
				'section'     => 'team_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel loop.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true && get_theme_mod('team_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Nav Disable
		$wp_customize->add_setting( 'team_carousel_nav_display',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'team_carousel_nav_display',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show carousel arrow?', 'bizindustries' ),
				'section'     => 'team_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to show/hide carousel arrows.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true && get_theme_mod('team_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Dots
		$wp_customize->add_setting( 'team_carousel_dots_display',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => false,
			)
		);
		$wp_customize->add_control( 'team_carousel_dots_display',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show carousel dots?', 'bizindustries' ),
				'section'     => 'team_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to show/hide carousel dots.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable') == true && get_theme_mod('team_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
}
		// Background color
		$wp_customize->add_setting( 'team_section_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'team_section_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'team_section_settings',
				'active_callback' => function(){
					 if(get_theme_mod('teams_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) ) 
		);
		
		
		
		
		
		
		
		
		
		