<?php 
	
/**
 * Slogan Section
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */

	$wp_customize->add_section( 'slogan_section_settings',
		array(
			'title'       => esc_html__( 'Slogan Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority' => 3,
			'divider' => 'before',
		)
	);

		$wp_customize->add_setting( 'slogan_section_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'slogan_section_enable', 
			array(
			  'label'   => esc_html__( 'Show/hide Slogan Section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide slogan section on front page.', 'bizindustries' ),
			  'section' => 'slogan_section_settings',
			  'type'    => 'checkbox',
			)
		);

		// Slogan Title
		$wp_customize->add_setting( 'slogan_title',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_html',
				'default'           => __('To deliver <strong>Quality Output</strong> Unique, Affordable & Professional', 'bizindustries'),
				'transport'			=> 'postMessage'
			)
		);
		$wp_customize->add_control( 'slogan_title',
			array(
				'label'       => esc_html__( 'Title', 'bizindustries' ),
				'description' => '',
				'type'    => 'text',
				'section'     => 'slogan_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'slogan_section_enable' ) ) {
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Slogan Subtitle
		$wp_customize->add_setting( 'slogan_subtitle',
			array(
				'default'           =>  __('Our Mission...', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'			=> 'postMessage'
			)
		);
		$wp_customize->add_control( 'slogan_subtitle',
			array(
				'label'       => esc_html__( 'Subtitle', 'bizindustries' ),
				'type'        => 'text',
				'section'     => 'slogan_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'slogan_section_enable' ) ) {
						return true;
					} else {
						return false;
					}
				},
			)
		);

		//  Image
		$wp_customize->add_setting( 'slogan_bg_image', 
			array(
				'default'           => get_template_directory_uri() . '/assets/img/slogan.jpg',
				'sanitize_callback' =>  'bizindustries_sanitize_image',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'slogan_bg_image', 
			array(
				'label'             => esc_html__('Background Image', 'bizindustries'),
				'description'       => esc_html__('Choose background image for slogan section', 'bizindustries'),
				'section'           => 'slogan_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'slogan_section_enable' ) ) {
						return true;
					} else {
						return false;
					}
				},
			)
		));

		// Enable Parallax
		$wp_customize->add_setting( 'slogan_parallax_enable',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => 1,
			)
		);
		$wp_customize->add_control( 'slogan_parallax_enable',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Enable Parallax', 'bizindustries' ),
				'section'     => 'slogan_section_settings',
				'description'	=> __( 'Check/Uncheck this box to enable/disable parallax effect.', 'bizindustries' ),
				'active_callback' => function(){
					if( get_theme_mod( 'slogan_section_enable' ) == true ) {
						return true;
					} else {
						return false;
					}
				},
			)
		);
		
		// Overlay color
		$wp_customize->add_setting( 'slogan_overlay_bg_color',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_color_alpha',
				'default'           => 'rgba(0,0,0,.5)',
				'transport'         => 'postMessage'
			)
		);
		$wp_customize->add_control( new Bizindustries_Alpha_Color_Control(
				$wp_customize, 'slogan_overlay_bg_color',
				array(
					'label'   => esc_html__( 'Overlay Color', 'bizindustries' ),
					'section' => 'slogan_section_settings',
					'active_callback' => function(){
						if( get_theme_mod( 'slogan_section_enable') == true ) {
							return true;
						} else {
							return false;
						}
					},
				)
			)
		);