<?php 
/**
 * Slider Section
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */
		$wp_customize->add_section( 'slider_settings',
			array(
				'title'       => esc_html__( 'Slider Section', 'bizindustries' ),
				'description' => '',
				'panel'       => 'bizindustries_frontpage_settings',
				'priority' => 1,
				'divider' => 'before',
			)
		);
		// Hide/show
		$wp_customize->add_setting( 'slider_section_enable', 
	    	array(
		      'default'           =>  false,
		      'sanitize_callback' => 'bizindustries_sanitize_checkbox'
		  	)
	    );
		$wp_customize->add_control( 'slider_section_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide Slider Section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide slider section on front page template.', 'bizindustries' ),
			  'section'       => 'slider_settings',
			  'type'          => 'checkbox',
			  'priority'      => 1,
			)
		);

		// Total Number
        $wp_customize->add_setting( 'slides_total_items', 
		 	array(
				'default'           => 2,
				'capability'        => 'edit_theme_options',
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
			) 
		);
		$wp_customize->add_control( 'slides_total_items', 
			array(
				'label'       => esc_html__( 'Total Slides to Show','bizindustries' ),
				'description' => esc_html__( 'After changing default value please save and reload','bizindustries' ),
				'type'        => 'number',
				'section'     => 'slider_settings',
				'input_attrs' => array(
					'min'	=> 1,
					'max'	=> 20,
					'step'	=> 1,
				),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
				'priority' => 3,
			)
		);

		// Content Type
		$wp_customize->add_setting('slides_content_type', 
			array(
			'default' 			=> 'slides_page',	
			'sanitize_callback' => 'bizindustries_sanitize_select'
			)
		);

if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		$wp_customize->add_control('slides_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'slider_settings',   
				'type'        => 'select',
				'choices' => array(
					'slides_page'	   => __('Page','bizindustries'),
					'slides_post'	   => __('Post','bizindustries'),
					'slides_custom'	   => __('Custom Content','bizindustries'),
				),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
				'priority' => 4,
			)
		);
} else {
		$wp_customize->add_control('slides_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'slider_settings',   
				'type'        => 'select',
				'choices' => array(
					'slides_page'	   => __('Page','bizindustries'),
					'slides_post'	   => __('Post','bizindustries'),
				),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
				'priority' => 4,
			)
		);
} 


	$slide_items = get_theme_mod( 'slides_total_items', 2);
	for( $i=1; $i<=$slide_items; $i++ ) {


		// Page
		$wp_customize->add_setting('slide_page_'.$i.'', 
			array(
				'capability'        => 'edit_theme_options',	
				'sanitize_callback' => 'bizindustries_dropdown_pages'
			)
		);
		$wp_customize->add_control('slide_page_'.$i.'', 
			array(
				/* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s', 'bizindustries'), $i),
				/* translators: %1$s is replaced with number */
				'description' => sprintf( __('Select a Page for slide #%1$s title, text and background image', 'bizindustries'), $i),
				'section'     => 'slider_settings',   
				'settings'    => 'slide_page_'.$i.'',		
				'type'        => 'dropdown-pages',
				'active_callback' => function(){
					$slider_enable          = get_theme_mod('slider_section_enable');
					$slides_content_type    = get_theme_mod('slides_content_type');
					if($slides_content_type == 'slides_page' && true == $slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		// Posts
		$wp_customize->add_setting('slide_post_'.$i.'', 
			array(
				'capability'        => 'edit_theme_options',	
				'sanitize_callback' => 'bizindustries_dropdown_pages'
			)
		);
		$wp_customize->add_control('slide_post_'.$i.'', 
			array(
				/* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s', 'bizindustries'), $i),
				/* translators: %1$s is replaced with number */
				'description' => sprintf( __('Select a Post for slide #%1$s title, text and background image', 'bizindustries'), $i),
				'section'     => 'slider_settings',   
				'settings'    => 'slide_post_'.$i.'',		
				'type'        => 'select',
				'choices'	  => bizindustries_dropdown_posts(),
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					$slides_content_type = get_theme_mod('slides_content_type');
					if($slides_content_type == 'slides_post' && $slider_enable == 1 ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		// Subtitle
		$wp_customize->add_setting('slider_subtitle_'.$i.'', 
			array(
				'dafult'=> esc_html__('Brands', 'bizindustries'),
				'capability'        => 'edit_theme_options',	
				'sanitize_callback' => 'sanitize_text_field'
			)
		);
		$wp_customize->add_control('slider_subtitle_'.$i.'', 
			array(
				'label'       => '',
				/* translators: %1$s is replaced with number */
				'description' => sprintf( __('Slide #%1$s subtitle', 'bizindustries'), $i),
				'type'        => 'text',
				'section'     => 'slider_settings',   		
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					if($slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){

		//Cutsom Content- Title
		$wp_customize->add_setting( 'slide_title_'.$i,
			array(
				'dafult'=> esc_html__('Known Far & Wide', 'bizindustries'),
				'sanitize_callback'=> 'sanitize_text_field', 
			) 
		);
		$wp_customize->add_control( 'slide_title_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s Title', 'bizindustries'), $i),
				'description' => '',
			    'type'        => 'text',
				'section'     => 'slider_settings',
				'active_callback' => function(){
					$slider_enable       = get_theme_mod('slider_section_enable');
					$slides_content_type = get_theme_mod('slides_content_type');
					if($slides_content_type == 'slides_custom' && true == $slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		//Description
		$wp_customize->add_setting( 'slide_description_'.$i,
			array(
				'dafult'           => esc_html__('Our brands are the most recognized in the industry. Don\'t believe it? Check out the independent research that shows our products at the top of the list for quality', 'bizindustries'),
				'sanitize_callback'=> 'bizindustries_sanitize_html', 
			) 
		);
		$wp_customize->add_control( 'slide_description_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s Description', 'bizindustries'), $i),
				'description' => '',
			    'type'    => 'textarea',
				'section' => 'slider_settings',
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					$slides_content_type = get_theme_mod('slides_content_type');
					if($slides_content_type == 'slides_custom' && true == $slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		//Button Text
		$wp_customize->add_setting( 'slide_btn_text_'.$i,
			array(
				'dafult'=> esc_html__('See More', 'bizindustries'),
				'sanitize_callback'=> 'sanitize_text_field', 
			) 
		);
		$wp_customize->add_control( 'slide_btn_text_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s Button 1 Text', 'bizindustries'), $i),
				'description' => '',
			    'type'    => 'text',
				'section' => 'slider_settings',
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					$slides_content_type = get_theme_mod('slides_content_type');
					if($slides_content_type == 'slides_custom' && true == $slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		//Button URL
		$wp_customize->add_setting( 'slide_btn_url_'.$i,
			array(
				'dafult'=> '',
				'sanitize_callback'=> 'esc_url_raw', 
			) 
		);
		$wp_customize->add_control( 'slide_btn_url_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s Button 1 URL', 'bizindustries'), $i),
				'description' => '',
			    'type'    => 'url',
				'section' => 'slider_settings',
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					$slides_content_type = get_theme_mod('slides_content_type');
					if($slides_content_type == 'slides_custom' && true == $slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		//Button target
		$wp_customize->add_setting( 'slide_btn_target_'.$i,
			array(
				'dafult'=> '',
				'sanitize_callback'=> 'bizindustries_sanitize_checkbox', 
			) 
		);
		$wp_customize->add_control( 'slide_btn_target_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s button 1 open on new tab?', 'bizindustries'), $i),
				'description' => '',
			    'type'    => 'checkbox',
				'section' => 'slider_settings',
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					$slides_content_type = get_theme_mod('slides_content_type');
					if($slides_content_type == 'slides_custom' && true == $slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);
}
	//Button Text
		$wp_customize->add_setting( 'slide_btn2_text_'.$i,
			array(
				'dafult'=> esc_html__('Get in Touch', 'bizindustries'),
				'sanitize_callback'=> 'sanitize_text_field', 
			) 
		);
		$wp_customize->add_control( 'slide_btn2_text_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s Button 2 Text', 'bizindustries'), $i),
				'description' => '',
			    'type'    => 'text',
				'section' => 'slider_settings',
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					if($slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);
		
		//Button URL
		$wp_customize->add_setting( 'slide_btn2_url_'.$i,
			array(
				'dafult'=> '',
				'sanitize_callback'=> 'esc_url_raw', 
			) 
		);
		$wp_customize->add_control( 'slide_btn2_url_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s Button 2 URL', 'bizindustries'), $i),
				'description' => '',
			    'type'    => 'url',
				'section' => 'slider_settings',
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					if($slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);
		
		//Button target
		$wp_customize->add_setting( 'slide_btn2_target_'.$i,
			array(
				'dafult'=> '',
				'sanitize_callback'=> 'bizindustries_sanitize_checkbox', 
			) 
		);
		$wp_customize->add_control( 'slide_btn2_target_'.$i, 
			array(
					    /* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Slide #%1$s button 2 open on new tab?', 'bizindustries'), $i),
				'description' => '',
			    'type'    => 'checkbox',
				'section' => 'slider_settings',
				'active_callback' => function(){
					$slider_enable = get_theme_mod('slider_section_enable');
					if($slider_enable ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);
if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		/** Background Image */
		$wp_customize->add_setting( 'slider_bg_'.$i,
			array(
				'default'           => get_template_directory_uri() . '/assets/img/banner/banner.jpg',
				'sanitize_callback' => 'bizindustries_sanitize_image',
			)
		);
		$wp_customize->add_control( 
			new WP_Customize_Image_Control( $wp_customize, 'slider_bg_'.$i,
				array(
					    /* translators: %1$s is replaced with number */
					'label'     => sprintf( __('Slide #%1$s Background Image', 'bizindustries'), $i),
					'section'   => 'slider_settings',
					'type'      => 'image',
					'active_callback' => function(){
						$slider_enable = get_theme_mod('slider_section_enable');
						$slides_content_type = get_theme_mod('slides_content_type');
						if($slides_content_type == 'slides_custom' && true == $slider_enable ){
							return true;
						} else {
							 return false;
						}
					},
				)
			)
		);
	}
}

		// Text Alignment
		$wp_customize->add_setting( 'slider_text_alignment', 
	        array(
	            'default'           => 'text-left',
	            'sanitize_callback' => 'bizindustries_sanitize_choices'
	        ) 
	    );
	    $wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'slider_text_alignment',
				array(
					'label'       => esc_html__('Text Alignment', 'bizindustries'),
					'description' => '',
					'section'	  => 'slider_settings',
					'type'        => 'select',
					'choices'	  => array(
						'text-left'  => esc_html__('Left','bizindustries'),
						'text-center'  => esc_html__('Center','bizindustries'),
						'text-right'  => esc_html__('Right','bizindustries'),
					),
					'active_callback' => function(){
						if(get_theme_mod('slider_section_enable')){
						    return true;
						} else {
							return false;
						}
					},
					
				)
			)
		);

if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		// Slider Autoplay
		$wp_customize->add_setting( 'slider_autoplay',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'slider_autoplay',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Slider Autoplay?', 'bizindustries' ),
				'section'     => 'slider_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable slider autoplay.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		
		// Slide Duration
		$wp_customize->add_setting( 'slider_duration', 
			array(
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
				'validate_callback' => 'bizindustries_validate_duration',
				'default'          	=> 5000,
			) 
		);
		$wp_customize->add_control( 'slider_duration', 
			array(
				'label'             => esc_html__( 'Slider Duration', 'bizindustries' ),
				'description'       => esc_html__( 'Set the time in milisecond', 'bizindustries' ),
				'section'           => 'slider_settings',
				'type'				=> 'number',
				'input_attrs'		=> array(
					'min'	=> 1000,
					'max'	=> 20000,
					'step'	=> 500,
					),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);
		
		// Slider Loop
		$wp_customize->add_setting( 'slider_loop',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'slider_loop',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Slider loop?', 'bizindustries' ),
				'section'     => 'slider_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable slider loop.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		
		// Slider Nav Disable
		$wp_customize->add_setting( 'slider_nav',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'slider_nav',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show slider arrow?', 'bizindustries' ),
				'section'     => 'slider_settings',
				'description' => esc_html__( 'Check/Uncheck this box to show/hide slider arrows.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Slider Dots
		$wp_customize->add_setting( 'slider_dots',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'slider_dots',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show slider dots?', 'bizindustries' ),
				'section'     => 'slider_settings',
				'description' => esc_html__( 'Check/Uncheck this box to show/hide slider dots.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('slider_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	}
