<?php 
/**
 * Services Section
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */

	$wp_customize->add_section( 'services_section_settings',
		array(
			'title'       => esc_html__( 'Service Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority' => 2,
		)
	);
		$wp_customize->add_setting( 'services_section_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'services_section_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide service section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide service section on front page.', 'bizindustries' ),
			  'section'       => 'services_section_settings',
			  'type'          => 'checkbox',
			  'priority'      => 1
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'services_section_heading', 
			array(
				'default'           => '',
				'sanitize_callback' => 'bizindustries_sanitize_html',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'services_section_heading', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'services_section_settings',
				'type'    => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('services_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Section subheading
		$wp_customize->add_setting( 'services_section_subheading', 
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'services_section_subheading', 
			array(
				'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'description'=> '',
				'section'    => 'services_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					if(get_theme_mod('services_section_enable') == true && get_theme_mod('services_layout') == 'layout-2'){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Section Description
		$wp_customize->add_setting( 'services_section_desc', 
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'services_section_desc', 
			array(
				'label'      => esc_html__('Section Description', 'bizindustries'),
				'description'=> '',
				'section'    => 'services_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					if(get_theme_mod('services_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Section Description 2
		$wp_customize->add_setting( 'services_section_desc_2', 
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'services_section_desc_2', 
			array(
				'label'      => esc_html__('Section description part 2', 'bizindustries'),
				'description'=> '',
				'section'    => 'services_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					if(get_theme_mod('services_section_enable') == true && get_theme_mod('services_layout') != 'layout-2'){
						return true;
					} else {
						return false;
					}
				},
			)
		);
		
		// Total Number
		$wp_customize->add_setting( 'services_total_items_show', 
			array(
				'default'           => 4,
				'capability'        => 'edit_theme_options',
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
			)
		);
		$wp_customize->add_control( 'services_total_items_show', 
			array(
				'label'       => esc_html__( 'Total Items to Show','bizindustries' ),
				'description' => esc_html__( 'After changing default value please save and reload','bizindustries' ),
				'type'        => 'number',
				'section'     => 'services_section_settings',
				'input_attrs' => array(
					'min'	=> 1,
					'max'	=> 12,
					'step'	=> 1,
				),
				'active_callback' => function(){
					 if(get_theme_mod('services_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Content Type
		$wp_customize->add_setting('services_content_type', 
			array(
			'default' 			=> 'services_page',
			'sanitize_callback' => 'bizindustries_sanitize_select'
			)
		);

	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		$wp_customize->add_control('services_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'services_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'services_post'	   => __('Post','bizindustries'),
						'services_page'	   => __('Page','bizindustries'),
						'services_custom'  => __('Custom Content','bizindustries'),
				),
				'active_callback' => function(){
					 if( true === get_theme_mod('services_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	} else { 
		$wp_customize->add_control('services_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'services_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'services_post'	   => __('Post','bizindustries'),
						'services_page'	   => __('Page','bizindustries'),
				),
				'active_callback' => function(){
					 if( true === get_theme_mod('services_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	}



	$service_items = get_theme_mod( 'services_total_items_show', 4);
	for( $i=1; $i<=$service_items; $i++ ) {
		//Icon
		$wp_customize->add_setting(
			'service_icon_'.$i,
			array(
				'default'			=> 'fa-signal',
				'sanitize_callback' => 'sanitize_text_field' // Done
			)
		);

		$wp_customize->add_control( 'service_icon_'.$i,
			array(
				/* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Service #%1$s', 'bizindustries'), $i),
				/* translators: %1$s is replaced with number */
				'description'       => sprintf( __('Select a icon for service #%1$s from <a target="_blank" href="https://fontawesome.com/v4.7/icons/">Font Awesome icons</a> and enter its class name. Example- fa-signal', 'bizindustries'), $i),
				'section'		=> 'services_section_settings',
				'type'			=> 'text',
				'active_callback' => function(){
					if( true === get_theme_mod('services_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		//Page
		$wp_customize->add_setting('featured_service_page_'.$i.'', 
			array(
				'capability'        => 'edit_theme_options',	
				'sanitize_callback' => 'bizindustries_dropdown_pages'
			)
		);
		$wp_customize->add_control('featured_service_page_'.$i.'', 
			array(
				/* translators: %1$s is replaced with number */
				'description' => sprintf( __('Select a page for Service #%1$s title and description', 'bizindustries'), $i),
				'section'     => 'services_section_settings',   
				'settings'    => 'featured_service_page_'.$i.'',		
				'type'        => 'dropdown-pages',
				'active_callback' => function(){
					$service_status = get_theme_mod('services_section_enable');
					$services_content_type = get_theme_mod('services_content_type');
					if($services_content_type == 'services_page' && $service_status == true ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		// Posts
		$wp_customize->add_setting('featured_service_post_'.$i.'', 
			array(
				'capability'        => 'edit_theme_options',	
				'sanitize_callback' => 'bizindustries_dropdown_pages'
			)
		);
		$wp_customize->add_control('featured_service_post_'.$i.'', 
			array(
				/* translators: %1$s is replaced with number */
				'description' => sprintf( __('Select a Post for Service #%1$s title and text', 'bizindustries'), $i),
				'section'     => 'services_section_settings',   
				'settings'    => 'featured_service_post_'.$i.'',		
				'type'        => 'select',
				'choices'	  => bizindustries_dropdown_posts(),
				'active_callback' => function(){
					$service_status = get_theme_mod('services_section_enable');
					$services_content_type = get_theme_mod('services_content_type');
					if($services_content_type == 'services_post' && $service_status == true ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);
	    if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
			//Cutsom Content- Title
			$wp_customize->add_setting( 'featured_service_title_'.$i,
				array(
					'dafult'=> esc_html__('History of Our Company', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
				) 
			);
			$wp_customize->add_control( 'featured_service_title_'.$i, 
				array(
					   /* translators: %1$s is replaced with number */
					'label'   => sprintf( __('Service #%1$s Title', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'services_section_settings',
					'active_callback' => function(){
						$service_status = get_theme_mod('services_section_enable');
						$services_content_type = get_theme_mod('services_content_type');
						if($services_content_type == 'services_custom' && $service_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);
		
			//Description
			$wp_customize->add_setting( 'featured_service_desc_'.$i,
				array(
					'dafult'           => esc_html__('Bootitems is an International company committed to enhancing customer and shareholder value...', 'bizindustries'),
					'sanitize_callback'=> 'bizindustries_sanitize_html', 
				) 
			);
			$wp_customize->add_control( 'featured_service_desc_'.$i, 
				array(
					    /* translators: %1$s is replaced with number */
					'label'       => sprintf( __('Service #%1$s description', 'bizindustries'), $i),
					'type'        => 'textarea',
					'section'     => 'services_section_settings',
					'active_callback' => function(){
						$service_status = get_theme_mod('services_section_enable');
						$services_content_type = get_theme_mod('services_content_type');
						if($services_content_type == 'services_custom' && $service_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

			//Button Text
			$wp_customize->add_setting( 'featured_service_btn_text_'.$i,
				array(
					'dafult'           => esc_html__('Read More', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
				) 
			);
			$wp_customize->add_control( 'featured_service_btn_text_'.$i, 
				array(
					    /* translators: %1$s is replaced with number */
					'label'   => sprintf( __('Service #%1$s Button Text', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'services_section_settings',
					'active_callback' => function(){
						$service_status = get_theme_mod('services_section_enable');
						$services_content_type = get_theme_mod('services_content_type');
						if($services_content_type == 'services_custom' && $service_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);
		
			//Button URL
			$wp_customize->add_setting( 'featured_service_btn_url_'.$i,
				array(
					'dafult'=> '',
					'sanitize_callback'=> 'esc_url_raw', 
				) 
			);
			$wp_customize->add_control( 'featured_service_btn_url_'.$i, 
				array(
					    /* translators: %1$s is replaced with number */
					'label'       => sprintf( __('Service #%1$s Button URL', 'bizindustries'), $i),
					'description' => '',
					'type'        => 'url',
					'section'     => 'services_section_settings',
					'active_callback' => function(){
						$service_status = get_theme_mod('services_section_enable');
						$services_content_type = get_theme_mod('services_content_type');
						if($services_content_type == 'services_custom' && $service_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);
		
			//Button target
			$wp_customize->add_setting( 'featured_service_btn_target_'.$i,
				array(
					'dafult'           => '',
					'sanitize_callback'=> 'bizindustries_sanitize_checkbox', 
				) 
			);
			$wp_customize->add_control( 'featured_service_btn_target_'.$i, 
				array(
					    /* translators: %1$s is replaced with number */
					'label'       => sprintf( __('Service #%1$s button open on new tab?', 'bizindustries'), $i),
					'description' => '',
					'type'        => 'checkbox',
					'section'     => 'services_section_settings',
					'active_callback' => function(){
						$service_status = get_theme_mod('services_section_enable');
						$services_content_type = get_theme_mod('services_content_type');
						if($services_content_type == 'services_custom' && $service_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);
		}
	}
	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		// Layout Settings
		$wp_customize->add_setting( 'services_layout',
			array(
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => 'layout-1',
				//'transport'         => 'postMessage',
			)
		);
		$wp_customize->add_control( 'services_layout',
			array(
				'type'    => 'select',
				'label'   => esc_html__( 'Select Layout', 'bizindustries' ),
				'section' => 'services_section_settings',
				'choices' => array(
					'layout-1' => esc_html__( 'Layout One', 'bizindustries' ),
					'layout-2'  => esc_html__( 'Layout Two', 'bizindustries' ),
				),
				'active_callback' => function(){
					 if(get_theme_mod('services_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	}
		$wp_customize->add_setting('services_content_align', 
			array(
			'default' 			=> 'text-left',	
			'sanitize_callback' => 'bizindustries_sanitize_select'
			)
		);
		$wp_customize->add_control('services_content_align', 
			array(
				'label'       => __('Text Alignment', 'bizindustries'),
				'section'     => 'services_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'text-left'	   => __('Left','bizindustries'),
						'text-center'  => __('Center','bizindustries'),
						'text-right'   => __('Right','bizindustries'),
				),
				'active_callback' => function(){
					 if(true === get_theme_mod('services_section_enable') && get_theme_mod('services_layout') == 'layout-2'){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);


		$wp_customize->add_setting( 'countdown_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'countdown_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide countdown facts', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide countdown facts on service section.', 'bizindustries' ),
			  'section'       => 'services_section_settings',
			  'type'          => 'checkbox',
			  'active_callback' => function(){
					$service_enable = get_theme_mod('services_section_enable');
					$services_layout = get_theme_mod('services_layout');
					$countdown_enable = get_theme_mod('countdown_enable', false);
					if( true === $service_enable  && $services_layout == 'layout-1' ){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		for( $i=1; $i<=3; $i++ ) {

		//Icon
		$wp_customize->add_setting(
			'countdown_icon_'.$i,
			array(
				'default'			=> 'fa-coffee',
				'sanitize_callback' => 'sanitize_text_field' // Done
			)
		);

		$wp_customize->add_control( 'countdown_icon_'.$i,
			array(
				/* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Coundown #%1$s', 'bizindustries'), $i),
				/* translators: %1$s is replaced with number */
				'description'       => sprintf( __('Select a icon for coundown #%1$s from <a target="_blank" href="https://fontawesome.com/v4.7/icons/">Font Awesome icons</a> and enter its class name. Example- fa-coffee', 'bizindustries'), $i),
				'section'		=> 'services_section_settings',
				'type'			=> 'text',
				'active_callback' => function(){
					$service_enable = get_theme_mod('services_section_enable');
					$services_layout = get_theme_mod('services_layout');
					$countdown_enable = get_theme_mod('countdown_enable', false);
					if( true === $service_enable  && $services_layout == 'layout-1' && true === $countdown_enable ){
						return true;
					} else {
						return false;
					}
				},
			)
		);


			// Title
			$wp_customize->add_setting( 'countdown_number_'.$i,
				array(
					'dafult'=> __('123', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
				) 
			);
			$wp_customize->add_control( 'countdown_number_'.$i, 
				array(
					'label'   => '',
					    /* translators: %1$s is replaced with number */
					'description' => sprintf( __('Countdown #%1$s number', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'services_section_settings',
					'active_callback' => function(){
						$service_enable = get_theme_mod('services_section_enable');
						$services_layout = get_theme_mod('services_layout');
						$countdown_enable = get_theme_mod('countdown_enable', false);
						if( true === $service_enable  && $services_layout == 'layout-1' && true === $countdown_enable ){
							return true;
						} else {
							return false;
						}
					},
				)
			);
		
			//Description
			$wp_customize->add_setting( 'countdown_desc_'.$i,
				array(
					'dafult'           => __('Winning Awards', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
				) 
			);
			$wp_customize->add_control( 'countdown_desc_'.$i, 
				array(
					'label'       => '',
					    /* translators: %1$s is replaced with number */
					'description' => sprintf( __('Countdown #%1$s text', 'bizindustries'), $i),
					'type'        => 'text',
					'section'     => 'services_section_settings',
					'active_callback' => function(){
						$service_enable = get_theme_mod('services_section_enable');
						$services_layout = get_theme_mod('services_layout');
						$countdown_enable = get_theme_mod('countdown_enable', false);
						if( true === $service_enable  && $services_layout == 'layout-1' && true === $countdown_enable ){
							return true;
						} else {
							return false;
						}
					},
				)
			);

		}

		// Background color
		$wp_customize->add_setting( 'service_section_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'service_section_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'services_section_settings',
				'active_callback' => function(){
					 if( true === get_theme_mod('services_section_enable')){
						return true;
					 } else {
					 return false;
					 }
				},
			) ) 
		);
		
		
		
		
		