<?php 
	$wp_customize->add_section( 'reviews_section_settings',
		array(
			'title'       => esc_html__( 'Reviews Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority'    => 5,
			'divider'     => 'before',
		)
	);

		$wp_customize->add_setting( 'reviews_sec_enable', 
			array(
			  'default'           =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'reviews_sec_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide Reviews Section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide Reviews section on front page.', 'bizindustries' ),
			  'section'       => 'reviews_section_settings',
			  'settings'      => 'reviews_sec_enable',
			  'type'          => 'checkbox',
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'reviews_heading', 
			array(
				'default'           => esc_html__( 'Reviews', 'bizindustries' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			) 
		);
		$wp_customize->add_control( 'reviews_heading', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'reviews_section_settings',
				'type'    => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Section subheading
		$wp_customize->add_setting( 'reviews_subheading', 
			array(
				'default'           => esc_html__( 'Client Says', 'bizindustries' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			) 
		);
		$wp_customize->add_control( 'reviews_subheading', 
			array(
				'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'section'    => 'reviews_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Section subheading
		$wp_customize->add_setting( 'reviews_description', 
			array(
				'default'           => esc_html__( 'Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			) 
		);
		$wp_customize->add_control( 'reviews_description', 
			array(
				'label'      => esc_html__('Section Description', 'bizindustries'),
				'section'    => 'reviews_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Total Number
        $wp_customize->add_setting( 'reviews_total_count', 
		 	array(
				'default'           => 2,
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
				'transport'         => 'refresh',
			) 
		);
		$wp_customize->add_control( 'reviews_total_count', 
			array(
				'label'       => esc_html__( 'Total Items to Show','bizindustries' ),
				'description' => esc_html__( 'After changing default value please save and reload','bizindustries' ),
				'type'        => 'number',
				'section'     => 'reviews_section_settings',
				'input_attrs' => array(
					'min'	=> 1,
					'max'	=> 20,
					'step'	=> 1,
				),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		
		// Content Type
		$wp_customize->add_setting('reviews_content_type', 
			array(
			'default' 			=> 'reviews_page',
			'sanitize_callback' => 'bizindustries_sanitize_select',
			'transport'         => 'refresh',
			)
		);

	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		$wp_customize->add_control('reviews_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'reviews_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'reviews_page'	   => __('Page','bizindustries'),
						'reviews_post'	   => __('Post','bizindustries'),
						'review_custom'    => __('Custom Content','bizindustries'),

				),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	} else {
		$wp_customize->add_control('reviews_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'reviews_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'reviews_page'	   => __('Page','bizindustries'),
						'reviews_post'	   => __('Post','bizindustries'),
				),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	}


	$total_items = get_theme_mod( 'reviews_total_count', 2);
	for( $i=1; $i<=$total_items; $i++ ) {
			// Page
			$wp_customize->add_setting('reviews_page_'.$i.'', 
				array(	
					'sanitize_callback' => 'bizindustries_dropdown_pages',
					'transport'         => 'refresh',
				)
			);
			$wp_customize->add_control('reviews_page_'.$i.'', 
				array(
					/* translators: %1$s is replaced with number */
					'label'       => sprintf( __('Client #%1$s', 'bizindustries'), $i),
					/* translators: %1$s is replaced with number */
					'description' => sprintf( __('Select a page for client\'s #%1$s name, quote and picture', 'bizindustries'), $i),
					'section'     => 'reviews_section_settings',   		
					'type'        => 'dropdown-pages',
					'active_callback' => function(){
						$content_type = get_theme_mod('reviews_content_type');
						$sec_enable = get_theme_mod('reviews_sec_enable');
						if($content_type=='reviews_page' && $sec_enable == true){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

			// Posts
			$wp_customize->add_setting('reviews_post_'.$i.'', 
				array(
					'sanitize_callback' => 'bizindustries_dropdown_pages',
					'transport'         => 'refresh',
				)
			);
			$wp_customize->add_control('reviews_post_'.$i.'', 
				array(
					/* translators: %1$s is replaced with number */
					'label'       => sprintf( __('Client #%1$s', 'bizindustries'), $i),
					/* translators: %1$s is replaced with number */
					'description' => sprintf( __('Select a post for client\'s #%1$s name, quote and picture', 'bizindustries'), $i),
					'section'     => 'reviews_section_settings',   		
					'type'        => 'select',
					'choices'	  => bizindustries_dropdown_posts(),
					'active_callback' => function(){
						$content_type = get_theme_mod('reviews_content_type');
						$sec_enable = get_theme_mod('reviews_sec_enable');
						if($content_type=='reviews_post' && $sec_enable == true){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

			//Name
			$wp_customize->add_setting( 'reviewer_name_'.$i,
				array(
					'dafult'=> esc_html__('Jason Tutak', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
					'transport'         => 'refresh',
				) 
			);
			$wp_customize->add_control( 'reviewer_name_'.$i, 
				array(
					/* translators: %1$s is replaced with number */
					'label'   => sprintf( __('Client #%1$s Name', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'reviews_section_settings',
					'active_callback' => function(){
						$content_type = get_theme_mod('reviews_content_type');
						$sec_enable = get_theme_mod('reviews_sec_enable');
						if($content_type =='review_custom' && $sec_enable == true){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

			//Quotation
			$wp_customize->add_setting( 'reviewer_quote_'.$i,
				array(
					'dafult'=> '',
					'sanitize_callback'=> 'sanitize_textarea_field', 
					'transport'         => 'refresh',
				) 
			);
			$wp_customize->add_control( 'reviewer_quote_'.$i, 
				array(
					/* translators: %1$s is replaced with number */
					'label'   => sprintf( __('Client #%1$s Quote', 'bizindustries'), $i),
					'type'    => 'textarea',
					'section' => 'reviews_section_settings',
					'active_callback' => function(){
						$content_type = get_theme_mod('reviews_content_type');
						$sec_enable = get_theme_mod('reviews_sec_enable');
						if($content_type == 'review_custom' && $sec_enable == true){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

			// Position
			$wp_customize->add_setting('reviewer_position_'.$i.'', 
				array(
					'sanitize_callback' => 'sanitize_text_field',
					'transport'         => 'refresh',
				)
			);
			$wp_customize->add_control('reviewer_position_'.$i.'', 
				array(
					'label'       => '',
					/* translators: %1$s is replaced with number */
					'description' => sprintf( __('Client #%1$s designation', 'bizindustries'), $i),
					'type'        => 'text',
					'section'     => 'reviews_section_settings',   		
					'active_callback' => function(){
						 if( get_theme_mod('reviews_sec_enable') == true ){
							return true;
						 } else {
							 return false;
						 }
					},	
				)
			);

			//Name
			$wp_customize->add_setting( 'qoute_about_'.$i,
				array(
					'dafult'=> esc_html__('About Quality', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
					'transport'         => 'refresh',
				) 
			);
			$wp_customize->add_control( 'qoute_about_'.$i, 
				array(
					/* translators: %1$s is replaced with number */
					'label'   => sprintf( __('Client\'s #%1$s review for', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'reviews_section_settings',
					'active_callback' => function(){
						 if( get_theme_mod('reviews_sec_enable') == true ){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			);

			// Star Rating
			$wp_customize->add_setting( 'reviewer_stars_'.$i.'', 
				array(
					'default'           => '',
					'validate_callback' => 'bizindustries_validate_five_stars',
					'sanitize_callback' => 'bizindustries_sanitize_number_range',
					'transport'         => 'refresh',
				) 
			);
			$wp_customize->add_control( 'reviewer_stars_'.$i.'', 
				array(
					'label'       => '',
					/* translators: %1$s is replaced with number */
					'description' => sprintf( __('Client #%1$s rating', 'bizindustries'), $i),
					'type'        => 'number',
					'section'     => 'reviews_section_settings',
					'input_attrs' => array(
						'min'	=> 1,
						'max'	=> 5,
						'step'	=> 1,
					),
					'active_callback' => function(){
						 if( get_theme_mod('reviews_sec_enable') == true ){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			);

			/** Image */
			$wp_customize->add_setting( 'reviewer_face_'.$i,
				array(
					'default'           => '',
					'sanitize_callback' => 'bizindustries_sanitize_image',
					'transport'         => 'refresh',
				)
			);
			$wp_customize->add_control( 
				new WP_Customize_Image_Control( $wp_customize, 'reviewer_face_'.$i,
					array(
					    /* translators: %1$s is replaced with number */
						'label'    => sprintf( __('Reviewer #%1$s Image', 'bizindustries'), $i),
						'section'  => 'reviews_section_settings',
						'type'     => 'image',
						'active_callback' => function(){
							$content_type = get_theme_mod('reviews_content_type');
							$sec_enable   = get_theme_mod('reviews_sec_enable');
							if($content_type == 'review_custom' && $sec_enable == true){
								return true;
							} else {
								 return false;
							}
						},
					)
				)
			);
		}

	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		// Enable Carousel
		$wp_customize->add_setting( 'reviews_carousel_enable',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => false,
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control( 'reviews_carousel_enable',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Enable Carousel?', 'bizindustries' ),
				'section'     => 'reviews_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Autoplay
		$wp_customize->add_setting( 'reviews_carousel_autoplay',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control( 'reviews_carousel_autoplay',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel Autoplay?', 'bizindustries' ),
				'section'     => 'reviews_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel autoplay.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable') == true && get_theme_mod('reviews_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Slide Duration
		$wp_customize->add_setting( 'reviews_carousel_duration', 
			array(
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
				'validate_callback' => 'bizindustries_validate_duration',
				'default'          	=> 5000,
				'transport'         => 'refresh',
			) 
		);
		$wp_customize->add_control( 'reviews_carousel_duration', 
			array(
				'label'             => esc_html__( 'Carousel Duration', 'bizindustries' ),
				'description'       => esc_html__( 'Set the time in milisecond', 'bizindustries' ),
				'section'           => 'reviews_section_settings',
				'type'				=> 'number',
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable') == true && get_theme_mod('reviews_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
				'input_attrs'		=> array(
					'min'	=> 1000,
					'max'	=> 20000,
					'step'	=> 500,
					),
			) 
		);

		// Carousel Loop
		$wp_customize->add_setting( 'reviews_carousel_loop',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control( 'reviews_carousel_loop',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel loop?', 'bizindustries' ),
				'section'     => 'reviews_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel loop.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable') == true && get_theme_mod('reviews_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Nav Disable
		$wp_customize->add_setting( 'reviews_carousel_nav',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control( 'reviews_carousel_nav',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show carousel arrow?', 'bizindustries' ),
				'section'     => 'reviews_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to show/hide carousel arrows.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable') == true && get_theme_mod('reviews_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Dots
		$wp_customize->add_setting( 'reviews_carousel_dots',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control( 'reviews_carousel_dots',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show carousel dots?', 'bizindustries' ),
				'section'     => 'reviews_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to show/hide carousel dots.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('reviews_sec_enable') == true && get_theme_mod('reviews_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	}
		
		// Background color
		$wp_customize->add_setting( 'reviews_section_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'reviews_section_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'reviews_section_settings',
				'active_callback' => function(){
					if(get_theme_mod('reviews_sec_enable')){
						return true;
					} else {
						return false;
					}
				},
			) ) 
		);
		
		