<?php 
/**
 * Reason Section
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */
	$wp_customize->add_section( 'reasons_section_settings',
		array(
			'title'       => esc_html__( 'Why Choose Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority' => 4,
		)
	);
		$wp_customize->add_setting( 'whysec_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'whysec_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide why choose section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide why choose section on front page.', 'bizindustries' ),
			  'section'       => 'reasons_section_settings',
			  'type'          => 'checkbox',
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'why_section_title', 
			array(
				'default'           => esc_html__('Why Choose', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'why_section_title', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'reasons_section_settings',
				'type'    => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('whysec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Section subheading
		$wp_customize->add_setting( 'why_section_subtitle', 
			array(
				'default'           => esc_html__('The Reasons', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'why_section_subtitle', 
			array(
				'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'description'=> '',
				'section'    => 'reasons_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('whysec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		// Section Description
		$wp_customize->add_setting( 'why_section_desc', 
			array(
				'default'           => __('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'why_section_desc', 
			array(
				'label'      => esc_html__('Section Description', 'bizindustries'),
				'description'=> '',
				'section'    => 'reasons_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('whysec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);


		// Total Number
		$wp_customize->add_setting( 'reasons_total_items_show', 
			array(
				'default'           => 4,
				'capability'        => 'edit_theme_options',
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
			)
		);
		$wp_customize->add_control( 'reasons_total_items_show', 
			array(
				'label'       => esc_html__( 'Total Items to Show','bizindustries' ),
				'description' => esc_html__( 'After changing default value please save and reload','bizindustries' ),
				'type'        => 'number',
				'section'     => 'reasons_section_settings',
				'input_attrs' => array(
					'min'	=> 1,
					'max'	=> 12,
					'step'	=> 1,
				),
				'active_callback' => function(){
					 if(get_theme_mod('whysec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Content Type
		$wp_customize->add_setting('reasons_content_type', 
			array(
			'default' 			=> 'reasons_page',
			'sanitize_callback' => 'bizindustries_sanitize_select'
			)
		);

	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		$wp_customize->add_control('reasons_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'reasons_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'reasons_post'	   => __('Post','bizindustries'),
						'reasons_page'	   => __('Page','bizindustries'),
						'reasons_custom'  => __('Custom Content','bizindustries'),
				),
				'active_callback' => function(){
					 if( true === get_theme_mod('whysec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	} else { 
		$wp_customize->add_control('reasons_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'reasons_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'reasons_post'	   => __('Post','bizindustries'),
						'reasons_page'	   => __('Page','bizindustries'),
				),
				'active_callback' => function(){
					 if( true === get_theme_mod('whysec_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	}

	$reasons_items = get_theme_mod( 'reasons_total_items_show', 4);
	for( $i=1; $i<=$reasons_items; $i++ ) {
		//Icon
		$wp_customize->add_setting(
			'reasons_icon_'.$i,
			array(
				'default'			=> 'fa-bell',
				'sanitize_callback' => 'sanitize_text_field' // Done
			)
		);

		$wp_customize->add_control( 'reasons_icon_'.$i,
			array(
				/* translators: %1$s is replaced with number */
				'label'       => sprintf( __('Reasons #%1$s', 'bizindustries'), $i),
				/* translators: %1$s is replaced with number */
				'description'       => sprintf( __('Select a icon for reason #%1$s from <a target="_blank" href="https://fontawesome.com/v4.7/icons/">Font Awesome icons</a> and enter its class name. Example- fa-bell', 'bizindustries'), $i),
				'section'		=> 'reasons_section_settings',
				'type'			=> 'text',
				'active_callback' => function(){
					if( true === get_theme_mod('whysec_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		//Page
		$wp_customize->add_setting('featured_reason_page_'.$i.'', 
			array(
				'capability'        => 'edit_theme_options',	
				'sanitize_callback' => 'bizindustries_dropdown_pages'
			)
		);
		$wp_customize->add_control('featured_reason_page_'.$i.'', 
			array(
				/* translators: %1$s is replaced with number */
				'description' => sprintf( __('Select a page for Reason #%1$s title and description', 'bizindustries'), $i),
				'section'     => 'reasons_section_settings',   
				'settings'    => 'featured_reason_page_'.$i.'',		
				'type'        => 'dropdown-pages',
				'active_callback' => function(){
					$reasons_status = get_theme_mod('whysec_enable');
					$reasons_content_type = get_theme_mod('reasons_content_type');
					if($reasons_content_type == 'reasons_page' && $reasons_status == true ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

		// Posts
		$wp_customize->add_setting('featured_reason_post_'.$i.'', 
			array(
				'capability'        => 'edit_theme_options',	
				'sanitize_callback' => 'bizindustries_dropdown_pages'
			)
		);
		$wp_customize->add_control('featured_reason_post_'.$i.'', 
			array(
				/* translators: %1$s is replaced with number */
				'description' => sprintf( __('Select a Post for Reason #%1$s title and text', 'bizindustries'), $i),
				'section'     => 'reasons_section_settings',   
				'settings'    => 'featured_reason_post_'.$i.'',		
				'type'        => 'select',
				'choices'	  => bizindustries_dropdown_posts(),
				'active_callback' => function(){
					$reasons_status = get_theme_mod('whysec_enable');
					$reasons_content_type = get_theme_mod('reasons_content_type');
					if($reasons_content_type == 'reasons_post' && $reasons_status == true ){
						return true;
					} else {
						 return false;
					}
				},
			)
		);

	    if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
			//Cutsom Content- Title
			$wp_customize->add_setting( 'featured_reason_title_'.$i,
				array(
					'dafult'=> esc_html__('Responsive Design', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
				) 
			);
			$wp_customize->add_control( 'featured_reason_title_'.$i, 
				array(
                    /* translators: %1$s is replaced with number */
					'label'   => sprintf( __('Reason #%1$s Title', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'reasons_section_settings',
					'active_callback' => function(){
						$reasons_status = get_theme_mod('whysec_enable');
						$reasons_content_type = get_theme_mod('reasons_content_type');
						if($reasons_content_type == 'reasons_custom' && $reasons_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);
		
			//Description
			$wp_customize->add_setting( 'featured_reason_desc_'.$i,
				array(
					'dafult'           => esc_html__('Donec convallis mollis erat, sit amet rhoncus massa consectetur in. Phasellus nec velit nulla.', 'bizindustries'),
					'sanitize_callback'=> 'bizindustries_sanitize_html', 
				) 
			);
			$wp_customize->add_control( 'featured_reason_desc_'.$i, 
				array(
                    /* translators: %1$s is replaced with number */
					'label'       => sprintf( __('Reason #%1$s description', 'bizindustries'), $i),
					'type'        => 'textarea',
					'section'     => 'reasons_section_settings',
					'active_callback' => function(){
						$reasons_status = get_theme_mod('whysec_enable');
						$reasons_content_type = get_theme_mod('reasons_content_type');
						if($reasons_content_type == 'reasons_custom' && $reasons_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

		}
	}

		// Background color
		$wp_customize->add_setting( 'reasons_section_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'reasons_section_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'reasons_section_settings',
				'active_callback' => function(){
					if(get_theme_mod('whysec_enable')){
						return true;
					} else {
						return false;
					}
				},
			) ) 
		);
		