<?php 
/**
 * Product Section
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */
	$wp_customize->add_section( 'product_section_settings',
		array(
			'title'       => esc_html__( 'Products Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority' => 2,
			'divider' => 'before',
		)
	);
		$wp_customize->add_setting( 'products_section_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'products_section_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide Products Section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide products section on front page.', 'bizindustries' ),
			  'section'       => 'product_section_settings',
			  'settings'      => 'products_section_enable',
			  'type'          => 'checkbox',
			  'priority'      => 1
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'products_title', 
			array(
				'default'           => esc_html__('Our Products', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'products_title', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'product_section_settings',
				'type'    => 'text',
				'active_callback' => function(){
					 $products_enable = get_theme_mod('products_section_enable');
					 if($products_enable){
						return true;
					 } else {
						 return false;
					 }
				},
				'priority'=> 2,
			) 
		);

		// Section subheading
		$wp_customize->add_setting( 'products_subtitle', 
			array(
				'default'           => esc_html__('Explore', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'products_subtitle', 
			array(
			'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'description'=> '',
				'section'    => 'product_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 $products_enable = get_theme_mod('products_section_enable');
					 if($products_enable){
						return true;
					 } else {
						 return false;
					 }
				},
				'priority' => 3,
			)
		);
		
		// Section Description
		$wp_customize->add_setting( 'products_description', 
			array(
				'default'           => esc_html__('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'products_description', 
			array(
				'label'      => esc_html__('Section Description', 'bizindustries'),
				'description'=> '',
				'section'    => 'product_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 $products_enable = get_theme_mod('products_section_enable');
					 if($products_enable){
						return true;
					 } else {
						 return false;
					 }
				},
				'priority' => 3,
			)
		);

		// Total Number
		$wp_customize->add_setting( 'total_products', 
			array(
				'default'           => 3,
				'capability'        => 'edit_theme_options',
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
			)
		);
		$wp_customize->add_control( 'total_products', 
			array(
				'label'       => esc_html__( 'Total Items to Show','bizindustries' ),
				'description' => esc_html__( 'After changing default value please save and reload','bizindustries' ),
				'type'        => 'number',
				'section'     => 'product_section_settings',
				'input_attrs' => array(
					'min'	=> 1,
					'max'	=> 12,
					'step'	=> 1,
				),
				'active_callback' => function(){
					 if(get_theme_mod('products_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);


		// Content Type
		$wp_customize->add_setting('product_content_type', 
			array(
			'default' 			=> 'products_page',
			'sanitize_callback' => 'bizindustries_sanitize_select'
			)
		);

	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		$wp_customize->add_control('product_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'product_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'products_post'	   => __('Post', 'bizindustries'),
						'products_page'	   => __('Page', 'bizindustries'),
						'products_custom'  => __('Custom Content', 'bizindustries'),
				),
				'active_callback' => function(){
					 if( true === get_theme_mod('products_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	} else { 
		$wp_customize->add_control('product_content_type', 
			array(
				'label'       => __('Content Type', 'bizindustries'),
				'section'     => 'product_section_settings',   	
				'type'        => 'select',
				'choices' => array(
						'products_post'	   => __('Post','bizindustries'),
						'products_page'	   => __('Page','bizindustries'),
				),
				'active_callback' => function(){
					 if( true === get_theme_mod('products_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
	}








		$total_products = get_theme_mod( 'total_products', 3);
		for( $i=1; $i<=$total_products; $i++ ) {




			//Page
			$wp_customize->add_setting('featured_product_page_'.$i.'', 
				array(
					'capability'        => 'edit_theme_options',	
					'sanitize_callback' => 'bizindustries_dropdown_pages'
				)
			);
			$wp_customize->add_control('featured_product_page_'.$i.'', 
				array(
					/* translators: %1$s is replaced with number */
					'description' => sprintf( __('Select a page for Product #%1$s title, text and Image', 'bizindustries'), $i),
					'section'     => 'product_section_settings',   
					'settings'    => 'featured_product_page_'.$i.'',		
					'type'        => 'dropdown-pages',
					'active_callback' => function(){
						$product_status = get_theme_mod('products_section_enable');
						$product_content_type = get_theme_mod('product_content_type');
						if($product_content_type == 'products_page' && $product_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

			// Posts
			$wp_customize->add_setting('featured_product_post_'.$i.'', 
				array(
					'capability'        => 'edit_theme_options',	
					'sanitize_callback' => 'bizindustries_dropdown_pages'
				)
			);
			$wp_customize->add_control('featured_product_post_'.$i.'', 
				array(
					/* translators: %1$s is replaced with number */
					'description' => sprintf( __('Select a Post for Product #%1$s title, text and Image', 'bizindustries'), $i),
					'section'     => 'product_section_settings',   
					'settings'    => 'featured_product_post_'.$i.'',		
					'type'        => 'select',
					'choices'	  => bizindustries_dropdown_posts(),
					'active_callback' => function(){
						$product_status = get_theme_mod('products_section_enable');
						$product_content_type = get_theme_mod('product_content_type');
						if($product_content_type == 'products_post' && $product_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

	    if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
			//Image
			$wp_customize->add_setting(
				'product_image_'.$i,
				array(
					'default'			=> '',
					'sanitize_callback' => 'bizindustries_sanitize_image' // Done
				)
			);
			$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'product_image_'.$i,
					array(
						/* translators: %1$s is replaced with number */
						'label'       => sprintf( __('Product #%1$s', 'bizindustries'), $i),
						/* translators: %1$s is replaced with number */
						'description' => sprintf( __('Add product #%1$s image. Best size is 370x350', 'bizindustries'), $i),
						'section'  => 'product_section_settings',
						'active_callback' => function(){
							$product_status = get_theme_mod('products_section_enable');
							$product_content_type = get_theme_mod('product_content_type');
							if($product_content_type == 'products_custom' && $product_status == true ){
								return true;
							} else {
								 return false;
							}
						},
					)
				)
			);

			// Title
			$wp_customize->add_setting( 'product_title_'.$i,
				array(
					'dafult'=> __('Residential Products', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
				) 
			);
			$wp_customize->add_control( 'product_title_'.$i, 
				array(
					'label'   => '',
					    /* translators: %1$s is replaced with number */
					'description' => sprintf( __('Product #%1$s title', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'product_section_settings',
					'active_callback' => function(){
						$product_status = get_theme_mod('products_section_enable');
						$product_content_type = get_theme_mod('product_content_type');
						if($product_content_type == 'products_custom' && $product_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);

			//Description
			$wp_customize->add_setting( 'product_desc_'.$i,
				array(
					'dafult'           => __('Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'bizindustries'),
					'sanitize_callback'=> 'bizindustries_sanitize_html', 
				) 
			);
			$wp_customize->add_control( 'product_desc_'.$i, 
				array(
					'label'       => '',
					/* translators: %1$s is replaced with number */
					'description' => sprintf( __('Product #%1$s Description', 'bizindustries'), $i),
					'type'        => 'textarea',
					'section'     => 'product_section_settings',
					'active_callback' => function(){
						$product_status = get_theme_mod('products_section_enable');
						$product_content_type = get_theme_mod('product_content_type');
						if($product_content_type == 'products_custom' && $product_status == true ){
							return true;
						} else {
							 return false;
						}
					},
				)
			);
        }
			//Button Text
			$wp_customize->add_setting( 'product_btn_text_'.$i,
				array(
					'dafult'           => esc_html__('Explore Products', 'bizindustries'),
					'sanitize_callback'=> 'sanitize_text_field', 
				) 
			);
			$wp_customize->add_control( 'product_btn_text_'.$i, 
				array(
					/* translators: %1$s is replaced with number */
					'description'   => sprintf( __('Product #%1$s button text', 'bizindustries'), $i),
					'type'    => 'text',
					'section' => 'product_section_settings',
					'active_callback' => function(){
						 $products_enable = get_theme_mod('products_section_enable');
						 if($products_enable){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			);
		
			//Button URL
			$wp_customize->add_setting( 'product_btn_url_'.$i,
				array(
					'dafult'=> '',
					'sanitize_callback'=> 'esc_url_raw', 
				) 
			);
			$wp_customize->add_control( 'product_btn_url_'.$i, 
				array(
					/* translators: %1$s is replaced with number */
					'description'       => sprintf( __('Product #%1$s button URL', 'bizindustries'), $i),
					'type'        => 'url',
					'section'     => 'product_section_settings',
					'active_callback' => function(){
						 $products_enable = get_theme_mod('products_section_enable');
						 if($products_enable){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			);
		
			//Button target
			$wp_customize->add_setting( 'product_btn_target_'.$i,
				array(
					'dafult'           => '',
					'sanitize_callback'=> 'bizindustries_sanitize_checkbox', 
				) 
			);
			$wp_customize->add_control( 'product_btn_target_'.$i, 
				array(
                   /* translators: %1$s is replaced with number */
					'label'       => sprintf( __('Product #%1$s button open on new tab?', 'bizindustries'), $i),
					'type'        => 'checkbox',
					'section'     => 'product_section_settings',
					'active_callback' => function(){
						 $products_enable = get_theme_mod('products_section_enable');
						 if($products_enable){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			);

		}

		// Background color
		$wp_customize->add_setting( 'products_section_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'products_section_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'product_section_settings',
				'active_callback' => function(){
					 if(get_theme_mod('products_section_enable')){
						return true;
					 } else {
					 return false;
					 }
				},
			) ) 
		);
		
		
		