<?php
	
	$wp_customize->add_section( 'recent_news_settings',
		array(
			'title'       => esc_html__( 'Latest News Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority' => 7,
		)
	);
		// Section Hide/show
		$wp_customize->add_setting( 'recent_news_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'recent_news_enable', 
			array(
			  'label'   => esc_html__( 'Show/hide Latest News Section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide recent posts section on front page template.', 'bizindustries' ),
			  'section' => 'recent_news_settings',
			  'type'    => 'checkbox',
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'recent_posts_heading', 
			array(
				'default' => esc_html__('Latest News', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'recent_posts_heading', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'recent_news_settings',
				'type'    => 'text',
				'active_callback' => function(){
					 $recent_news_enable = get_theme_mod('recent_news_enable');
					 if($recent_news_enable){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);
		
		// Section subheading
		$wp_customize->add_setting( 'recent_posts_subheading', 
			array(
				'default' => esc_html__('From Blog', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'recent_posts_subheading', 
			array(
				'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'description'=> '',
				'section'    => 'recent_news_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 $recent_news_enable = get_theme_mod('recent_news_enable');
					 if($recent_news_enable){
						return true;
						} else {
						 return false;
					 }
				},
			)
		);
		
		// Section Description
		$wp_customize->add_setting( 'recent_posts_desc', 
			array(
				'default' => esc_html__('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'recent_posts_desc', 
			array(
				'label'      => esc_html__('Section Description', 'bizindustries'),
				'description'=> '',
				'section'    => 'recent_news_settings',
				'type'       => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		
		
		// Latest Posts
		$wp_customize->add_setting( 'recent_post_content_type', 
	        array(
	            'default'           => 'latest-post',
	            'sanitize_callback' => 'bizindustries_sanitize_select'
	        ) 
	    );
	    $wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'recent_post_content_type',
				array(
					'label'		  => esc_html__( 'Post Type', 'bizindustries' ),
					'section'	  => 'recent_news_settings',
					'type'        => 'select',
					'choices'	  => array(
						'latest-post'      => esc_html__('Latest Posts','bizindustries'),
						'select-category'  => esc_html__('Select Category','bizindustries'),
					),
					'active_callback' => function(){
						 $recent_news_enable = get_theme_mod('recent_news_enable');
						 if($recent_news_enable){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			)
		);


		// Select Category
		$wp_customize->add_setting('recent_post_category_choice',
			array(
				'default'           => '',
				'capability'        => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
			)
		);
		$wp_customize->add_control(
			new Bizindustries_Dropdown_Taxonomies_Control( $wp_customize, 
			'recent_post_category_choice',
			    array(
			        'label'       => esc_html__('Select Category', 'bizindustries'),
			        'description' => '',
			        'section'     => 'recent_news_settings',
			        'type'        => 'dropdown-taxonomies',
			        'taxonomy'    => 'category',
			        'settings'	  => 'recent_post_category_choice',
					'active_callback' => function(){
						 $recent_news_enable = get_theme_mod('recent_news_enable');
						 $recent_post_content_type = get_theme_mod('recent_post_content_type');
						 if($recent_news_enable && $recent_post_content_type == 'select-category' ){
							return true;
						 } else {
							 return false;
						 }
					},
		    	)
			)
		);

		// Total Post to show
        $wp_customize->add_setting( 'recent_posts_total_count', 
		 	array(
				'default' => 3,
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
			) 
		);
		$wp_customize->add_control( 'recent_posts_total_count', 
			array(
				'label'       => esc_html__( 'Total posts to Show','bizindustries' ),
				'description' => esc_html__( 'After changing default value please save and reload','bizindustries' ),
				'type'        => 'number',
				'section'     => 'recent_news_settings',
				'input_attrs' => array(
					'min'	=> 1,
					'max'	=> 99,
					'step'	=> 1,
				),
				'active_callback' => function(){
					 $recent_news_enable = get_theme_mod('recent_news_enable');
					 if($recent_news_enable ){
						return true;
					 } else {
						 return false;
					 }
				},

			)
		);

		// Display Post Thumbnail.
		$wp_customize->add_setting( 'recent_post_thumb_display',
			array(
				'default'			=> true,
				'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'recent_post_thumb_display',
			array(
				'label'			=> __( 'Display Post Thumbnail?', 'bizindustries' ),
				'description'	=> __( 'Check/Uncheck this box to show/hide post thumbnail', 'bizindustries' ),
				'section'		=> 'recent_news_settings',
				'type'			=> 'checkbox',
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		
		// Display Post Content
		$wp_customize->add_setting( 'recent_post_content_display',
			array(
				'default'			=> true,
				'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'recent_post_content_display',
			array(
				'type'			=> 'checkbox',
				'label'			=> __( 'Display Content?', 'bizindustries' ),
				'description'	=> __( 'Check/Uncheck this box to show/hide post content', 'bizindustries' ),
				'section'		=> 'recent_news_settings',
				'active_callback' => function(){
					 $recent_news_enable = get_theme_mod('recent_news_enable');
					 if($recent_news_enable){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		// Display Post Meta.
		$wp_customize->add_setting( 'recent_post_meta_display',
			array(
				'default'			=> true,
				'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'recent_post_meta_display',
			array(
				'label'			=> __( 'Display post meta?', 'bizindustries' ),
				'description'	=> __( 'Check/Uncheck this box to show/hide post meta', 'bizindustries' ),
				'section'		=> 'recent_news_settings',
				'type'			=> 'checkbox',
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Display Date Meta.
		$wp_customize->add_setting( 'recent_post_date_display',
			array(
				'default'			=> true,
				'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'recent_post_date_display',
			array(
				'type'			=> 'checkbox',
				'label'			=> __( 'Display Date', 'bizindustries' ),
				'description'	=> __( 'Check/Uncheck this box to show/hide post date', 'bizindustries' ),
				'section'		=> 'recent_news_settings',
				'active_callback' => function(){
					 $recent_news_enable = get_theme_mod('recent_news_enable');
					 if($recent_news_enable){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Display Date Meta.
		$wp_customize->add_setting( 'recent_post_readmore_display',
			array(
				'default'			=> true,
				'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'recent_post_readmore_display',
			array(
				'type'			=> 'checkbox',
				'label'			=> __( 'Read more button display?', 'bizindustries' ),
				'description'	=> __( 'Check/Uncheck this box to show/hide post date', 'bizindustries' ),
				'section'		=> 'recent_news_settings',
				'active_callback' => function(){
					 $recent_news_enable = get_theme_mod('recent_news_enable');
					 if($recent_news_enable){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);



		// Enable Carousel
		$wp_customize->add_setting( 'news_carousel_enable',
			array(
				'default'			=> false,
				'sanitize_callback'	=> 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'news_carousel_enable',
			array(
				'section'		=> 'recent_news_settings',
				'type'			=> 'checkbox',
				'label'			=> __( 'Enable Carousel?', 'bizindustries' ),
				'active_callback' => function(){
					 $recent_news_enable = get_theme_mod('recent_news_enable');
					 if($recent_news_enable == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);	
if(bizindustries_set_to_premium()) {
		// Carousel Autoplay
		$wp_customize->add_setting( 'news_carousel_autoplay',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'news_carousel_autoplay',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel Autoplay?', 'bizindustries' ),
				'section'     => 'recent_news_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel autoplay.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable') == true && get_theme_mod('news_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Slide Duration
		$wp_customize->add_setting( 'news_carousel_duration', 
			array(
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
				'validate_callback' => 'bizindustries_validate_duration',
				'default'          	=> 5000,
			) 
		);
		$wp_customize->add_control( 'news_carousel_duration', 
			array(
				'label'             => esc_html__( 'Carousel Duration', 'bizindustries' ),
				'description'       => esc_html__( 'Set the time in milisecond', 'bizindustries' ),
				'section'           => 'recent_news_settings',
				'type'				=> 'number',
				'input_attrs'		=> array(
					'min'	=> 1000,
					'max'	=> 20000,
					'step'	=> 500,
				),
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable') == true && get_theme_mod('news_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Carousel Loop
		$wp_customize->add_setting( 'news_carousel_loop_enable',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'news_carousel_loop_enable',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel loop?', 'bizindustries' ),
				'section'     => 'recent_news_settings',
				'description' => esc_html__( 'Check/Uncheck to enable/disable carousel loop.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable') == true && get_theme_mod('news_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Nav Disable
		$wp_customize->add_setting( 'news_carousel_nav_display',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'news_carousel_nav_display',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show carousel arrow?', 'bizindustries' ),
				'section'     => 'recent_news_settings',
				'description' => esc_html__( 'Check/Uncheck to show/hide carousel arrows.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable') == true && get_theme_mod('news_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Dots
		$wp_customize->add_setting( 'news_carousel_dots_display',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => false,
			)
		);
		$wp_customize->add_control( 'news_carousel_dots_display',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show carousel dots?', 'bizindustries' ),
				'section'     => 'recent_news_settings',
				'description' => esc_html__( 'Check/Uncheck to show/hide carousel dots.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable') == true && get_theme_mod('news_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
}
		// Background color
		$wp_customize->add_setting( 'recent_news_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'recent_news_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'recent_news_settings',
				'active_callback' => function(){
					 if(get_theme_mod('recent_news_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) ) 
		);







