<?php 
	
$wp_customize->add_section( 'cta_section_settings',
	array(
		'title'       => esc_html__( 'Call to Action', 'bizindustries' ),
		'description' => '',
		'panel'       => 'bizindustries_frontpage_settings',
		'priority' => 5,
		'divider' => 'before',
	)
);

		$wp_customize->add_setting( 'cta_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox'
			)
		);
		$wp_customize->add_control( 'cta_enable', 
			array(
			  'label'   => esc_html__( 'Show/hide CTA', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide call to action section on front page template.', 'bizindustries' ),
			  'section' => 'cta_section_settings',
			  'type'    => 'checkbox',
			)
		);
		
		// CTA Title
		$wp_customize->add_setting( 'cta_title',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_html',
				'default'           => __( 'We <strong>never compromized</strong> our products quality.', 'bizindustries' ),
				'transport'			=> 'postMessage'
			)
		);
		$wp_customize->add_control( 'cta_title',
			array(
				'label'       => esc_html__( 'Title', 'bizindustries' ),
				'description' => '',
				'type'    => 'text',
				'section'     => 'cta_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'cta_enable' ) ) {
					return true;
					} else {
					return false;
					}
				},

			)
		);

		// CTA Description
		$wp_customize->add_setting( 'cta_description',
			array(
				'sanitize_callback' => 'sanitize_textarea_field',
				'default'           => esc_html__( 'Bizindustries Products are made in the USA at our ISO registered facilities by American workers dedicated to producing the highest quality expansion tanks in the world.', 'bizindustries' ),
				'transport'			=> 'postMessage'
			)
		);
		$wp_customize->add_control( 'cta_description',
			array(
				'label'       => esc_html__( 'Description', 'bizindustries' ),
				'description' => '',
				'type'        => 'textarea',
				'section'     => 'cta_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'cta_enable' ) ) {
					return true;
					} else {
					return false;
					}
				},
			)
		);
		
		// Button Text
		$wp_customize->add_setting('cta_btn_text',
			 array(
				'sanitize_callback' => 'sanitize_text_field',
				'default'           => esc_html__( 'Explore Products', 'bizindustries' ),
				'transport'			=> 'postMessage'
			)
		);
		$wp_customize->add_control('cta_btn_text',
			 array(
				'label'     => esc_html__('Button Text', 'bizindustries'),
				'description' => '',
				'type'    => 'text',
				'section'   => 'cta_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'cta_enable' ) ) {
					return true;
					} else {
					return false;
					}
				},
			)
		);

		// Button URL
		$wp_customize->add_setting('cta_btn_url', 
			array(
				'sanitize_callback' => 'esc_url_raw',
				'default'           => '',
				//'transport'         => 'postMessage',
			)
		);
		$wp_customize->add_control('cta_btn_url', 
			array(
				'label'       => esc_html__('Button Link', 'bizindustries'),
				'description' => esc_html__( 'Start with http:// or https://', 'bizindustries' ),
				'type'        => 'url',
				'section'     => 'cta_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'cta_enable' ) ) {
					return true;
					} else {
					return false;
					}
				},
			)
		);

		// Button Target
		$wp_customize->add_setting( 'cta_btn_target',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => false,
				//'transport'         => 'postMessage',
			)
		);
		$wp_customize->add_control( 'cta_btn_target',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Open on new tab?', 'bizindustries' ),
				'section'     => 'cta_section_settings',
				'active_callback' => function(){
					if( get_theme_mod( 'cta_enable' ) ) {
					return true;
					} else {
					return false;
					}
				},
			)
		);
		
		// Button BG Color
		$wp_customize->add_setting( 'cta_bg_color', array(
				'sanitize_callback'    => 'sanitize_hex_color_no_hash',
				'sanitize_js_callback' => 'maybe_hash_hex_color',
				'default'              => '#252525'
			)
		);
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'cta_bg_color',
				array(
					'label'       => esc_html__( 'Background', 'bizindustries' ),
					'section'     => 'cta_section_settings',
					'active_callback' => function(){
						if( get_theme_mod( 'cta_enable' ) ) {
						return true;
						} else {
						return false;
						}
					},
				)
			) 
		);
		