<?php  
	
		$wp_customize->add_section( 'contact_section_settings',
			array(
				'title'       => esc_html__( 'Contact Section', 'bizindustries' ),
				'description' => '',
				'panel'       => 'bizindustries_frontpage_settings',
				'priority' => 9,
			)
		);

		// Section Hide/show
		$wp_customize->add_setting( 'contact_section_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'contact_section_enable', 
			array(
			  'label'   => esc_html__( 'Show/hide Contact Section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide contact section on front page template.', 'bizindustries' ),
			  'section' => 'contact_section_settings',
			  'settings' => 'contact_section_enable',
			  'type'    => 'checkbox',
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'contact_section_title', 
			array(
				'default' => esc_html__('Contact Us', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_title', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'contact_section_settings',
				'type'    => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			) 
		);
		
		// Section subheading
		$wp_customize->add_setting( 'contact_section_subtitle', 
			array(
				'default' => esc_html__('Give us a Call', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_subtitle', 
			array(
				'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'description'=> '',
				'section'    => 'contact_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Section Description
		$wp_customize->add_setting( 'contact_section_desc', 
			array(
				'default' => esc_html__('Top quality services executed by our devoted, yet creative team. We are focused on making you stand out.', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_desc', 
			array(
				'label'      => esc_html__('Section Description', 'bizindustries'),
				'description'=> '',
				'section'    => 'contact_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Office Title
		$wp_customize->add_setting( 'contact_section_office_title', 
			array(
				'default' => esc_html__('Bizindustries Inc.', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_office_title', 
			array(
				'label'      => esc_html__('Office Title', 'bizindustries'),
				'description'=> '',
				'section'    => 'contact_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);
		
		// Office Type
		$wp_customize->add_setting( 'contact_section_office_type', 
			array(
				'default' => esc_html__('Corporate Office', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_office_type', 
			array(
				'label'      => esc_html__('Office Type', 'bizindustries'),
				'description' => '',
				'section'     => 'contact_section_settings',
				'type'        => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);
		

		// Address
		$wp_customize->add_setting( 'contact_section_office_address', 
			array(
				'default' => esc_html__('1400 Division Road, West Warwick, R.I. 123456', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				//'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_office_address', 
			array(
				'label'       => '',
				'description' => esc_html__('Address', 'bizindustries'),
				'section'     => 'contact_section_settings',
				'type'        => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);
		

		// Phone
		$wp_customize->add_setting( 'contact_section_phone', 
			array(
				'default' => esc_html__('(401) 123-4567', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				//'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_phone', 
			array(
				'label'       => '',
				'description' => esc_html__('Phone', 'bizindustries'),
				'section'     => 'contact_section_settings',
				'type'        => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Fax
		$wp_customize->add_setting( 'contact_section_fax', 
			array(
				'default' => esc_html__('(401) 123-4567', 'bizindustries'),
				'sanitize_callback' => 'sanitize_text_field',
				//'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_fax', 
			array(
				'label'       => '',
				'description' => esc_html__('Fax', 'bizindustries'),
				'section'     => 'contact_section_settings',
				'type'        => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Email
		$wp_customize->add_setting( 'contact_section_general_email', 
			array(
				'default' => esc_html__('info@bizindustries.com', 'bizindustries'),
				'sanitize_callback' => 'bizindustries_sanitize_email',
				//'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_general_email', 
			array(
				'label'       => '',
				'description' => esc_html__('Email for general inquiries', 'bizindustries'),
				'section'     => 'contact_section_settings',
				'type'        => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Email
		$wp_customize->add_setting( 'contact_section_warenty_email', 
			array(
			    'default' => esc_html__('warranty@bizindustries.com', 'bizindustries'),
				'sanitize_callback' => 'bizindustries_sanitize_email',
				//'transport' => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'contact_section_warenty_email', 
			array(
				'label'       => '',
				'description' => esc_html__('Email for warranty', 'bizindustries'),
				'section'     => 'contact_section_settings',
				'type'        => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Form Shortcoe
		$wp_customize->add_setting( 'contact_section_form_shortcode', 
		 	array(
				'default' => '',
				'sanitize_callback' => 'sanitize_text_field',
				'capability' => 'edit_theme_options',
			) 
		);
		$wp_customize->add_control( 'contact_section_form_shortcode', 
			array(
				'label'       => esc_html__('Form Shortcode','bizindustries'),
				'description' => esc_html__('Shortcode of conatct form 7 for Form','bizindustries'),
				'section'     => 'contact_section_settings',
				'type'        => 'text',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);

		// Background color
		$wp_customize->add_setting( 'contact_section_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'contact_section_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'contact_section_settings',
				'active_callback' => function(){
					if(get_theme_mod('contact_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			) ) 
		);
