<?php 
/**
 * Brands Section
 * @since 1.0.0
 * ----------------------------------------------------------------------
 */
	$wp_customize->add_section( 'brands_section_settings',
		array(
			'title'       => esc_html__( 'Brands Logo Section', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_frontpage_settings',
			'priority' => 8,
		)
	);
		$wp_customize->add_setting( 'brands_section_enable', 
			array(
			  'default'  =>  false,
			  'sanitize_callback' => 'bizindustries_sanitize_checkbox',
			)
		);
		$wp_customize->add_control( 'brands_section_enable', 
			array(
			  'label'         => esc_html__( 'Show/hide brands section', 'bizindustries' ),
			  'description'   => esc_html__( 'Check/Uncheck this box to show/hide brands section on front page.', 'bizindustries' ),
			  'section'       => 'brands_section_settings',
			  'type'          => 'checkbox',
			)
		);

		//Section Heading
		$wp_customize->add_setting( 'brands_section_heading', 
			array(
				'default'           => '',
				'sanitize_callback' => 'bizindustries_sanitize_html',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'brands_section_heading', 
			array(
			    'label'   => esc_html__( 'Section Heading', 'bizindustries' ),
				'section' => 'brands_section_settings',
				'type'    => 'text',
				'active_callback' => function(){
					 if(get_theme_mod('brands_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Section subheading
		$wp_customize->add_setting( 'brands_section_subheading', 
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage'
			) 
		);
		$wp_customize->add_control( 'brands_section_subheading', 
			array(
				'label'      => esc_html__('Section Subheading', 'bizindustries'),
				'description'=> '',
				'section'    => 'brands_section_settings',
				'type'       => 'text',
				'active_callback' => function(){
					if(get_theme_mod('brands_section_enable')){
						return true;
					} else {
						return false;
					}
				},
			)
		);
		$is_premium = bizindustries_set_to_premium(); 
		// Brand Logos
		$wp_customize->add_setting( 
			new Bizindustries_Control_Repeater_Setting( 
				$wp_customize, 
				'bizindustries_brands', 
				array(
					'default' => '',
					'sanitize_callback' => array( 'Bizindustries_Control_Repeater_Setting', 'sanitize_repeater_setting' ),
				) 
			) 
		);
		$wp_customize->add_control(
			new Bizindustries_Control_Repeater(
				$wp_customize,
				'bizindustries_brands',
				array(
					'section'       => 'brands_section_settings',
					'label'         => esc_html__( 'Brand Logos', 'bizindustries' ),
					'fields'  => array(
						'title' => array(
							'type'        => 'text',
							'label'       => esc_html__( 'Title', 'bizindustries' ),
						),
						'image' => array(
							'type'    => 'image',
							'label'   => __( 'Upload Logo', 'bizindustries' ),
						),
						'link' => array(
							'type'        => 'url',
							'label'       => esc_html__( 'Link', 'bizindustries' ),
							'description' => esc_html__( 'Example: https://yoursite.com', 'bizindustries' ),
						),
						'checkbox' => array(
							'type'        => 'checkbox',
							'label'       => esc_html__( 'Open link in new tab', 'bizindustries' ),
						),
					),
					'row_label' => array(
						'type'  => 'field',
						'value' => esc_html__( 'logo', 'bizindustries' ),
						'field' => 'title'
					),
					'choices' => array(
						'limit' => $is_premium==false?7:'',
					),
					'active_callback' => function(){
						 if(get_theme_mod('brands_section_enable')){
							return true;
						 } else {
							 return false;
						 }
					},
				)
			)
		);

		// Carousel Autoplay
		$wp_customize->add_setting( 'brands_carousel_autoplay',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'brands_carousel_autoplay',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel Autoplay?', 'bizindustries' ),
				'section'     => 'brands_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel autoplay.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('brands_section_enable') == true && get_theme_mod('brands_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Slide Duration
		$wp_customize->add_setting( 'brands_carousel_duration', 
			array(
				'sanitize_callback' => 'bizindustries_sanitize_number_range',
				'validate_callback' => 'bizindustries_validate_duration',
				'default'          	=> 3000,
			) 
		);
		$wp_customize->add_control( 'brands_carousel_duration', 
			array(
				'label'             => esc_html__( 'Carousel Duration', 'bizindustries' ),
				'description'       => esc_html__( 'Set the time in milisecond', 'bizindustries' ),
				'section'           => 'brands_section_settings',
				'type'				=> 'number',
				'input_attrs'		=> array(
					'min'	=> 1000,
					'max'	=> 20000,
					'step'	=> 500,
				),
				'active_callback' => function(){
					 if(get_theme_mod('brands_section_enable') == true && get_theme_mod('brands_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			) 
		);

		// Carousel Loop
		$wp_customize->add_setting( 'brands_carousel_loop_enable',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'brands_carousel_loop_enable',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Carousel loop?', 'bizindustries' ),
				'section'     => 'brands_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to enable/disable carousel loop.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('brands_section_enable') == true && get_theme_mod('brands_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);

		// Carousel Nav Disable
		$wp_customize->add_setting( 'brands_carousel_nav_display',
			array(
				'sanitize_callback' => 'bizindustries_sanitize_checkbox',
				'default'           => true,
			)
		);
		$wp_customize->add_control( 'brands_carousel_nav_display',
			array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Show carousel arrow?', 'bizindustries' ),
				'section'     => 'brands_section_settings',
				'description' => esc_html__( 'Check/Uncheck this box to show/hide carousel arrows.', 'bizindustries' ),
				'active_callback' => function(){
					 if(get_theme_mod('brands_section_enable') == true && get_theme_mod('brands_carousel_enable') == true){
						return true;
					 } else {
						 return false;
					 }
				},
			)
		);
		
		// Background color
		$wp_customize->add_setting( 'brands_section_bg', 
			array(
					'sanitize_callback'    => 'sanitize_hex_color_no_hash',
					'sanitize_js_callback' => 'maybe_hash_hex_color',
					'default'              => '',
				) 
			);
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'brands_section_bg', 
			array(
				'label' => esc_html__( 'Background', 'bizindustries' ),
				'description'   => '',
				'section' => 'brands_section_settings',
				'active_callback' => function(){
					 if(get_theme_mod('brands_section_enable')){
						return true;
					 } else {
						 return false;
					 }
				},
			) ) 
		);
		
		