<?php
/**
 * Bizindustries Theme Customizer
 *
 * @package Bizindustries
 */
 
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function bizindustries_customize_register( $wp_customize ) {
	
	// Load custom controls.
	require_once get_template_directory() . '/inc/customizer/customizer-extra.php';
	require_once get_template_directory() . '/inc/customizer/customizer-controls.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	// Move to panel
	$wp_customize->get_section( 'header_image' )->panel 	= 'bizindustries_theme_options';
	$wp_customize->get_section( 'header_image' )->title     = __( 'Banner Settings', 'bizindustries' );
	$wp_customize->get_section( 'header_image' )->priority 	= 7;

	// Remove Controls
	$wp_customize->remove_control('display_header_text');

	//Theme Options
	require_once get_template_directory() . '/inc/customizer/theme-options/theme-options.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/site-identity.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-global.php';

	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
	require_once get_template_directory() . '/inc/customizer/theme-options/options-typography.php';
	}

	require_once get_template_directory() . '/inc/customizer/theme-options/options-colors.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-header.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-misc.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-navigation.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-blog.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-page.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-single.php';
	require_once get_template_directory() . '/inc/customizer/theme-options/options-footer.php';

	// Frontpage Settings
	require_once get_template_directory() . '/inc/customizer/front-page/options-home.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-slider.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-services.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-products.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-slogan.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-reasons.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-reviews.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-cta.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-contact.php';

	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
	require_once get_template_directory() . '/inc/customizer/front-page/options-news.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-team.php';
	require_once get_template_directory() . '/inc/customizer/front-page/options-brands.php';
	}
	// Contact Page Settings
	require_once get_template_directory() . '/inc/customizer/contact/options-contact.php';

	// WooCommerce Settings
	if(class_exists( 'WooCommerce' ) && bizindustries_set_to_premium() ) {
	require_once get_template_directory() . '/inc/customizer/woocommerce/options-shop.php';
	require_once get_template_directory() . '/inc/customizer/woocommerce/options-product-single.php';
	}

	// Section Order
	if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		require_once get_template_directory() . '/inc/customizer/sections-order/section-order.php';
	}

}
add_action( 'customize_register', 'bizindustries_customize_register' );


/**
 * Selective refresh
 */
require get_template_directory() . '/inc/customizer/customizer-selective-refresh.php';

/**
 * Upgrade
 */
if(!bizindustries_set_to_premium()){
require get_template_directory() . '/inc/customizer/upgrade-pro/class-upgrade.php';
}
/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function bizindustries_customize_preview_js() {
	wp_enqueue_script( 'bizindustries-customizer-liveview', get_template_directory_uri() . '/inc/customizer/assets/js/customizer-liveview.js', array( 'customize-preview', 'customize-selective-refresh' ), false, true );
}
add_action( 'customize_preview_init', 'bizindustries_customize_preview_js', 65 );