<?php 

/**
 * Add customizer selective refresh
 */
function bizindustries_customizer_partials( $wp_customize ) {

    // Abort if selective refresh is not available.
    if ( ! isset( $wp_customize->selective_refresh ) ) {
        return;
    }

	// Site Title
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector'        => '.site-title a',
		'render_callback' =>  function(){
				return bloginfo( 'name' );
		    },
	) );

	// Tagline
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector'        => '.site-description',
		'render_callback' =>  function(){
				return bloginfo( 'description' );
		    },
	) );

	// Blog Page Title
	$wp_customize->selective_refresh->add_partial( 'blog_page_title', array(
		'selector' => '.page-banner .page-title',
		'settings' => array( 'blog_page_title' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'blog_page_title');
		    },
	) );

	// Read more text
	$wp_customize->selective_refresh->add_partial( 'post_read_more_text', array(
		'selector' => '.single-news .entry-content .read-more',
		'settings' => array( 'post_read_more_text' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'post_read_more_text');
		    },
	) );
	
	// Front page
	
	// Porducts Section
	$wp_customize->selective_refresh->add_partial( 'products_title', array(
		'selector' => '.prodcuts-heaings h2',
		'settings' => array( 'products_title' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'products_title');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'products_subtitle', array(
		'selector' => '.prodcuts-heaings p.sub-title',
		'settings' => array( 'products_subtitle' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'products_subtitle');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'products_description', array(
		'selector' => '.prodcuts-heaings .p-desc',
		'settings' => array( 'products_description' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'products_description');
		    },
	) );
	
	// Services
	$wp_customize->selective_refresh->add_partial( 'services_section_heading', array(
		'selector' => '.intro-content h3',
		'settings' => array( 'services_section_heading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'services_section_heading');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'services_section_subheading', array(
		'selector' => '#services-section .section-heading .sub-title',
		'settings' => array( 'services_section_subheading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'services_section_subheading');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'services_section_desc', array(
		'selector' => '#services-section .intro-content .des-1',
		'settings' => array( 'services_section_desc' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'services_section_desc');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'services_section_desc_2', array(
		'selector' => '#services-section .intro-content .des-2',
		'settings' => array( 'services_section_desc_2' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'services_section_desc_2');
		    },
	) );

	// Slogan Section
	$wp_customize->selective_refresh->add_partial( 'slogan_title', array(
		'selector' => '.slogan-area h2',
		'settings' => array( 'slogan_title' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'slogan_title');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'slogan_subtitle', array(
		'selector' => '.slogan-area h4',
		'settings' => array( 'slogan_subtitle' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'slogan_subtitle');
		    },
	) );
	
	// The Resons Section
	$wp_customize->selective_refresh->add_partial( 'why_section_title', array(
		'selector' => '.why-area .section-heading  h2',
		'settings' => array( 'why_section_title' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'why_section_title');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'why_section_subtitle', array(
		'selector' => '.why-area .section-heading  .sub-title',
		'settings' => array( 'why_section_subtitle' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'why_section_subtitle');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'why_section_desc', array(
		'selector' => '.why-area .section-heading  .desc',
		'settings' => array( 'why_section_desc' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'why_section_desc');
		    },
	) );

	//Review Section
	$wp_customize->selective_refresh->add_partial( 'reviews_heading', array(
		'selector' => '.testimonials-area .section-heading  h2',
		'settings' => array( 'reviews_heading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'reviews_heading');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'reviews_subheading', array(
		'selector' => '.testimonials-area .section-heading  .sub-title',
		'settings' => array( 'reviews_subheading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'reviews_subheading');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'reviews_description', array(
		'selector' => '.testimonials-area .section-heading  .desc',
		'settings' => array( 'reviews_description' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'reviews_description');
		    },
	) );

	//CTA Section
	$wp_customize->selective_refresh->add_partial( 'cta_title', array(
		'selector' => '.cta-wrap  h4',
		'settings' => array( 'cta_title' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'cta_title');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'cta_description', array(
		'selector' => '.cta-wrap  p',
		'settings' => array( 'cta_description' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'cta_description');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'cta_btn_text', array(
		'selector' => '.cta-area .btn-wrap .btn',
		'settings' => array( 'cta_btn_text' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'cta_btn_text');
		    },
	) );

	//Team Section
	$wp_customize->selective_refresh->add_partial( 'team_heading', array(
		'selector' => '#team-section .section-heading  h2',
		'settings' => array( 'team_heading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'team_heading');
				},
	) );
	$wp_customize->selective_refresh->add_partial( 'team_subheading', array(
		'selector' => '#team-section .section-heading  .sub-title',
		'settings' => array( 'team_subheading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'team_subheading');
				},
	) );
	$wp_customize->selective_refresh->add_partial( 'team_description', array(
		'selector' => '#team-section .section-heading  .desc',
		'settings' => array( 'team_description' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'team_description');
				},
	) );

	// Brands
	$wp_customize->selective_refresh->add_partial( 'brands_section_heading', array(
		'selector' => '#brands-section .section-heading  h2',
		'settings' => array( 'brands_section_heading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'brands_section_heading');
				},
	) );
	$wp_customize->selective_refresh->add_partial( 'brands_section_subheading', array(
		'selector' => '#brands-section .section-heading  .sub-title',
		'settings' => array( 'brands_section_subheading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'brands_section_subheading');
				},
	) );

	// Recent Posts
	$wp_customize->selective_refresh->add_partial( 'recent_posts_heading', array(
		'selector' => '#recent-news .section-heading h2',
		'settings' => array( 'recent_posts_heading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'recent_posts_heading');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'recent_posts_subheading', array(
		'selector' => '#recent-news .section-heading .sub-title',
		'settings' => array( 'recent_posts_subheading' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'recent_posts_subheading');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'recent_posts_desc', array(
		'selector' => '#recent-news .section-heading .desc',
		'settings' => array( 'recent_posts_desc' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'recent_posts_desc');
		    },
	) );



	//Contact Section
	$wp_customize->selective_refresh->add_partial( 'contact_section_title', array(
		'selector' => '#contact-section .section-heading h2',
		'settings' => array( 'contact_section_title' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'contact_section_title');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'contact_section_subtitle', array(
		'selector' => '#contact-section .section-heading .sub-title',
		'settings' => array( 'contact_section_subtitle' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'contact_section_subtitle');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'contact_section_desc', array(
		'selector' => '#contact-section .section-heading .desc',
		'settings' => array( 'contact_section_desc' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'contact_section_desc');
		    },
	) );

	$wp_customize->selective_refresh->add_partial( 'contact_section_office_title', array(
		'selector' => '.contact-box .contact-heading h4',
		'settings' => array( 'contact_section_office_title' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'contact_section_office_title');
		    },
	) );
	$wp_customize->selective_refresh->add_partial( 'contact_section_office_type', array(
		'selector' => '.contact-box .contact-heading p',
		'settings' => array( 'contact_section_office_type' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'contact_section_office_type');
		    },
	) );



	// Related Post Title
	$wp_customize->selective_refresh->add_partial( 'related_posts_label', array(
		'selector' => '.related-heading h4',
		'settings' => array( 'related_posts_label' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'related_posts_label');
		    },
	) );


	// Footer Copyright Text
	$wp_customize->selective_refresh->add_partial( 'footer_copyright_text', array(
		'selector' => '.footer-bottom #copyright-text',
		'settings' => array( 'footer_copyright_text' ),
		'render_callback' =>  function(){
				return get_theme_mod( 'footer_copyright_text');
			},
	) );

    /**
     * Selective Refresh style
     */
    $css_settings = array(

		// Site Identity
        'site_title_font_family',
        'site_title_font_size',
        'site_title_color',
        'tagline_font_family',
        'tagline_font_size',
        'tagline_text_color',

		//Color Settings
		'site_primary_color',
		'site_secondary_color',
		'site_heading_color',
		'body_text_color',
		'site_btn_bg_color',
		'site_btn_bg_hcolor',
		'site_btn_text_color',
		'site_btn_hover_text_color',

		// Typography
        'heading_font_family',
        'body_font_family',
        'body_font_size',
        'btn_font_family',

		//Header Settings
		'header_top_bg_color',

		//Navigation Settings
		'navigation_bg',
		'menu_font_family',
		'menu_link_color',
		'menu_hover_link_color',
		'submenu_bg_color',
		'submenu_text_color',
		'submenu_hover_text_color',

		// Slogan Section
		'slogan_overlay_bg_color',
		
		// Products Section
		'products_section_bg',
		
		// Reason Section
		'reasons_section_bg',
		
		// Reviews Section
		'reviews_section_bg',
		
		// Team Section
		'team_section_bg',
		
		// Services Section
		'service_section_bg',
		
		// Brands Logos
		'brands_section_bg',
		
		// Recent News
		'recent_news_bg',

		// Call to Action
		'cta_bg_color',

		// Contact Section
		'contact_section_bg',
		// Preloader
		'preloader_bg_color',
		// Footer
        'footer_widgets_bg_color',
        'footer_widgets_title_color',
        'footer_widgets_text_color',
        'footer_widgets_link_color',
        'footer_widgets_link_hcolor',

        'footer_copyright_text',
        'footer_copyright_bg_color',
        'footer_copyright_text_color',

    );
	
	$css_settings = apply_filters( 'bizindustries_selective_refresh_css_settings', $css_settings );

    foreach( $css_settings as $index => $key ) {
        if ( $wp_customize->get_setting( $key ) ) {
            $wp_customize->get_setting( $key )->transport = 'postMessage';
        } else {
            unset( $css_settings[ $index ] );
        }
    }
	
    $wp_customize->selective_refresh->add_partial( 'bizindustries-style-live-css', array(
        'selector' => '#bizindustries-style-inline-css',
        'settings' => $css_settings,
        'container_inclusive' => false,
        'render_callback' => 'bizindustries_custom_inline_style',
    ) );
	
}
add_action( 'customize_register', 'bizindustries_customizer_partials', 199 );