<?php
	
/**
 * Extra functions for customizer
 *
 * @package Bizindustries
 */

if ( ! function_exists( 'validate_excerpt_count' ) ) :
	/**
	 * Validation functions
	 * Check if the input value is valid integer.
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return string Whether the value is valid to the current preview.
	 */
	function validate_excerpt_count( $validity, $value ){
		$value = intval( $value );
		if ( empty( $value ) || ! is_numeric( $value ) ) {
			$validity->add( 'required', esc_html__( 'You must supply a valid number.', 'bizindustries' ) );
		} elseif ( $value < 1 ) {
			$validity->add( 'min_slider', esc_html__( 'Minimum no of Excerpt Lenght is 1', 'bizindustries' ) );
		} elseif ( $value > 50 ) {
			$validity->add( 'max_slider', esc_html__( 'Maximum no of Excerpt Lenght is 50', 'bizindustries' ) );
		}
		return $validity;
	}
endif;
	
	
	
if ( ! function_exists( 'bizindustries_dropdown_posts' ) ) :
	/**
	 * Post Dropdown.
	 *
	 * @since 1.0.0	 *
	 */
	function bizindustries_dropdown_posts() {

		$posts = get_posts( array( 'numberposts' => -1 ) );
		$choices = array();
		$choices[0] = esc_html__( '--Select--', 'bizindustries' );
		foreach ( $posts as $post ) {
			$choices[$post->ID] = $post->post_title;
		}
		return $choices;
	}

endif;


if ( ! function_exists( 'bizindustries_validate_duration' ) ) :
	/**
	 * Check if the input value is valid integer.
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return string Whether the value is valid to the current preview.
	 */
	function bizindustries_validate_duration( $validity, $value ){
		$value = intval( $value );
		if ( empty( $value ) || ! is_numeric( $value ) ) {
			$validity->add( 'required', esc_html__( 'You must supply a valid number.', 'bizindustries' ) );
		} elseif ( $value < 1000 ) {
			$validity->add( 'min_slider', esc_html__( 'Minimum time of duration is 1000', 'bizindustries' ) );
		} elseif ( $value > 20000 ) {
			$validity->add( 'max_slider', esc_html__( 'Maximum time of duration is 20000', 'bizindustries' ) );
		}
		return $validity;
	}
endif;



if( ! class_exists( 'Bizindustries_Dropdown_Taxonomies_Control' ) ):
    class Bizindustries_Dropdown_Taxonomies_Control extends WP_Customize_Control{
    private $cats = false;

    public function __construct($manager, $id, $args = array(), $options = array())
    {
        $this->cats = get_categories($options);

        parent::__construct( $manager, $id, $args );
		}

    /**
     * Render the content of the category dropdown
     *
     * @return HTML
     */
    public function render_content()
       {
            if(!empty($this->cats))
            {
                ?>
                    <label>
                      <span class="customize-category-select-control"><?php echo esc_html( $this->label ); ?></span>
                      <select <?php $this->link(); ?>>
                           <?php
                                foreach ( $this->cats as $cat )
                                {
                                    printf('<option value="%s" %s>%s</option>', esc_attr($cat->name), selected($this->value(), esc_attr($cat->name), false), esc_html( $cat->name) );
                                }
                           ?>
                      </select>
                    </label>
                <?php
            }
       }
 }
endif;

	
if ( ! function_exists( 'bizindustries_validate_five_stars' ) ) :
	/**
	 * Validation functions
	 * Check if the input value is valid integer.
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return string Whether the value is valid to the current preview.
	 */
	function bizindustries_validate_five_stars( $validity, $value ){
		$value = intval( $value );
		if ( empty( $value ) || ! is_numeric( $value ) ) {
			$validity->add( 'required', esc_html__( 'You must supply a valid number.', 'bizindustries' ) );
		} elseif ( $value < 1 ) {
			$validity->add( 'min_slider', esc_html__( 'Minimum rating is 1', 'bizindustries' ) );
		} elseif ( $value > 5 ) {
			$validity->add( 'max_slider', esc_html__( 'Maximum rating is 5. ', 'bizindustries' ) );
		}
		return $validity;
	}
endif;

	





