<?php
	
	
/**
 * Contact Page Settings
 * ----------------------------------------------------------------------
 */
 
	$wp_customize->add_panel( 'bizindustries_contact_settings',
		array(
			'priority'       => 40,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => esc_html__( 'Contact Page Settings', 'bizindustries' ),
			'description'    => '',
		)
	);
	
	$wp_customize->add_section( 'contact_details_settings',
		array(
			'title'       => esc_html__( 'Contact Details', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_contact_settings',
		)
	);

	// Address Title
	$wp_customize->add_setting(
		'address_title',
		array(
			'default'           => __( 'Address', 'bizindustries' ),
			'sanitize_callback' => 'sanitize_text_field',
			//'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control(
		'address_title',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Address Title', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	
	// Address
	$wp_customize->add_setting(
		'contact_address',
		array(
			'default'           => __( '655 Montgomery Street, 7th Floor, San Francisco, United State 94111', 'bizindustries' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'contact_address',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Address', 'bizindustries' ),
			'description'		=> __( 'Use symbole | to make a new line', 'bizindustries' ), 
			'type'              => 'text',
		)
	);
	
    // Phone title  
	$wp_customize->add_setting(
		'phone_title',
		array(
			'default'           => __( 'Phone', 'bizindustries' ),
			'sanitize_callback' => 'sanitize_text_field',
			//'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control(
		'phone_title',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Phone title', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	
	// Phone inquery label
	$wp_customize->add_setting(
		'phone_1_label',
		array(
			'default'           => __('For information:', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'phone_1_label',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Phone 1 text', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	// Phone inquery
	$wp_customize->add_setting(
		'phone_1',
		array(
			'default'           => __('+0123-456-789', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'phone_1',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Phone 1 Number', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	// Phone 2 label
	$wp_customize->add_setting(
		'phone_2_label',
		array(
			'default'           => __('For Support:', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'phone_2_label',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Phone 2 text', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	// Phone support
	$wp_customize->add_setting(
		'phone_2',
		array(
			'default'           => __('+0123-456-789', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'phone_2',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Phone 2 number', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	
	// Mail Title
	$wp_customize->add_setting(
		'mail_title',
		array(
			'default'           => __('Email', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
			//'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control(
		'mail_title',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Mail Title', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	// Mail 1 text
	$wp_customize->add_setting(
		'email_1_label',
		array(
			'default'           => __('For information:', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'email_1_label',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Email 1 text', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	// Mail 1 Address
	$wp_customize->add_setting( 'email_1',
		array(
			'default'           => 'info@Bizindustries.com',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control( 'email_1',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Email 1 Address', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	// Mail 2 text
	$wp_customize->add_setting( 'email_2_label',
		array(
			'default'           => __('For Support:', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control( 'email_2_label',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Email 2 text', 'bizindustries' ),
			'type'              => 'text',
		)
	);
	// Mail 2 Address
	$wp_customize->add_setting( 'email_2',
		array(
			'default'           => 'warranty@Bizindustries.com',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control( 'email_2',
		array(
			'section'           => 'contact_details_settings',
			'label'             => __( 'Email 2 Address', 'bizindustries' ),
			'type'              => 'text',
		)
	);


	// Form Settings
	$wp_customize->add_section( 'contact_form_settings',
		array(
			'title'       => esc_html__( 'Contact Form', 'bizindustries' ),
			'panel'       => 'bizindustries_contact_settings',
		)
	);

	$wp_customize->add_setting(
		'contact_form_title',
		array(
			'default'           => __('Get in Touch', 'bizindustries'),
			'sanitize_callback' => 'sanitize_text_field',
			//'transport'			=> 'postMessage'
		)
	);
	$wp_customize->add_control(
		'contact_form_title',
		array(
			'section'           => 'contact_form_settings',
			'label'             => __( 'Form Title', 'bizindustries' ),
			'type'              => 'text',
		)
	);

	// Form shortcode
	$wp_customize->add_setting(
		'contact_form_shortcode',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'contact_form_shortcode',
		array(
			'section'           => 'contact_form_settings',
			'label'             => __( 'Contact Form 7 Shortcode', 'bizindustries' ),
            'description'       => __( 'Please generate the shortcode from contact form 7 widget', 'bizindustries' ),
			'type'              => 'text',
		)
	);

	// Map Settings
	$wp_customize->add_section( 'contact_map_settings',
		array(
			'title'       => esc_html__( 'Contact Map', 'bizindustries' ),
			'description' => '',
			'panel'       => 'bizindustries_contact_settings',
		)
	);
    $wp_customize->add_setting(
        'contact_google_map_iframe',
        array(
            'default'           => '',
            'sanitize_callback' => 'bizindustries_sanitize_map_iframe',
        )
    );
    
    $wp_customize->add_control(
        'contact_google_map_iframe',
        array(
            'section'         => 'contact_map_settings',
            'label'           => __( 'Embeded Google Map', 'bizindustries' ),
            'type'            => 'text',
        )
    );
