/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

// Footer Widget Layout
jQuery(document).ready(function ($) {
	
    var display_footer_layout = function (l) {
        $('li[id^="customize-control-footer_custom_"]').hide();
        $('li[id^="customize-control-footer_custom_' + l + '_columns"]').show();
    };

    display_footer_layout($('#customize-control-footer_layout select').val());
    $('#customize-control-footer_layout select').on('change', function () {
        display_footer_layout($(this).val());
    });
	
    //Scroll to front page section
    $('body').on('click', '#sub-accordion-panel-bizindustries_frontpage_settings .control-subsection .accordion-section-title', function(event) {
        var section_id = $(this).parent('.control-subsection').attr('id');
        scrollToSection( section_id );
    }); 
	
});
	


function scrollToSection( section_id ){
    var preview_section_id = "hero-slider";

    var $contents = jQuery('#customize-preview iframe').contents();

    switch ( section_id ) {
        
        case 'accordion-section-services_section_settings':
        preview_section_id = "services-section";
        break;
        
        case 'accordion-section-product_section_settings':
        preview_section_id = "products-section";
        break;

        case 'accordion-section-slogan_section_settings':
        preview_section_id = "slogan-section";
        break;
        
        case 'accordion-section-reasons_section_settings':
        preview_section_id = "reasons-section";
        break;

        case 'accordion-section-reviews_section_settings':
        preview_section_id = "review-section";
        break;
		
        case 'accordion-section-cta_section_settings':
        preview_section_id = "cta-section";
        break;
		
        case 'accordion-section-recent_news_settings':
        preview_section_id = "recent-news";
        break;
		
        case 'accordion-section-team_section_settings':
        preview_section_id = "team-section";
        break;
		
        case 'accordion-section-brands_section_settings':
        preview_section_id = "brands-section";
        break;
		
        case 'accordion-section-contact_section_settings':
        preview_section_id = "contact-section";
        break;
		
    }

    if( $contents.find('#'+preview_section_id).length > 0 && $contents.find('.home').length > 0 ){
        $contents.find("html, body").animate({
			scrollTop: $contents.find( "#" + preview_section_id ).offset().top
        }, 1000);
    }
}