/**
 * customizer.js
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ , api ) {

	// Site title 
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );

	//Site Description.
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	//Services Section
    wp.customize('services_section_heading', function (value) {
        value.bind(function (newvalue) {
            $(".intro-content  h3").text(newvalue);
        });
    });

	//Product Title
    wp.customize('products_title', function (value) {
        value.bind(function (newvalue) {
            $(".prodcuts-heaings h2").text(newvalue);
        });
    });
    wp.customize('products_subtitle', function (value) {
        value.bind(function (newvalue) {
            $(".prodcuts-heaings p.sub-title").text(newvalue);
        });
    });
    wp.customize('products_description', function (value) {
        value.bind(function (newvalue) {
            $(".prodcuts-heaings .p-desc").text(newvalue);
        });
    });

	//Slogan Title
    wp.customize('slogan_title', function (value) {
        value.bind(function (newvalue) {
            $(".slogan-area #slogan-title").text(newvalue);
        });
    });
    wp.customize('slogan_subtitle', function (value) {
        value.bind(function (newvalue) {
            $(".slogan-area #slogan-subtitle").text(newvalue);
        });
    });

	//Review Section
    wp.customize('reviews_heading', function (value) {
        value.bind(function (newvalue) {
            $(".testimonials-area .section-heading  h2").text(newvalue);
        });
    });
    wp.customize('reviews_subheading', function (value) {
        value.bind(function (newvalue) {
            $(".testimonials-area .section-heading  .sub-title").text(newvalue);
        });
    });
    wp.customize('reviews_description', function (value) {
        value.bind(function (newvalue) {
            $(".testimonials-area .section-heading  .desc").text(newvalue);
        });
    });
	
	//CTA Section
    wp.customize('cta_title', function (value) {
        value.bind(function (newvalue) {
            $(".cta-wrap  h4").text(newvalue);
        });
    });
    wp.customize('cta_description', function (value) {
        value.bind(function (newvalue) {
            $(".cta-wrap  p").text(newvalue);
        });
    });
    wp.customize('cta_btn_text', function (value) {
        value.bind(function (newvalue) {
            $(".cta-area .btn-wrap a.btn").text(newvalue);
        });
    });

	// Brands Logo
    wp.customize('brands_section_heading', function (value) {
        value.bind(function (newvalue) {
            $("#brands-section .section-heading h2").text(newvalue);
        });
    });
    wp.customize('brands_section_subheading', function (value) {
        value.bind(function (newvalue) {
            $("#brands-section .section-heading .sub-title").text(newvalue);
        });
    });

	//Recent Posts Section
    wp.customize('recent_posts_heading', function (value) {
        value.bind(function (newvalue) {
            $("#recent-news .section-heading h2").text(newvalue);
        });
    });
    wp.customize('recent_posts_subheading', function (value) {
        value.bind(function (newvalue) {
            $("#recent-news .section-heading .sub-title").text(newvalue);
        });
    });
    wp.customize('recent_posts_desc', function (value) {
        value.bind(function (newvalue) {
            $("#recent-news .section-heading .desc").text(newvalue);
        });
    });

	//Copyright Text
    wp.customize('footer_copyright_text', function (value) {
        value.bind(function (newvalue) {
            $("#copyright-text").text(newvalue);
        });
    });

    function update_css( ){
         var css_code = $( '#bizindustries-style-inline-css' ).html();
        // Fix Chrome Lost CSS When resize ??
        $( '#bizindustries-style-inline-css' ).replaceWith( '<style class="replaced-style" id="bizindustries-style-inline-css">'+css_code+'</style>' );

    }

    // When preview ready
    wp.customize.bind( 'preview-ready', function() {
        update_css();
    });

    $( window ).resize( function(){
        update_css();
    });

} )( jQuery , wp.customize );

