<?php

/**
 * Add custom css to header
 */
if ( ! function_exists( 'bizindustries_custom_inline_style' ) ) {
	function bizindustries_custom_inline_style( ) {

        ob_start();


		/**
		 * Site Colors
		 */
		 
		 //Primary Colors
		$primary_color = sanitize_hex_color_no_hash( get_theme_mod( 'site_primary_color' ) );
		if ( $primary_color != '' ) {
			?>
			a:hover, a:focus, a:active, code,.bizin-nav ul.menu > li > a:hover, .bizin-nav ul.menu > li a.focus,.entry-header h4 a:hover, entry-header h4 a:focus, .entry-meta a:hover,.entry-meta a:focus,.bizin-nav .menu > li > ul li a:hover,.bizin-nav .menu > li > ul li a:focus,.widget a:hover,.widget-area .widget > ul li:hover::before,.secondary-nav ul li a:hover,.secondary-nav ul li a:focus, .post-navigation a:hover,.post-navigation a:focus,.comment-author .fn, .comment-author .url, .comment-reply-link, .comment-reply-login,.comment-meta a:hover,.comment-meta a:focus,.sticky .entry-header h4::before,.section-heading .sub-title,.contact-heading h4,.icon-holder,.count-down i,.slide-content h4, .page-banner h3,.intro-content h3 span,.more-btn:hover,.more-btn:focus,.woocommerce ul.products li.product .price, .woocommerce div.product p.price, .woocommerce div.product span.price,.woocommerce-info::before,.bizin-nav ul.menu li.current_page_item > a
			{
				color: #<?php echo esc_attr( $primary_color ); ?>;
			}

			.widget-search .search-form button, .blog-search-form .search-form button,.entry-header-wrap .entry-date,.page-numbers .current,.widget-area .widget-title span,.widget-area h4.widget-title::before,.widget-search .search-form button,.back-to-top,.search-icon:hover::after,.page-numbers a:hover,.search-icon.open span::before, .search-icon.open span::after,.top-header .social-icons a:hover,.widget .tagcloud a:hover,.content-area ul li::before, input[type="button"], input[type="reset"], input[type="submit"],.screen-reader-text:focus,button[type="submit"],#cancel-comment-reply-link,.image-box:hover .img-des h5,.img-des a,.section-heading h2::after,.icon-holder.icon-bg,.carousel-ctls .owl-nav span::before,.carousel-ctls .owl-dot span,.carousel-ctls .owl-dot.active span,.more-btn::before,.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce a.added_to_cart,.woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current,.entry-content a:hover:before,.search-modal .search-submit:focus
			{
				background-color: #<?php echo esc_attr( $primary_color ); ?>;
			}
			
			blockquote,.search-icon:hover::before,.carousel-ctls .owl-dot span::before,.woocommerce-info,.icon-holder.icon-bg::before
			{
				border-color : #<?php echo esc_attr( $primary_color ); ?> !important;
			}
			<?php
		} // End $primary_color

		//Secondary Colors
		$secondary_color = sanitize_hex_color_no_hash( get_theme_mod( 'site_secondary_color' ) );
		if ( $secondary_color != '' ) {
			?>
			.post-navigation a,.widget-post .post-content a.title,.contact-widget a:hover
			{
				color: #<?php echo esc_attr( $secondary_color ); ?>;
			}
			
			.page-numbers a,.comment-form .form-submit .submit:hover,.widget .tagcloud a,.back-to-top:hover,button[type="submit"]:hover,button[type="submit"]:focus,.woocommerce ul.products li.product .onsale, .woocommerce span.onsale,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce a.added_to_cart:hover,button:hover, button:focus, input[type="button"]:hover, input[type="button"]:focus, input[type="reset"]:hover, input[type="reset"]:focus, input[type="submit"]:hover, input[type="submit"]:focus
			{
				background-color: #<?php echo esc_attr( $secondary_color ); ?>;
			}
			
			.site-main .post-navigation
			{
				border-color : #<?php echo esc_attr( $secondary_color ); ?>;
			}
			<?php
		} // End $secondary_color

		/**
		 * Typography
		 */
if(class_exists('Bootitems_Core') && bc_fs()->can_use_premium_code() ){
		// Heading Fonts
		$heading_font_family = get_theme_mod('heading_font_family');
		if ( $heading_font_family ) {
			?>
				h1, h2, h3, h4, h5, h6{
					font-family:<?php echo esc_attr( $heading_font_family ); ?>;
				}
			<?php
		} // END $heading_font_family
		
		// Body Font Family
		$body_font_family = get_theme_mod('body_font_family');
		if ( $body_font_family ) {
			?>
			body{
				font-family: <?php echo esc_attr( $body_font_family ); ?>;
			}
			<?php
		} // END $body_font_family

		$body_font_size = get_theme_mod('body_font_size');
		if ( $body_font_size ) {
			?>
			body{
				font-size: <?php echo esc_attr( $body_font_size ); ?>px;
			}
			<?php
		} // END $body_font_size
		
		// Button Font Family
		$btn_font_family = get_theme_mod('btn_font_family');
		if ( $btn_font_family ) {
			?>
			button,.btn, a.btn-more,.entry-content .read-more {
				font-family: <?php echo esc_attr( $btn_font_family ); ?>;
			}
			<?php
		} // END $btn_font_family
}
		/**
		 * Color Settings
		 */
if(bizindustries_set_to_premium()) {
		// Heading Color
		$heading_color = get_theme_mod('site_heading_color');
		if ($heading_color) {
			?>
				h1, h2, h3, h4, h5, h6, .entry-header h4 a,.entry-header h4 a:focus{
					color:<?php echo esc_attr( $heading_color ); ?>;
				}
			<?php
		} // END $site_heading_color

		// Body Text Color
		$body_text_color = get_theme_mod('body_text_color');
		if ( $body_text_color ) {
			?>
			body,.widget-area ul li a,.widget-area .widget > ul li::before,.entry-meta a,pre,.comment-meta, .comment-meta a {
				color: <?php echo esc_attr( $body_text_color ); ?>;
			}
			<?php
		} // END $body_text_color

		// Button BG Color
		$btn_bg_color = sanitize_hex_color_no_hash( get_theme_mod( 'site_btn_bg_color' ) );
		if ( $btn_bg_color != '' ) { ?>
			.entry-content .read-more,button, input[type="button"], input[type="reset"], input[type="submit"],.btn-bizin {
				background-color: #<?php echo esc_attr( $btn_bg_color ); ?>;
			}
			<?php
		} // End $btn_bg_color

		// Button Hover BG Color
		$btn_bg_hcolor = sanitize_hex_color_no_hash( get_theme_mod( 'site_btn_bg_hcolor' ) );
		if ( $btn_bg_hcolor != '' ) {
			?>
			.entry-content .read-more:hover,.entry-content .read-more:focus,.entry-content .read-more:focus,button:hover,button:focus,button[type="submit"]:focus, input[type="button"]:hover, input[type="button"]:focus,input[type="reset"]:hover,input[type="reset"]:focus, input[type="submit"]:hover,input[type="submit"]:focus,.btn-bizin:hover,btn-bizin:focus
			{
				background-color: #<?php echo esc_attr( $btn_bg_hcolor ); ?>;
			}
			<?php
		} // End $btn_bg_hcolor

		// Button Text Color
		$btn_text_color = get_theme_mod('site_btn_text_color');
		if ( $btn_text_color ) {
			?>
			.entry-content .read-more {
				color: <?php echo esc_attr( $btn_text_color ); ?>;
			}
			<?php
		} // END $btn_text_color
		
		// Button Text Color
		$btn_text_hcolor = get_theme_mod('site_btn_hover_text_color');
		if ( $btn_text_hcolor ) {
			?>
			.entry-content .read-more:hover {
				color: <?php echo esc_attr( $btn_text_hcolor ); ?>;
			}
			<?php
		} // END $btn_text_hcolor
}
		/**
		 * Header Settings
		 */
		$header_top_bg = sanitize_hex_color_no_hash( get_theme_mod( 'header_top_bg_color' ) );
		if ( $header_top_bg != '' ) {
			?>
			.top-header.style-2::after, .top-header.style-2 .top-header-inner,.top-header
			{
				background-color: #<?php echo esc_attr( $header_top_bg ); ?>;
			}
			.site-header .top-header.style-2 .top-header-inner::before {
				border-top: 52px solid #<?php echo esc_attr( $header_top_bg ); ?> !important;
			}
			<?php
		} // End $header_top_bg


		/**
		 * Navigation Settings
		 */
		 // Navigation Backgrond
		$nav_bg = sanitize_hex_color_no_hash( get_theme_mod( 'navigation_bg' ) );
		if ( $nav_bg ) {
			?>
			.main-header, .fixed-header,.top-header.style-2{
				background-color: #<?php echo esc_attr( $nav_bg ); ?>;
			}
			<?php
		} // END $nav_bg

		if(bizindustries_set_to_premium()) {
			// Menu Fonts
			$menu_font = get_theme_mod('menu_font_family');
			if ( $menu_font ) {
				?>
				nav.bizin-nav ul.menu li a{
					font-family: <?php echo esc_attr( $menu_font ); ?>;
				}
				<?php
			} //END $menu_font
		}
		// Menu color
		$menu_color = sanitize_hex_color_no_hash( get_theme_mod( 'menu_link_color') );
		if ( $menu_color ) {
			?>
			nav.bizin-nav ul.menu > li > a{
				color: #<?php echo esc_attr( $menu_color ); ?>;
			}
			<?php
		} // END $menu_color
		
		//Menu hover color
		$menu_hover_color = sanitize_hex_color_no_hash( get_theme_mod( 'menu_hover_link_color' ) );
		if ( $menu_hover_color ) {
			?>
			.bizin-nav ul.menu > li > a:hover, .bizin-nav ul.menu > li a.current_page_item{
				color: #<?php echo esc_attr( $menu_hover_color ); ?>;
			}
			<?php
		} // END $menu_hover_color


		/**
		 * Submenu Background
		 */
		$dropdown_bg = sanitize_hex_color_no_hash( get_theme_mod( 'submenu_bg_color' ) );
		if ( $dropdown_bg ) {
			?>
			.bizin-nav .menu > li ul{
				background-color: #<?php echo esc_attr( $dropdown_bg ); ?>;
			}
			<?php
		} // END $dropdown_bg

		// Submenu text color
		$submenu_text_color = sanitize_hex_color_no_hash( get_theme_mod( 'submenu_text_color') );
		if ( $submenu_text_color ) {
			?>
			.bizin-nav .menu > li > ul li a{
				color: #<?php echo esc_attr( $submenu_text_color ); ?>;
			}
			<?php
		} // END $submenu_text_color
		
		//Submenu hover color
		$submenu_htext_color = sanitize_hex_color_no_hash( get_theme_mod( 'submenu_hover_text_color' ) );
		if ( $submenu_htext_color ) {
			?>
			.bizin-nav .menu > li > ul li a:hover{
				color: #<?php echo esc_attr( $submenu_htext_color ); ?>;
			}
			<?php
		} // END $submenu_htext_color


		// Service Section
		$service_section_bg = sanitize_hex_color_no_hash( get_theme_mod( 'service_section_bg' ) );
		if ( $service_section_bg != '' ) {
			?>
			#services-section {
				background-color: #<?php echo esc_attr($service_section_bg); ?> !important;
			}
			<?php
		} // End $service_section_bg

		 // Slogan Background color
		$slgn_bg_color = bizindustries_sanitize_color_alpha( get_theme_mod( 'slogan_overlay_bg_color' ) );
		if ( $slgn_bg_color ) { 
			?>
				.slogan-area.overlay-bg:before {
					background-color: <?php echo esc_attr( $slgn_bg_color ); ?>;
				}
			<?php
		} //END $slgn_bg_color

		 // CTA
		$cta_bg_color = sanitize_hex_color_no_hash( get_theme_mod( 'cta_bg_color' ) );
		if ( $cta_bg_color != '' ) {
			?>
			#cta-section{
				background-color: #<?php echo esc_attr($cta_bg_color); ?> !important;
			}
			<?php
		} // End $cta_bg_color

		 // Products Section
		$products_section_bg = sanitize_hex_color_no_hash( get_theme_mod( 'products_section_bg' ) );
		if ( $products_section_bg != '' ) {
			?>
			#products-section {
				background-color: #<?php echo esc_attr($products_section_bg); ?> !important;
			}
			<?php
		} // End $products_section_bg

		 // Reasons Section
		$reasons_section_bg = sanitize_hex_color_no_hash( get_theme_mod( 'reasons_section_bg' ) );
		if ( $reasons_section_bg != '' ) {
			?>
			#reasons-section {
				background-color: #<?php echo esc_attr($reasons_section_bg); ?> !important;
			}
			<?php
		} // End $reasons_section_bg

		 // Reviews Section
		$reviews_section_bg = sanitize_hex_color_no_hash( get_theme_mod( 'reviews_section_bg' ) );
		if ( $reviews_section_bg != '' ) {
			?>
			#review-section {
				background-color: #<?php echo esc_attr($reviews_section_bg); ?> !important;
			}
			<?php
		} // End $reviews_section_bg

		 // Team Section
		$team_section_bg = sanitize_hex_color_no_hash( get_theme_mod( 'team_section_bg' ) );
		if ( $team_section_bg != '' ) {
			?>
			#team-section {
				background-color: #<?php echo esc_attr($team_section_bg); ?> !important;
			}
			<?php
		} // End $team_section_bg
		
		 // Brand Logos Background color
		$brands_section_bg = sanitize_hex_color_no_hash( get_theme_mod( 'brands_section_bg' ) );
		if ( $brands_section_bg != '' ) {
			?>
			#brands-section {
				background-color: #<?php echo esc_attr($brands_section_bg); ?>;
			}
			<?php
		} // End $brands_section_bg
		
		 // Concact Section Background color
		$contact_section_bg = sanitize_hex_color_no_hash( get_theme_mod( 'contact_section_bg' ) );
		if ( $contact_section_bg != '' ) {
			?>
			#contact-section {
				background-color: #<?php echo esc_attr($contact_section_bg); ?>;
			}
			<?php
		} // End $contact_section_bg


		
		 // Recent Posts Background color
		$recent_news_bg = sanitize_hex_color_no_hash( get_theme_mod( 'recent_news_bg' ) );
		if ( $recent_news_bg != '' ) {
			?>
			#recent-news {
				background-color: #<?php echo esc_attr($recent_news_bg); ?>;
			}
			<?php
		} // End $recent_news_bg


		 // Preloader Background color
		$preloader_bg_color = sanitize_hex_color_no_hash( get_theme_mod( 'preloader_bg_color' ) );
		if ( $preloader_bg_color != '' ) {
			?>
			.preloader-wrap {
				background-color: #<?php echo esc_attr($preloader_bg_color); ?>;
			}
			<?php
		} // End $preloader_bg_color

		/**
		 * Footer Settings
		 */
		 // Footer Background color
		$widgets_bg_color = sanitize_hex_color_no_hash( get_theme_mod( 'footer_widgets_bg_color' ) );
		if ( $widgets_bg_color != '' ) {
			?>
			.footer-area {
			background-color: #<?php echo esc_attr($widgets_bg_color); ?>;
			}
			<?php
		} // End $widgets_bg_color


		//Footer Title Color
		$widgets_title_color = sanitize_hex_color_no_hash( get_theme_mod( 'footer_widgets_title_color' ) );
		if ( $widgets_title_color != '' ) {
			?>
			.footer-widget h4  {
				color: #<?php echo esc_attr($widgets_title_color); ?>;
			}
			<?php
		} // End $widgets_title_color


		//Footer Text Color
		$widgets_text_color = sanitize_hex_color_no_hash( get_theme_mod( 'footer_widgets_text_color' ) );
		if ( $widgets_text_color != '' ) {
			?>
			.footer-widgets, .footer-widgets p {
				color: #<?php echo esc_attr($widgets_text_color); ?>;
			}
			<?php
		} // End $widgets_text_color

		//Footer Link Color
		$widgets_link_color = sanitize_hex_color_no_hash( get_theme_mod( 'footer_widgets_link_color' ) );
		if ( $widgets_link_color != '' ) {
			?>
			.footer-widgets a,.footer-widget.widget .tagcloud a {
				color: #<?php echo esc_attr($widgets_link_color); ?>;
			}
			<?php
		} // End $widgets_link_color
		
		//Footer Link Hover Color
		$widgets_link_hcolor = sanitize_hex_color_no_hash( get_theme_mod( 'footer_widgets_link_hcolor' ) );
		if ( $widgets_link_hcolor != '' ) {
			?>
			.footer-widgets a:hover,.footer-widget ul li a:hover {
				color: #<?php echo esc_attr($widgets_link_hcolor); ?>;
			}
			<?php
		} // End $widgets_link_hcolor


		 // Copytight Background color
		$copyright_bg_color = sanitize_hex_color_no_hash( get_theme_mod( 'footer_copyright_bg_color' ) );
		if ( $copyright_bg_color != '' ) {
			?>
			.footer-bottom {
				background-color: #<?php echo esc_attr($copyright_bg_color); ?>;
			}
			<?php
		} // End $copyright_bg_color


		// Copyright Text Color
		$copyright_text_color = sanitize_hex_color_no_hash( get_theme_mod( 'footer_copyright_text_color' ) );
		if ( $copyright_text_color != '' ) {
			?>
			.footer-bottom p {
				color: #<?php echo esc_attr($copyright_text_color); ?>;
			}
			<?php
		} // End $copyright_text_color






		/**
		 * Site Branding
		*/
		// Site title font
		$site_title_font_family = get_theme_mod('site_title_font_family');
		if ( $site_title_font_family ) {
			?>
			.site-branding .site-title{
				font-family: <?php echo esc_attr( $site_title_font_family ); ?>;
			}
			<?php
		} //END $site_title_font_family
		
		// Site Title Color
		$site_title_color = sanitize_hex_color_no_hash( get_theme_mod( 'site_title_color' ) );
		if ( $site_title_color ) {
			?>
			.site-branding .site-title a{
				color: #<?php echo esc_attr( $site_title_color ); ?>;
			}
			<?php
		} //END $site_title_color
		
		// Font Size
		$site_title_font_size =  get_theme_mod( 'site_title_font_size');
		if ( $site_title_font_size ) {
			?>
			.site-branding .site-title{
				font-size: <?php echo esc_attr( $site_title_font_size ); ?>px;
			}
			<?php
		} //END $site_title_font_size


		// Site Tagline
		$site_tagline_font_family = get_theme_mod('tagline_font_family');
		$site_tagline_font_size =  get_theme_mod( 'tagline_font_size');
		$tagline_color = sanitize_hex_color_no_hash( get_theme_mod( 'tagline_text_color' ) );
		
		if ( $site_tagline_font_family || $site_tagline_font_size || $tagline_color ) {
			?>
			.site-branding .site-description{
				font-family: <?php echo esc_attr( $site_tagline_font_family ); ?>;
				font-size: <?php echo esc_attr( $site_tagline_font_size ); ?>px;
				color: #<?php echo esc_attr( $tagline_color ); ?>;
			<?php
		} //END $site_tagline_font_family



        $css = ob_get_clean();

        if ( trim( $css ) == "" ) {
            return ;
        }
		$css = apply_filters( 'bizindustries_custom_css', $css ) ;
        if ( ! is_customize_preview() ) {
	        $css = preg_replace(
		        array(
			        // Remove comment(s)
			        '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')|\/\*(?!\!)(?>.*?\*\/)|^\s*|\s*$#s',
			        // Remove unused white-space(s)
			        '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/))|\s*+;\s*+(})\s*+|\s*+([*$~^|]?+=|[{};,>~+]|\s*+-(?![0-9\.])|!important\b)\s*+|([[(:])\s++|\s++([])])|\s++(:)\s*+(?!(?>[^{}"\']++|"(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')*+{)|^\s++|\s++\z|(\s)\s+#si',
		        ),
		        array(
			        '$1',
			        '$1$2$3$4$5$6$7',
		        ),
		        $css
	        );
        }
        if ( ! function_exists( 'wp_get_custom_css' ) ) {  // Back-compat for WordPress < 4.7.
            $custom = get_option('bizindustries_custom_css');
            if ($custom) {
                $css .= "\n/* --- Begin custom CSS --- */\n" . $custom . "\n/* --- End custom CSS --- */\n";
            }
        }
       return $css ;
	}

}