<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bizindustries
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		
	<?php if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	} ?>
    <!-- wrapper start -->
    <div class="wrapper">

		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'bizindustries' ); ?></a>

		<!-- Start Header -->
		<header class="site-header <?php if( get_theme_mod( 'site_sticky_header' ) ) : ?>sticky-header<?php endif; ?>">
			
			<?php if(get_theme_mod('header_top_display') == true) : ?>
			<!-- Start Header Top -->
			<div class="top-header <?php echo esc_attr( get_theme_mod('header_style', 'style-2') ); ?>"> 
				<div class="<?php echo esc_attr( get_theme_mod('header_container_width', 'container') ); ?>">
					<div class="row">
						<div class="col-md-12"> 
							<div class="top-header-inner">

								<?php if( get_theme_mod('header_secondary_nav_display', false)) : ?>
									<?php bizindustries_secondary_nav(); ?>
								<?php endif; ?>

								<?php
									$display_phone = get_theme_mod('header_display_phone', true);
									$display_email = get_theme_mod('header_display_email', true);
									$phone = get_theme_mod('header_phone', '123-456-7890');
									$email = get_theme_mod('header_email', 'help@bizindustries.com');
									
								if( $display_phone|| $display_email ) : ?>
								<div class="top-info d-none d-sm-block">

									<?php
									if($display_phone && !empty($phone) ) : ?>
									<span class="phone"><i class="fa fa-phone"></i> <?php echo esc_html($phone); ?></span>
									<?php endif; ?>
									
									<?php if( $display_email && !empty($email) ) : ?>
									<span class="email"><i class="fa fa-envelope"></i> <?php echo esc_html($email); ?></span>
									<?php endif; ?>

								</div>
								<?php endif; ?>
								
								<!-- Start Social Links -->
								<?php if( get_theme_mod('header_social_icon_display', false)) : ?>
									<?php bizindustries_social_links( true ); ?>
								<?php endif; ?>
								<!-- End Social Links -->
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endif; ?>
			<!-- End Header Top -->

			<!-- Start Main Header -->
			<div class="main-header"> 
				<div class="<?php echo esc_attr( get_theme_mod('header_container_width', 'container') ); ?>">
					<div class="row">

						<div class="col-md-12 d-flex align-items-center <?php if( get_theme_mod('header_search_icon_display', true)) : ?>has-search-icon<?php endif; ?>">
							
							<!-- Site Logo -->
							<div class="site-branding mr-auto">
								<?php bizindustries_site_logo(); ?>
							</div>
							<!-- End Site Logo -->

							<!-- Start Main Menu -->
							<div class="main-menu-wrap float-right">
								<?php bizindustries_site_nagivation(); ?>
							</div>
							<!-- End Main Menu -->

							<?php if( class_exists( 'WooCommerce' ) && get_theme_mod('header_cart_icon_display', true) ) : ?>
							   <div class="header-cart float-right">
								<?php
									bizindustries_woo_header_cart(); 
								?>
								</div>
							<?php endif; ?>

							<?php if( get_theme_mod('header_search_icon_display', true)) : ?>
							<button class="search-icon"><span></span></button>
							<?php endif; ?>

							<!-- Mobile Menu Active here. Don't Remove it -->
							<div class="mobile-menu-area"></div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Main Header -->
			
			<!-- Start Search Box -->
			<?php if( get_theme_mod('header_search_icon_display', true)) : ?>
			<div class="search-modal">
				<div class="search-modal-inner">
					<div class="search-box">
						<?php get_search_form(); ?>
						<button class="search-cross">
							<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
							<polygon fill="#1A1A1B" fill-rule="evenodd" points="6.852 7.649 .399 1.195 1.445 .149 7.899 6.602 14.352 .149 15.399 1.195 8.945 7.649 15.399 14.102 14.352 15.149 7.899 8.695 1.445 15.149 .399 14.102"/>
							</svg>
						</button>
					</div>
				</div>
			</div>
			<?php endif; ?>
			<!-- End Search Box -->
		</header>
		<!-- End Header -->