<?php
/**
 * Bizindustries functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Bizindustries
 */
if ( ! defined('ABSPATH') ) {
	exit;
}

if ( ! function_exists( 'bizindustries_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function bizindustries_setup() {
		/*
			* Make theme available for translation.
			* Translations can be filed in the /languages/ directory.
			* If you're building a theme based on Bizindustries, use a find and replace
			* to change 'bizindustries' to the name of your theme in all the template files.
			*/
		load_theme_textdomain( 'bizindustries', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
			* Let WordPress manage the document title.
			* By adding theme support, we declare that this theme does not use a
			* hard-coded <title> tag in the document head, and expect WordPress to
			* provide it for us.
			*/
		add_theme_support( 'title-tag' );

		/*
			* Enable support for Post Thumbnails on posts and pages.
			*
			* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
			
		add_theme_support( 'post-thumbnails' );
		/**
		 * Image size
		 */
		add_image_size( 'bizindustries-post-thumb', '370', '210', true );
		add_image_size( 'bizindustries-product', '370', '350', true );
		add_image_size( 'bizindustries-team', '370', '370', true );
		add_image_size( 'bizindustries-brand', '170', '92', true );
		add_image_size( 'bizindustries-widget-thumb', '90', '90', true );
		
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary-menu'   => esc_html__( 'Primary Menu', 'bizindustries' ),
				'secondary-menu' => esc_html__( 'Header Top Menu', 'bizindustries' ),
			)
		);

		/*
			* Switch default core markup for search form, comment form, and comments
			* to output valid HTML5.
			*/
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'bizindustries_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );
		
		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );
		
		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		// Add support for responsive embedded content.
		add_post_type_support( 'page', 'excerpt' );

		// Remove theme support for block editor
		remove_theme_support( 'widgets-block-editor' );
		
		// WooCommerce Support
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
		// Remove woocommerce breadcrumb
		remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );

		$single_related = get_theme_mod( 'product_single_related_enable', 1 );
		if ( !$single_related ) {
			remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
		}

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'width'       => 150,
				'height'      => 120,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'bizindustries_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function bizindustries_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'bizindustries_content_width', 825 );
}
add_action( 'after_setup_theme', 'bizindustries_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function bizindustries_widgets_init() {
	$bizindustries_animation = get_theme_mod( 'bizindustries_animation_disable', 0 ) ? 'animate-box':'';
	register_sidebar(
		array(
			'name'          => esc_html__( 'Blog Sidebar', 'bizindustries' ),
			'id'            => 'blog-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'bizindustries' ),
			'before_widget' => '<div id="%1$s" class="widget clearfix %2$s '.$bizindustries_animation.'">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title"><span>',
			'after_title'   => '</span></h4>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Page Sidebar', 'bizindustries' ),
			'id'            => 'page-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'bizindustries' ),
			'before_widget' => '<div id="%1$s" class="widget clearfix %2$s '.$bizindustries_animation.'">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title"><span>',
			'after_title'   => '</span></h4>',
		) 
	);
	if(class_exists( 'WooCommerce' )) {
		register_sidebar( 
			array(
				'name'          => esc_html__( 'Shop Page Sidebar', 'bizindustries' ),
				'id'            => 'woocommerce-sidebar',
				'description'   => esc_html__( 'Appears on shop page', 'bizindustries' ),
				'before_widget' => '<div id="%1$s" class="widget clearfix %2$s '.$bizindustries_animation.'">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4 class="widget-title"><span>',
				'after_title'   => '</span></h4>',
			)
		);
		register_sidebar(
			array(
				'name'          => __( 'Single Product Page Sidebar', 'bizindustries' ),
				'description'   => __( 'Appears on single product page', 'bizindustries' ),
				'id'            => 'woocommerce-single-sidebar',
				'before_widget' => '<div id="%1$s" class="widget clearfix %2$s '.$bizindustries_animation.'">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4 class="widget-title"><span>',
				'after_title'   => '</span></h4>',
			)
		);
	}
	register_sidebar(array(
		'name'          => esc_html__( 'Footer Widget 1', 'bizindustries' ),
		'id'            => 'footer-1',
		'description'   => esc_html__( 'Add widgets here.', 'bizindustries' ),
		'before_widget' => '<div id="%1$s" class="footer-widget widget clearfix %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	));

	register_sidebar(array(
		'name'          => esc_html__( 'Footer Widget 2', 'bizindustries' ),
		'id'            => 'footer-2',
		'description'   => esc_html__( 'Add widgets here.', 'bizindustries' ),
		'before_widget' => '<div id="%1$s" class="footer-widget widget clearfix %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	));

	register_sidebar(array(
		'name'          => esc_html__( 'Footer Widget 3', 'bizindustries' ),
		'id'            => 'footer-3',
		'description'   => esc_html__( 'Add widgets here.', 'bizindustries' ),
		'before_widget' => '<div id="%1$s" class="footer-widget widget clearfix %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	));

	register_sidebar(array(
		'name'          => esc_html__( 'Footer Widget 4', 'bizindustries' ),
		'id'            => 'footer-4',
		'description'   => esc_html__( 'Add widgets here.', 'bizindustries' ),
		'before_widget' => '<div id="%1$s" class="footer-widget widget clearfix %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	));
	
}
add_action( 'widgets_init', 'bizindustries_widgets_init' );


/**
 * Enqueue scripts and styles.
 */
function bizindustries_scripts() {
	
	$theme_version = wp_get_theme()->get( 'Version' );
	$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	// All CSS Here -->
	// Bootstrap fremwork main css -->		
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap' . $suffix . '.css' );
	
	// Animate CSS -->
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate' . $suffix . '.css' );
	
	// FontAwesome CSS -->
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome' . $suffix . '.css' );
	
	// Meanmenu CSS -->
	wp_enqueue_style( 'meanmenu', get_template_directory_uri() . '/assets/css/meanmenu' . $suffix . '.css' );
	
	// OWL CSS
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel' . $suffix . '.css' );
	
	// WooCommerce CSS
	if(class_exists('WooCommerce')) {
	wp_enqueue_style( 'bizindustries-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.css' );
	}
	// Main CSS
	wp_enqueue_style( 'bizindustries-style', get_template_directory_uri().'/style.css', array(), rand() );
    $custom_css = bizindustries_custom_inline_style();
    wp_add_inline_style( 'bizindustries-style', $custom_css );

	// Responsive CSS
	wp_enqueue_style( 'bizindustries-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );

	// WordPress Masonry
	wp_enqueue_script( 'jquery-masonry',array('jquery') );
	
	// Imagesloaded
	wp_enqueue_script( 'imagesloaded',array('jquery') );

	// Bootstrap js -->
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap' . $suffix . '.js', array('jquery'), '4.0.0', true );

	//modernizr JS
	wp_enqueue_script( 'jquery-modernizr', get_template_directory_uri() . '/assets/js/vendor/modernizr-2.8.3' . $suffix . '.js', null, '2.8.3', false ); 
	
	//Waypoints JS
	wp_enqueue_script( 'jquery-waypoints', get_template_directory_uri() . '/assets/js/vendor/jquery.waypoints' . $suffix . '.js', array('jquery'), '4.0.0', true );
	
	// OWL Carousel
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel' . $suffix . '.js', array('jquery'), '2.3.4', true );
	
	// Meanmenu
	wp_enqueue_script( 'meanmenu', get_template_directory_uri() . '/assets/js/jquery.meanmenu' . $suffix . '.js', array('jquery'), '2.0.8', true );
	
	// Stellar Script
	wp_enqueue_script( 'stellar-min', get_template_directory_uri() . '/assets/js/stellar' . $suffix . '.js', array('jquery'), '0.6.2', true );	
	
	// Counterup
	wp_enqueue_script( 'counterup', get_template_directory_uri() . '/assets/js/jquery.counterup' . $suffix . '.js', array('jquery'), '1.0.0', true );
	
	//Fastclick
	wp_enqueue_script( 'jquery-fastclick', get_template_directory_uri() . '/assets/js/jquery.fastclick' . $suffix . '.js', array(), '1.0.0', true );
	
	//Skip link focus fix
	wp_enqueue_script( 'bizindustries-skip-link-focus', get_template_directory_uri() . '/assets/js/skip-link-focus-fix' . $suffix . '.js', array(), '20151215', true );

	// Main Script
	wp_enqueue_script( 'bizindustries-main-jquery', get_template_directory_uri() . '/assets/js/main.js', array('jquery'),  esc_attr($theme_version), true );
	
	// Slider Settings
	$slider_autoplay = get_theme_mod( 'slider_autoplay', true );
	$slider_duration = get_theme_mod( 'slider_duration', 5000);
	$slider_loop     = get_theme_mod( 'slider_loop', true );
	$slider_nav      = get_theme_mod( 'slider_nav', true );
	$slider_dots     = get_theme_mod( 'slider_dots', true );
	
	// Brands Carousel Settings
	$brands_autoplay = get_theme_mod( 'brands_carousel_autoplay', true );
	$brands_duration  = get_theme_mod( 'brands_carousel_duration', 3000);
	$brands_loop     = get_theme_mod( 'brands_carousel_loop_enable', true );
	$brands_nav      = get_theme_mod( 'brands_carousel_nav_display', true );
	
	// Team Carousel Settings
	$team_autoplay = get_theme_mod( 'team_carousel_autoplay', true );
	$team_duration  = get_theme_mod( 'team_carousel_duration', 3000);
	$team_loop     = get_theme_mod( 'team_carousel_loop_enable', true );
	$team_nav      = get_theme_mod( 'team_carousel_nav_display', true );
	$team_dots     = get_theme_mod( 'team_carousel_dots_display', false );
	
	// Review Carousel Settings
	$reviews_autoplay = get_theme_mod( 'reviews_carousel_autoplay', true );
	$reviews_duration  = get_theme_mod( 'reviews_carousel_duration', 5000);
	$reviews_loop     = get_theme_mod( 'reviews_carousel_loop', true );
	$reviews_nav      = get_theme_mod( 'reviews_carousel_nav', true );
	$reviews_dots     = get_theme_mod( 'reviews_carousel_dots', false );
	
	// News Carousel Settings
	$news_autoplay = get_theme_mod( 'news_carousel_autoplay', true );
	$news_duration  = get_theme_mod( 'news_carousel_duration', 5000);
	$news_loop     = get_theme_mod( 'news_carousel_loop_enable', true );
	$news_nav      = get_theme_mod( 'news_carousel_nav_display', true );
	$news_dots     = get_theme_mod( 'news_carousel_dots_display', false );

    wp_localize_script(
	    'bizindustries-main-jquery', 
	    'get_js_option',
	    array(
			// Home slider
	        'slider_autoplay'  => filter_var($slider_autoplay, FILTER_VALIDATE_BOOLEAN ),
	        'slider_duration'  => absint($slider_duration),
	        'slider_loop'      => filter_var($slider_loop, FILTER_VALIDATE_BOOLEAN ),
	        'slider_nav'       => filter_var($slider_nav, FILTER_VALIDATE_BOOLEAN ),
	        'slider_dots'      => filter_var($slider_dots, FILTER_VALIDATE_BOOLEAN ),
			
			//Brands Logo
	        'brands_autoplay'  => filter_var($brands_autoplay, FILTER_VALIDATE_BOOLEAN ),
	        'brands_duration'  => absint($brands_duration),
	        'brands_loop'      => filter_var($brands_loop, FILTER_VALIDATE_BOOLEAN ),
	        'brands_nav'       => filter_var($brands_nav, FILTER_VALIDATE_BOOLEAN ),
			
			// Team Carousel
	        'team_autoplay'  => filter_var($team_autoplay, FILTER_VALIDATE_BOOLEAN ),
	        'team_duration'  => absint($team_duration),
	        'team_loop'      => filter_var($team_loop, FILTER_VALIDATE_BOOLEAN ),
	        'team_nav'       => filter_var($team_nav, FILTER_VALIDATE_BOOLEAN ),
	        'team_dots'      => filter_var($team_dots, FILTER_VALIDATE_BOOLEAN ),		
			
			// Reviews Carousel
	        'reviews_autoplay'  => filter_var($reviews_autoplay, FILTER_VALIDATE_BOOLEAN ),
	        'reviews_duration'  => absint($reviews_duration),
	        'reviews_loop'      => filter_var($reviews_loop, FILTER_VALIDATE_BOOLEAN ),
	        'reviews_nav'       => filter_var($reviews_nav, FILTER_VALIDATE_BOOLEAN ),
	        'reviews_dots'      => filter_var($reviews_dots, FILTER_VALIDATE_BOOLEAN ),
		
			// News Carousel
	        'news_autoplay'  => filter_var($news_autoplay, FILTER_VALIDATE_BOOLEAN ),
	        'news_duration'  => absint($news_duration),
	        'news_loop'      => filter_var($news_loop, FILTER_VALIDATE_BOOLEAN ),
	        'news_nav'       => filter_var($news_nav, FILTER_VALIDATE_BOOLEAN ),
	        'news_dots'      => filter_var($news_dots, FILTER_VALIDATE_BOOLEAN ),
	    )
	);
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'bizindustries_scripts' );

//Register Required plugin
require_once (get_template_directory() .'/inc/tgm/recommended-plugins.php');

/**
*Custom Admin Style 
*/
function bizindustries_admin_acripts(){

	wp_register_style( 'bizindustries_custom_wp_admin_css', get_template_directory_uri() . '/assets/css/admin.css', false, '1.0.0' );
	wp_enqueue_style( 'bizindustries_custom_wp_admin_css' );

}
add_action('admin_enqueue_scripts','bizindustries_admin_acripts');


/**
 * Load Typpgraphy Options
 */
require get_template_directory() . '/inc/fonts.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * WooCommerce fuctins
 */
if(class_exists( 'WooCommerce' )) {
	require get_template_directory() . '/inc/woocommerce-fuctions.php';
}
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom action hooks for this theme.
 */
require get_template_directory() . '/inc/theme-actions.php';

/**
 * Custom styles for this theme.
 */
require get_template_directory() . '/inc/custom-style.php';

/**
 * Functions which enhance the theme
 */
require get_template_directory() . '/inc/theme-functions.php';

 /**
 * Load social icons functions
 */
require get_template_directory() . '/inc/social-icons.php';

 /**
 * Load Sanitizations
 */
require get_template_directory() . '/inc/customizer/sanitize.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

function bizindustries_set_to_premium() {
	$premium_status = false;
	if ( class_exists( 'Bootitems_Core' ) ) {
		$WC = new Bootitems_Core();
		$premium_status = $WC->bootitems_core_premium_status();
	}
	return $premium_status;
}

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

