<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bizindustries
 */

?>
	<!-- Start Footer Area -->
	<footer class="footer-area">
		
		<?php 
			/**
			 * hooked bizindustries_footer_widgets - 10
			 * @see bizindustries_footer_widgets
			*/
			do_action('bizindustries_footer_widgets');
			
			/**
			 * hooked bizindustries_footer_copyright - 10
			 * @see bizindustries_footer_copyright
			*/
			do_action('bizindustries_footer_copyright');
		?>

	</footer>
	<!-- End  Footer Area -->
	<!-- Back to Top -->
	<?php
	$backtotop = get_theme_mod( 'bizindustries_backto_top_display', true ); 
	if( $backtotop ) : ?>
	<a href="#page" class="back-to-top" id="back-to-top"><i class="fa fa-angle-up"></i></a>
	<?php endif; ?>
</div>
	<!-- Wrapper End -->
	<!-- Strat Preloader -->
	<?php
	$preloader = get_theme_mod( 'bizindustries_preloader_display', true );
	$preloader_text = get_theme_mod('preloader_text', __('Bizindustries Ltd.', 'bizindustries') );
	if( $preloader ) : ?>
	<div class="preloader-wrap">
		<div class="preloader">
			<div></div>
			<div></div>
			<div></div>
		</div>
		<span class="site-by">&copy <?php echo esc_html($preloader_text); ?></span>
	</div>
	<?php endif; ?>
	<!-- End Strat Preloader -->
	<?php wp_footer(); ?>
</body>
</html>
