/*
    Template  Name: Bizindustries- Business and Industrial HTML Template;
	Description: This is a multipurpose Business template;
	Version:  1.0
    Authot:   Md.Masud Rana
    Website:  www.bootitems.com
	
	[Note: This file contains all jquery plugins activation codes.]
*/
/*================================================
[  Table of contents  ]
================================================
01. Sticky Header
	02. MeanMenu Active
	03. Animation
	04. Hero Slider
	05. Testimonial Slide
	06. Team Carousel
	07. Brand Logo Carousel
	08. Isotope Filter
	09. Venobox
	10. Stellar
	11. Search Box
	12. CounterUp
	13. Preloader
	14. Back to Top
======================================
[ End table content ]
======================================*/
(function ($) {
 "use strict";
 
	/*==== 01. Sticky Header ====	*/
	$(window).on('scroll',function() {    
		var scroll = $(window).scrollTop();
		if (scroll < 120) {
			$('.sticky-header').removeClass('scroll-header');
		}else{
			$('.sticky-header').addClass('scroll-header');
		}
	});

	/* ==== 02. MeanMenu Active ==== */
	if ($('.bizin-nav').length) {
		jQuery('.bizin-nav').meanmenu({
			meanMenuOpen: "<span></span ><span></span><span></span >",
		});	
	}
	
	/*==== 03. KEYBOARD NAVIGATION ACTIVE ====*/	
	//$('.mean-nav').tabNav();
	
	/* ==== 04. MASONARY ACTIVE ====  */				
	$('.grip-wrap').imagesLoaded( function() {	   
		$('.grip-wrap').masonry({ singleMode: true });	
	});	
	
 	/* ==== 04. Animation ==== */
	var contentWayPoint = function() {
		var i = 0;
		$('.animate-box').waypoint( function( direction ) {
			if( direction === 'down' && !$(this.element).hasClass('animated-fast') ) {
				i++;
				$(this.element).addClass('item-animate');
				setTimeout(function(){
					$('body .animate-box.item-animate').each(function(k){
						var el = $(this);
						setTimeout( function () {
							var effect = el.data('animate-effect');
							if ( effect === 'fadeIn') {
								el.addClass('fadeIn animated-fast');
							} else if ( effect === 'fadeInLeft') {
								el.addClass('fadeInLeft animated-fast');
							} else if ( effect === 'fadeInRight') {
								el.addClass('fadeInRight animated-fast');
							} else {
								el.addClass('fadeInUp animated-fast');
							}
							el.removeClass('item-animate');
						},  k * 200, 'easeInOutExpo' );
					});
				}, 100);
			}
		} , { offset: '85%' } );
	};
	$(function(){
		contentWayPoint();
	});

	/* ==== 05. Hero Slider ==== */
	if ($('#hero-slider.owl-carousel').length) {
		$('#hero-slider.owl-carousel').owlCarousel({
			items:1,
			autoplay:get_js_option.slider_autoplay,
			autoplayTimeout:get_js_option.slider_duration,
			loop:get_js_option.slider_loop,
			autoplayHoverPause: false,
			smartSpeed: 500,
			margin:0,
			nav:get_js_option.slider_nav,
			dots:get_js_option.slider_dots,
			navText:['<span><i class="fa fa-angle-left"></i></span>','<span><i class="fa fa-angle-right"></i></span>'],
		}) 
	}

	/* ==== 06. Testimonial Slide ==== */
	var owl = $('.testimonial-slider.owl-carousel');
	  owl.owlCarousel({
        items: 2,
		autoplay: false,
		autoplayHoverPause: false,
		autoplayTimeout: 3000,
		dots:false,
		nav: true,
		loop: true,
		navContainerClass : 'owl-nav svg-nav',
		navText:['<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 27 46"><path d="M0.210,24.214 L31.359,-0.218 L31.351,48.657 L0.210,24.214 Z" class="aleft"/></svg>','<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 32 46"><path d="M31.789,24.499 L0.210,49.214 L0.210,-0.215 L31.789,24.499 Z" class="aright"/></svg>'],
        margin:30,
		responsive: {
		  0 : {
			items: 1,
		  },
		  480: {
			items: 1
		  },
		  768: {
			items: 1
		  },
		  980: {
			items: 2
		  },
		  1199: {
			items: 2
		  }
		}
	  })

	/* ==== 07. Team Carousel ==== */
	var owl = $('.team-carousel.owl-carousel');
	  owl.owlCarousel({
        items: 3,
		autoplay: get_js_option.team_autoplay,
		autoplayHoverPause: false,
		autoplayTimeout: get_js_option.team_duration,
		dots:get_js_option.team_dots,
		nav: get_js_option.team_nav,
		loop: get_js_option.team_loop,
		navContainerClass : 'owl-nav svg-nav',
		navText:['<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 27 46"><path d="M0.210,24.214 L31.359,-0.218 L31.351,48.657 L0.210,24.214 Z" class="aleft"/></svg>','<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 32 46"><path d="M31.789,24.499 L0.210,49.214 L0.210,-0.215 L31.789,24.499 Z" class="aright"/></svg>'],
        margin:30,
		responsive: {
		  0 : {
			items: 1
		  },
		  480: {
			items: 1
		  },
		  768: {
			items: 2
		  },
		  980: {
			items: 3
		  },
		  1199: {
			items: 3
		  }
		}
	  })


	/* ==== 08. Review Carousel ==== */
	var owl = $('.review-carousel.owl-carousel');
	  owl.owlCarousel({
        items: 2,
		autoplay: get_js_option.reviews_autoplay,
		autoplayHoverPause: false,
		autoplayTimeout: get_js_option.reviews_duration,
		dots:get_js_option.reviews_dots,
		nav: get_js_option.reviews_nav,
		loop: get_js_option.reviews_loop,
		navContainerClass : 'owl-nav svg-nav',
		navText:['<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 27 46"><path d="M0.210,24.214 L31.359,-0.218 L31.351,48.657 L0.210,24.214 Z" class="aleft"/></svg>','<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 32 46"><path d="M31.789,24.499 L0.210,49.214 L0.210,-0.215 L31.789,24.499 Z" class="aright"/></svg>'],
        margin:30,
		responsive: {
		  0 : {
			items: 1
		  },
		  480: {
			items: 1
		  },
		  768: {
			items: 1
		  },
		  980: {
			items: 2
		  },
		  1199: {
			items: 2
		  }
		}
	  })

	/* ==== 07. Brand Logo Carousel ==== */
	var owl = $('.brand-logos.owl-carousel');
	  owl.owlCarousel({
        items: 5,
		autoplay: get_js_option.brands_autoplay,
		autoplayHoverPause: false,
		autoplayTimeout: get_js_option.brands_duration,
		dots:false,
		nav: get_js_option.brands_nav,
		loop: get_js_option.brands_loop,
		navContainerClass : 'owl-nav svg-nav',
		navText:['<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 27 46"><path d="M0.210,24.214 L31.359,-0.218 L31.351,48.657 L0.210,24.214 Z" class="aleft"/></svg>','<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 32 46"><path d="M31.789,24.499 L0.210,49.214 L0.210,-0.215 L31.789,24.499 Z" class="aright"/></svg>'],
        margin:30,
		responsive: {
			0 : {
				items: 1
			},
			480: {
				items: 2
			},
			768: {
			    items: 3
			},
			980: {
			    items: 4
			},
			1199: {
				items: 5
			}
		}
	  })


	/* ==== 06. News Carousel ==== */
	var owl = $('.news-carousel.owl-carousel');
	owl.owlCarousel({
        items: 3,
		autoplay: get_js_option.news_autoplay,
		autoplayHoverPause: false,
		autoplayTimeout: get_js_option.news_duration,
		dots:get_js_option.news_dots,
		nav: get_js_option.news_nav,
		loop: get_js_option.news_loop,
		navContainerClass : 'owl-nav svg-nav',
		navText:['<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 27 46"><path d="M0.210,24.214 L31.359,-0.218 L31.351,48.657 L0.210,24.214 Z" class="aleft"/></svg>','<svg calss="svg-arrow" width="27" height="42" viewBox="0 0 32 46"><path d="M31.789,24.499 L0.210,49.214 L0.210,-0.215 L31.789,24.499 Z" class="aright"/></svg>'],
        margin:30,
		responsive: {
		  0 : {
			items: 1
		  },
		  480: {
			items: 1
		  },
		  768: {
			items: 2
		  },
		  980: {
			items: 3
		  },
		  1199: {
			items: 3
		  }
		}
	  })

	/* ==== 10. Stellar ==== */	
	$.stellar({
		horizontalScrolling:false,
		hideDistantElements: false,
		verticalOffset: 0,
		horizontalOffset: 0		
	});			

   /* ==== 11. Search Box ==== */
   jQuery('.search-icon').addClass('close');
	//toggle close/open on click of toggle
	jQuery('.search-icon').click(function(e) {
		if (jQuery(this).hasClass('close')) {
			jQuery(this).removeClass('close').addClass('open');
			jQuery('.search-icon, .search-modal').addClass('open');
		}
		else {
			jQuery(this).removeClass('open').addClass('close');
			jQuery('.search-icon, .search-modal').removeClass('open');
		}
	});
	jQuery(".search-cross").click(function () {
		if (jQuery('.search-icon, .search-modal').hasClass("open")) {
			jQuery('.search-icon').removeClass('open').addClass('close');
			jQuery('.search-modal').removeClass('open');
		}
	});
	// close when click off of container
	jQuery(document).on('click touchstart', function (e){
		if (!jQuery(e.target).is('.search-icon, .search-icon *, .search-modal-inner, .search-modal-inner *')) {
			jQuery('.search-icon, .search-modal').removeClass('open');
			jQuery('.search-icon').addClass('close');
		}
	});

	/* ==== 12. CounterUp ==== */	
	$('.counter').counterUp({
		delay: 10,
		time: 1000
	});

	/* ==== 13. Preloader ==== 		 */
	$(window).on('load',function(){
		$('.preloader-wrap').fadeOut(500);
	});

	/* ==== 14. Back to Top ==== */
	var $scroll_obj = $( '#back-to-top' );
	$(window).on('scroll',function(){
		if ( $( this ).scrollTop() > 300 ) {
		  $scroll_obj.fadeIn();
		} else {
		  $scroll_obj.fadeOut();
		}
	});
	$scroll_obj.on('click', function(){
		$( 'html, body' ).animate( { scrollTop: 0 }, 600 );
		return false;
	});
 
 
	jQuery(document).ready(function ($) {
		//accessibility
		$('.menu li a, .menu li').on('focus', function() {
			$(this).parents('li').addClass('focus');
		}).blur(function() {
			$(this).parents('li').removeClass('focus');
		});
	});
 
 
 
})(jQuery); 


