<?php
// Global variables define
define('BIZHUNT_PARENT_TEMPLATE_DIR_URI', get_template_directory_uri());
define('BIZHUNT_TEMPLATE_DIR_URI', get_stylesheet_directory_uri());
define('BIZHUNT_TEMPLATE_DIR', trailingslashit(get_stylesheet_directory()));

if (!function_exists('wp_body_open')) {

    function wp_body_open() {
        /**
         * Triggered after the opening <body> tag.
         */
        do_action('wp_body_open');
    }

}

//Enqueue Script
add_action('wp_enqueue_scripts', 'bizhunt_enqueue_styles');

function bizhunt_enqueue_styles() {
    if (get_theme_mod('custom_color_enable') == true) {
        bizhunt_custom_light();
    }
    wp_enqueue_style('bizhunt-parent-style', BIZHUNT_PARENT_TEMPLATE_DIR_URI . '/style.css', array('bootstrap'));
    //Add Script
    wp_enqueue_script('bizhunt-mp-masonry-js', BIZHUNT_TEMPLATE_DIR_URI . '/js/masonry/mp.mansory.js', array('jquery'), '', true);
}

//Setup theme
add_action('after_setup_theme', 'bizhunt_setup');

function bizhunt_setup() {
    load_theme_textdomain('bizhunt', BIZHUNT_TEMPLATE_DIR . '/languages');
    require(BIZHUNT_TEMPLATE_DIR . '/inc/customizer/footer-options.php');
    require(BIZHUNT_TEMPLATE_DIR . '/inc/customizer/customizer_theme_style.php');
}

if (is_admin()) {
    require get_stylesheet_directory() . '/admin/admin-init.php';
}

// Add custom color function
function bizhunt_custom_light() {
    $bizhunt_link_color = get_theme_mod('link_color');
    list($r, $g, $b) = sscanf($bizhunt_link_color, "#%02x%02x%02x");
    $r = $r - 50;
    $g = $g - 25;
    $b = $b - 40;

    if ($bizhunt_link_color != '#6974ea') :
        ?>
        <style type="text/css">
            .header-sidebar {
                background: <?php echo esc_attr($bizhunt_link_color); ?> !important;
            }
            .navbar5.navbar .nav .nav-item:hover .nav-link, .navbar5.navbar .nav .nav-item.active .nav-link {
                background: <?php echo esc_attr($bizhunt_link_color); ?> !important;
                color:#fff!important;
            }
            .services4 .post {
                background:  <?php echo esc_attr($bizhunt_link_color); ?> !important;
            }
            .services4 .entry-header .entry-title a:hover{
                color:#061018!important;  
            }
            #testimonial-carousel2 .testmonial-block:before {
                border-top: 25px solid <?php echo esc_attr($bizhunt_link_color); ?> !important;
            }
            #testimonial-carousel2 .testmonial-block {
                border-left: 4px solid <?php echo esc_attr($bizhunt_link_color); ?> !important;
            }
            @media (min-width: 991px){
                .navbar4 .header-lt::before {
                    background-color: <?php echo esc_attr($bizhunt_link_color); ?> !important;
                }}
            @media (min-width: 991px){
                .navbar4 .header-lt::after {
                    background-color: <?php echo esc_attr($bizhunt_link_color); ?> !important;
                }}
            .services2 .post::before {
                background-color: <?php echo esc_attr($bizhunt_link_color); ?> !important;
            }
            .services2 .post-thumbnail i.fa {
                color: <?php echo esc_attr($bizhunt_link_color); ?> !important;
            }
            .services2 .post:hover .post-thumbnail i.fa {
                color: #fff !important;
            }
            @media (max-width: 991px) {
                .navbar4 .header-lt {
                    background-color: <?php echo esc_attr($bizhunt_link_color); ?> !important;
                }}
            </style>
        <?php
        endif;
    }

//Set for old user before 1.3.8
if (!get_option('honeypress_user_before_1_3_8', false)) {
    //detect old user and set value
    $bizhunt_service_title=get_theme_mod('home_service_section_title');
    $bizhunt_service_discription=get_theme_mod('home_service_section_discription');
    $bizhunt_blog_title=get_theme_mod('home_news_section_title');
    $bizhunt_blog_discription=get_theme_mod('home_news_section_discription');
    $bizhunt_slider_title=get_theme_mod('home_slider_title');
    $bizhunt_slider_discription=get_theme_mod('home_slider_discription'); 
    $bizhunt_testimonial_title=get_theme_mod('home_testimonial_section_title'); 
    $bizhunt_testimonial__discription=get_theme_mod('home_testimonial_section_discription');
    $bizhunt_footer_credit=get_theme_mod('footer_copyright');

    if ($bizhunt_service_title !=null || $bizhunt_service_discription !=null || $bizhunt_blog_title !=null || $bizhunt_blog_discription !=null || $bizhunt_slider_title !=null || $bizhunt_slider_discription !=null || $bizhunt_testimonial_title !=null || $bizhunt_testimonial__discription !=null || $bizhunt_footer_credit !=null )  {
        add_option('honeypress_user_before_1_3_8', 'old');

    } else {
        add_option('honeypress_user_before_1_3_8', 'new');
    }
}

//Add footer function
    add_action('bizhunt_footer_section_hook', 'bizhunt_footer_section_hook');

    function bizhunt_footer_section_hook() {
        ?>
        <footer class="site-footer">  
        <div class="container">
            <?php if (is_active_sidebar('footer-sidebar-1') || is_active_sidebar('footer-sidebar-2') || is_active_sidebar('footer-sidebar-3')): ?>
                <div class="seprator-line"></div>   
            <?php get_template_part('sidebar', 'footer');
        endif;
        ?>  
        </div>
        <?php
        $bizhunt_user=get_option('honeypress_user_before_1_3_8');
        if($bizhunt_user=='old'){?>
            <div class="site-info text-center">
            <?php $bizhunt_footer_copyright = get_theme_mod('footer_copyright', '<p>' . __('Proudly powered by <a href="https://wordpress.org"> WordPress</a> | Theme: <a href="https://spicethemes.com" rel="nofollow">Bizhunt</a> by SpiceThemes', 'bizhunt') . '</p>'); ?>  
            <?php echo wp_kses_post($bizhunt_footer_copyright); ?> 
            </div>
    <?php }else{?>
        <div class="site-info text-center">
             <p><?php esc_html_e( 'Proudly powered by', 'bizhunt' ); ?> <a href="<?php echo esc_url( __( 'https://wordpress.org', 'bizhunt' ) ); ?>"><?php esc_html_e( 'WordPress', 'bizhunt' ); ?> </a> <?php esc_html_e( '| Theme:', 'bizhunt' ); ?> <a href="<?php echo esc_url( __( 'https://spicethemes.com', 'bizhunt' ) ); ?>" rel="nofollow"> <?php esc_html_e( 'Bizhunt', 'bizhunt' ); ?></a> <?php esc_html_e( 'by SpiceThemes', 'bizhunt' );?></p>
        </div>
    <?php } ?>
    </footer>
    <?php
}

//Add Masonry Layout
add_action('wp_footer', 'bizhunt_custom_script');

function bizhunt_custom_script() {

    wp_reset_query();
    ?>
    <script>
        jQuery(document).ready(function (jQuery) {
            jQuery("#blog-masonry2").mpmansory(
                    {
                        childrenClass: 'item', // default is a div
                        columnClasses: 'padding', //add classes to items
                        breakpoints: {
                            xl: 6, //Change masonry column here like 2, 3, 4 column
                            lg: 6,
                            md: 6,
                            sm: 12,
                            xs: 12
                        },
                        distributeBy: {order: false, height: false, attr: 'data-order', attrOrder: 'asc'}, //default distribute by order, options => order: true/false, height: true/false, attr => 'data-order', attrOrder=> 'asc'/'desc'
                        onload: function (items) {
                            //make somthing with items
                        }
                    }
            );
        });
    </script>
    <?php
}

//Remove Footer section
function bizhunt_remove_customize_register( $wp_customize ) {

   $wp_customize->remove_section( 'footer_section');

}
add_action( 'customize_register', 'bizhunt_remove_customize_register',11);