<?php
/**
* Template for Inner Banner Section for all the inner pages
*
* @since Bizcorp 0.1
*/
?>
<section class="wrapper section-banner-wrap">
	<div class="wrap-inner-banner" style="background-image: url('<?php header_image(); ?>')">
		<header class="page-header">
			<div class="inner-header-content">
				<h1 class="page-title"><?php echo wp_kses_post( $args[ 'title' ] ); ?></h1>
				<?php if( $args[ 'description' ] ): ?>
					<div class="page-description">
						<?php echo $args[ 'description' ]; ?>
					</div>
				<?php endif; ?>
			</div>
		</header>
	</div>
	<?php if( !is_front_page() ): ?>
		<div class="breadcrumb-wrap">
			<div class="container">
				<?php 
					bizcorp_breadcrumb();
				?>
			</div>
		</div>
	<?php endif; ?>
</section>