<?php
/**
 * Template part for displaying testimonial section
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @since Bizcorp 0.1
 */

if( ! bizcorp_get_option( 'disable_testimonial' ) ):
	$testi_ids = bizcorp_get_ids( 'testimonial_page' );

	if( !empty( $testi_ids ) && is_array( $testi_ids ) && count( $testi_ids ) > 0 ):

		$query = new WP_Query( apply_filters( 'bizcorp_testimonial_args', array( 
			'post_type'      => 'page', 
			'post__in'       => $testi_ids, 
			'posts_per_page' => 4,
			'orderby'        => 'post__in'
		)));

		if( $query->have_posts() ):
?>
			<section class="wrapper block-testimonial">
				<?php
					bizcorp_section_heading( array(
						'id' => 'testimonial_main_page'
					));
				?>
				<div class="content-inner">
					<div class="controls"></div>
					<div class="container">
						<div class="big-icon">
							<span class="kfi kfi-quotations"></span>
						</div>
						<div class="row">
							<div class="testimonial-carousel owl-carousel col-xs-10 col-sm-10 col-md-10 col-xs-offset-1 col-sm-offset-1 col-md-offset-1">
								<?php 
									while ( $query->have_posts() ):
										$query->the_post(); 
										$image = bizcorp_get_thumbnail_url( array(
											'size' => 'thumbnail'
										));
								?>
									    <div class="slide-item">
											<article class="post-content">
												<div class="post-content-inner">
													<blockquote>
								    					<?php the_content(); bizcorp_edit_link(); ?>
				    									<div class="post-thumb-outer">
				    										<div class="post-thumb">
				    					    					<img src="<?php echo esc_url( $image ); ?>">
				    										</div>
				    									</div>
									    				<footer class="post-title">
									    					<cite>
									    						<?php bizcorp_testimonial_title(); ?>
									    					</cite>
									    				</footer>
													</blockquote>
												</div>

											</article>
										</div>
								<?php
									endwhile; 
									wp_reset_postdata();
								?>
							</div>
						</div>
					</div>
					<div class="container">
						<div class="owl-pager" id="testimonial-pager"></div>
					</div>
				</div>
			</section><!-- End Testimonial Section -->
<?php
		endif;
	endif;
endif;