<?php
/**
 * Template part for displaying slider section
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @since Bizcorp 0.1
 */

$slider_ids = bizcorp_get_ids( 'slider_page' );
if( !empty( $slider_ids ) && is_array( $slider_ids ) && count( $slider_ids ) > 0 ){
?>
	<section class="wrapper block-slider">
		<div class="mouse-holder">
			<div class="mouse-hover">
			  	<a href="#after-slider" class="mouse scroll-to">
					<span><?php esc_html_e( 'Scroll Down' ,'bizcorp' ); ?></span>
					<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="29.083px" height="44px" viewBox="0 0 29.083 44" enable-background="new 0 0 29.083 44" xml:space="preserve">
					<path id="mouse" fill="transparent" stroke="#919191" stroke-width="2" stroke-miterlimit="10" d="M27.083,29.962c0,6.627-5.373,12-12,12h-1  c-6.627,0-12-5.373-12-12v-16c0-6.627,5.373-12,12-12h1c6.627,0,12,5.373,12,12V29.962z"/>
					<path id="scroll" fill="#D9D9D9" d="M15.417,15.504c0,0.553-0.448,1-1,1l0,0c-0.552,0-1-0.447-1-1v-4.167c0-0.553,0.448-1,1-1l0,0  c0.552,0,1,0.447,1,1V15.504z"/>
					</svg>
				</a>
			</div>
		</div>

		<div class="controls">
		</div>
		<div class="owl-pager" id="kt-slide-pager"></div>

		<div class="home-slider owl-carousel">
			<?php
				$query = new WP_Query( apply_filters( 'bizcorp_slider_args', array(
					'posts_per_page' => 3,
					'post_type'      => 'page',
					'orderby'        => 'post__in',
					'post__in'       => $slider_ids,
				)));
				
				while ( $query->have_posts() ) :  $query->the_post();
					$image = bizcorp_get_thumbnail_url( array( 'size' => 'bizcorp-1920-750' ) );
			?>
					<div class="slide-item" style="background-image: url( <?php echo esc_url( $image ); ?> );">
						<div class="banner-overlay">
					    	<div class="container">
					    		<div class="row">
					    			<div class="col-sm-12 col-md-10 col-md-offset-1">
					    				<div class="slide-inner text-center">
					    					<div class="post-content-inner-wrap">
						    					<header class="post-title">
						    						<h2><?php the_title(); ?></h2>
						    					</header>
						    					<?php  
						    						bizcorp_excerpt( 16, true );
						    						bizcorp_edit_link(); 
						    					?>
							    				<div class="button-container">
							    					<a href="<?php the_permalink(); ?>" class="button-primary button-round">
							    						<?php esc_html_e( 'Learn More', 'bizcorp' ); ?>
							    					</a>
							    				</div>
						    				</div>
					    				</div>
					    			</div>
					    		</div>
					    	</div>
						</div>
					</div>
			<?php
				endwhile; 
				wp_reset_postdata(); 	
			?>
		</div>
		<div id="after-slider"></div>
	</section>
<?php 
}else {
	bizcorp_inner_banner();
}