<?php
/**
 * Template part for displaying Pricing Tabel section
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @since Bizcorp 0.1
 */
if( !bizcorp_get_option( 'disable_pricing_table' ) ):  ?>
<section class="wrapper block-pricing">
	<?php 
		bizcorp_section_heading( array( 
			'id' => 'pricing_table_main_page'
		));
	?>
	<div class="block-pricing-outer">
		<div class="container">
			<div class="row">
				<?php
					$id = absint( bizcorp_get_option( 'pricing_table_page' ) );
					if( $id > 0 ){
						$query = new WP_Query( apply_filters( 'bizcorp_pricing_table_page_args',  array( 
							'post_type' => 'page', 
							'p'         => $id, 
						)));
						while( $query->have_posts() ){
							$query->the_post();
							the_content();	
						}
						wp_reset_postdata();					
					}
				?>
			</div>
		</div>
	</div>
</section> <!-- End Pricing Section -->
<?php endif; ?>