<?php
/**
 * Template part for displaying callback section
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @since Bizcorp 0.1
 */
if( ! bizcorp_get_option( 'disable_callback' ) ):

	$callback_page = bizcorp_get_option( 'callback_page' );

	if( !empty( $callback_page ) ):

		$query = new WP_Query( apply_filters( 'bizcorp_callback_args', array(
			'p'         => $callback_page,
			'post_type' => 'page'
		)));

		while( $query->have_posts() ):
			$query->the_post();
			$image = bizcorp_get_callback_banner_url();
		?>
			<style type="text/css">
				.block-callback{
					background-image: url(<?php echo esc_url( $image ); ?> );
				}
			</style>
			<!-- Callback Section -->
			<section class="wrapper block-callback banner-content">
				<div class="banner-overlay">
					<div class="container">
						<div class="row">
							<div class="col-xs-12 col-sm-10 col-md-10 col-sm-offset-1 col-md-offset-1">
								<?php
									bizcorp_section_heading( array(
										'divider' => false,
										'query'   => false
									));
								?>
								<div class="button-container">
									<?php
										$callback_link_page = bizcorp_get_option( 'callback_link_page' );
										if( !empty( $callback_link_page ) ):

											$query_link = new WP_Query( apply_filters( 'bizcorp_callback_link_args', array(
												'p'         => $callback_link_page,
												'post_type' => 'page'
											)));

											while( $query_link->have_posts() ):
												$query_link->the_post();
									?>
												<a href="<?php the_permalink(); ?>" class="button-primary button-round">
													<?php the_title(); ?>
												</a>
									<?php
												bizcorp_edit_link();
											endwhile;
											wp_reset_postdata();
										endif;
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section><!-- End Callback Section -->
<?php
		endwhile;
		wp_reset_postdata();
	endif;
endif; 