<?php
/**
 * Template part for displaying about us section
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @since Bizcorp 0.1
 */
if( !bizcorp_get_option( 'disable_about' ) ):
	$id = bizcorp_get_option( 'about_page' );
	if( $id ):
		$query = new WP_Query( apply_filters( 'bizcorp_about_page_args',  array( 
			'post_type'      => 'page', 
			'p'       => $id, 
		)));
		while( $query->have_posts() ): 
			$query->the_post();
			$image = bizcorp_get_thumbnail_url( array(
				'size' => 'bizcorp-700-400'
			));
	?>
	<!-- About Section -->
	<section class="wrapper block-about">
		<div class="thumb-block-outer">
			<div class="container">
				<div class="row">
					<?php
					$class = 'col-xs-12 col-sm-12 col-md-12';
						if( has_post_thumbnail() ):
							$class = 'col-xs-12 col-sm-12 col-md-6';
					?>
					<div class="col-xs-12 col-sm-12 col-md-6">
						<div class="area-div thumb-outer">
							<?php the_post_thumbnail( 'bizcorp-700-400' ); ?>
						</div>
					</div>
					<?php endif; ?>
					<div class="<?php echo esc_attr( $class ); ?>">
						<div class="area-div content-outer">
							<div class="section-title-group">
								<h2 class="section-title">
									<?php the_title(); bizcorp_edit_link(); ?>
								</h2>
								<div class="maintitle-divider"></div>
							</div>
							<?php bizcorp_excerpt(25); ?>
							<div class="button-container">
								<a href="<?php the_permalink(); ?>" class="button-primary button-round">
									<?php esc_html_e( 'Explore More', 'bizcorp' ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section> <!-- End About Section -->
	<?php 
		endwhile;
		wp_reset_postdata();
	endif;
endif;
