<?php
/**
* Sets settings for general fields
*
* @since  Bizcorp 0.1
* @param  array $settings
* @return array Merged array
*/

function Bizcorp_Customizer_general_settings( $settings ){

	$general = array(
		'site_title_color' => array(
			'label'     => esc_html__( 'Site Title', 'bizcorp' ),
			'transport' => 'postMessage',
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_tagline_color' => array(
			'label'     => esc_html__( 'Site Tagline', 'bizcorp' ),
			'transport' => 'postMessage',
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_primary_color' => array(
			'label'     => esc_html__( 'Primary', 'bizcorp' ),
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_gradient_start_color' => array(
			'label'     => esc_html__( 'Gradient Start', 'bizcorp' ),
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_gradient_end_color' => array(
			'label'     => esc_html__( 'Gradient End', 'bizcorp' ),
			'section'   => 'colors',
			'type'      => 'colors',
		),

		# Theme Options
		# General
		'menu_padding_top' => array(
			'label'     => esc_html__( 'Additional Space on top of Menu.', 'bizcorp' ),
			'section'   => 'general_options',
			'type'      => 'number',
			'transport' => 'postMessage'
		),
		'top_header_gradient_background' => array(
			'label'     => esc_html__( 'Top Header Gradient Background', 'bizcorp' ),
			'section'   => 'general_options',
			'type'      => 'checkbox',
		),
		'disable_search_icon' => array(
			'label'     => esc_html__( 'Disable Header Search Icon', 'bizcorp' ),
			'section'   => 'general_options',
			'type'      => 'checkbox',
		),
		'enable_scroll_top_in_mobile' => array(
			'label'     => esc_html__( 'Enable Scroll top in mobile', 'bizcorp' ),
			'section'   => 'general_options',
			'transport' => 'postMessage',
			'type'      => 'checkbox' ,
		),
		# Footer
		'footer_text' =>  array(
			'label'     => esc_html__( 'Footer Text', 'bizcorp' ),
			'section'   => 'footer_options',
			'type'      => 'textarea'
		),
	);

	return array_merge( $settings, $general );
}
add_filter( 'Bizcorp_Customizer_fields', 'Bizcorp_Customizer_general_settings' );