<?php
/**
* Sets setting field for homepage
* 
* @since  Bizcorp 0.1
* @param  array $settings
* @return array Merged array of settings
*
*/
function bizcorp_frontpage_settings( $settings ){

	$home_settings = array(
		# Settings for slider
		'slider_page' => array(
			'label'       => esc_html__( 'Slider Page', 'bizcorp' ),
			'section'     => 'slider',
			'type'        => 'text',
			'description' => esc_html__( 'Input page id. Separate with comma. for eg. 2,9,23. Supports Maximum 3 sliders.', 'bizcorp' )
		),
		'slider_control' => array(
			'label'     => esc_html__( 'Show Slider Control', 'bizcorp' ),
			'section'   => 'slider',
			'type'      => 'checkbox',
			'transport' => 'postMessage',
		),
		'slider_autoplay' => array(
			'label'   => esc_html__( 'Slider Auto Play', 'bizcorp' ),
			'section' => 'slider',
			'type'    => 'checkbox'
		),
		'slider_timeout' => array(
			'label'    => esc_html__( 'Slider Timeout ( in sec )', 'bizcorp' ),
			'section'  => 'slider',
			'type'     => 'number'
		),

		# Settings for service section
		'service_main_page' => array(
			'label'   => esc_html__( 'Select Main Page for Services', 'bizcorp' ),
			'section' => 'home_service',
			'type'    => 'dropdown-pages',
		),
		'service_page' => array(
			'label'   => esc_html__( 'Service Page', 'bizcorp' ),
			'section' => 'home_service',
			'type'    => 'text',
			'description' => esc_html__( 'Input page id. Separate with comma. for eg. 2,9,23', 'bizcorp' )
		),
		'disable_service' => array(
			'label'   => esc_html__( 'Disable Service Section', 'bizcorp' ),
			'section' => 'home_service',
			'type'    => 'checkbox',
		),

		# Settings for about page
		'about_page' => array(
			'label'   => esc_html__( 'Select About Page', 'bizcorp' ),
			'section' => 'home_about',
			'type'    => 'dropdown-pages',
		),
		'disable_about' => array(
			'label'   => esc_html__( 'Disable About Us Section', 'bizcorp' ),
			'section' => 'home_about',
			'type'    => 'checkbox',
		),

		# Settings for Testimonials
		'testimonial_main_page' => array(
			'label'   => esc_html__( 'Select a main page for Testimonial', 'bizcorp' ),
			'section' => 'home_testimonial',
			'type'    => 'dropdown-pages',
		),
		'testimonial_page' => array(
			'label'   => esc_html__( 'Testimonial Pages', 'bizcorp' ),
			'section' => 'home_testimonial',
			'type'    => 'text',
			'description' => esc_html__( 'Input page id. Separate with comma. for eg. 2,9,23', 'bizcorp' )
		),
		'disable_testimonial' => array(
			'label'   => esc_html__( 'Disable Testimonial Section', 'bizcorp' ),
			'section' => 'home_testimonial',
			'type'    => 'checkbox',
		),

		# Settings of Pricing Table
		'pricing_table_main_page' => array(
			'label'   => esc_html__( 'Select a main page for Pricing', 'bizcorp' ),
			'section' => 'home_pricing_table',
			'type'    => 'dropdown-pages',
		),
		'pricing_table_page' => array(
			'label' => esc_html__( 'Pricing Table Page', 'bizcorp' ),
			'section' => 'home_pricing_table',
			'type'    => 'dropdown-pages',
		),
		'disable_pricing_table' => array(
			'label'   => esc_html__( 'Disable Pricing Table Section', 'bizcorp' ),
			'section' => 'home_pricing_table',
			'type'    => 'checkbox',
		),
		
		# Settings for callback section
		'callback_page' => array(
			'label'   => esc_html__( 'Select a Callback Page', 'bizcorp' ),
			'section' => 'home_callback',
			'type'    => 'dropdown-pages'
		),
		'callback_link_page' => array(
			'label'   => esc_html__( 'Select a Link Page', 'bizcorp' ),
			'section' => 'home_callback',
			'type'    => 'dropdown-pages',
		),
		'disable_callback' => array(
			'label'   => esc_html__( 'Disable Callback Section', 'bizcorp' ),
			'section' => 'home_callback',
			'type'    => 'checkbox',
		),

		# Settings for Blog section
		'blog_main_page' => array(
			'label'   => esc_html__( 'Select a main page for Blog', 'bizcorp' ),
			'section' => 'home_blog',
			'type'    => 'dropdown-pages',
		),
		'blog_category' => array(
			'label'   => esc_html__( 'Choose Blog Category', 'bizcorp' ),
			'section' => 'home_blog',
			'type'    => 'dropdown-categories',
		),
		'blog_number' => array(
			'label' => esc_html__( 'Number of Posts', 'bizcorp' ),
			'section' => 'home_blog',
			'type'    => 'number',
			'input_attrs' => array(
				'max' => 3,
				'min' => 1
			)
		),
		'disable_blog' => array(
			'label'   => esc_html__( 'Disable Blog Section', 'bizcorp' ),
			'section' => 'home_blog',
			'type'    => 'checkbox',
		),
	);

	return array_merge( $home_settings, $settings );
}
add_filter( 'Bizcorp_Customizer_fields', 'bizcorp_frontpage_settings' );