<?php
/**
* Sets sections for Bizcorp_Customizer
*
* @since  Bizcorp 0.1
* @param  array $sections
* @return array Merged array
*/
function Bizcorp_Customizer_sections( $sections ){

	$bizcorp_sections = array(
		
		# Section for Fronpage panel
		'slider' => array(
			'title' => esc_html__( 'Slider', 'bizcorp' ),
			'panel' => 'frontpage_options'
		),
		'home_about' => array(
			'title' => esc_html__( 'About', 'bizcorp' ),
			'panel' => 'frontpage_options'
		),
		'home_service' => array(
			'title' => esc_html__( 'Service', 'bizcorp' ),
			'panel' => 'frontpage_options'
		),
		'home_testimonial' => array(
			'title' => esc_html__( 'Testimonial', 'bizcorp' ),
			'panel' => 'frontpage_options'
		),
		'home_pricing_table' => array(
			'title' => esc_html__( 'Pricing Table', 'bizcorp' ),
			'panel' => 'frontpage_options'
		),
		'home_callback' => array(
			'title' => esc_html__( 'Callback', 'bizcorp' ),
			'panel' => 'frontpage_options'
		),
		'home_blog' => array(
			'title' => esc_html__( 'Blog', 'bizcorp' ),
			'panel' => 'frontpage_options'
		),

		# Section for Theme Options panel
		'general_options' => array(
			'title' => esc_html__( 'General', 'bizcorp' ),
			'panel' => 'theme_options'
		),
		'footer_options' => array(
			'title' => esc_html__( 'Footer', 'bizcorp' ),
			'panel' => 'theme_options'
		)
	);

	return array_merge( $bizcorp_sections, $sections );
}
add_filter( 'Bizcorp_Customizer_sections', 'Bizcorp_Customizer_sections' );