<?php
/**
* Loads all the components related to customizer 
*
* @since Bizcorp 0.1
*/
require get_parent_theme_file_path( '/modules/customizer/framework/customizer.php' );
require get_parent_theme_file_path( '/modules/customizer/panels/panels.php' );
require get_parent_theme_file_path( '/modules/customizer/sections/sections.php' );

require get_parent_theme_file_path( '/modules/customizer/settings/general.php' );
require get_parent_theme_file_path( '/modules/customizer/settings/frontpage.php' );
require get_parent_theme_file_path( '/modules/customizer/defaults/defaults.php' );


function bizcorp_modify_default_settings( $wp_customize ){

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
	$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
	$wp_customize->get_control( 'background_color' )->label = esc_html__( 'Background', 'bizcorp' );
}
add_action( 'bizcorp_customize_register', 'bizcorp_modify_default_settings' );

function bizcorp_default_styles(){
	
	$site_title_color           = bizcorp_get_option( 'site_title_color' );
	$site_tagline_color         = bizcorp_get_option( 'site_tagline_color' );
	$primary_color              = bizcorp_get_option( 'site_primary_color' );
	$gradient_start_color       = bizcorp_get_option( 'site_gradient_start_color' );
	$gradient_end_color         = bizcorp_get_option( 'site_gradient_end_color' );

	$slider_control             = bizcorp_get_option( 'slider_control' );
	$menu_padding_top           = bizcorp_get_option( 'menu_padding_top' );


	?>
	<style type="text/css">
		.offcanvas-menu-open .kt-offcanvas-overlay {
		    position: fixed;
		    width: 100%;
		    height: 100%;
		    background: rgba(0, 0, 0, 0.7);
		    opacity: 1;
		    z-index: 9;
		    top: 0px;
		}

		.kt-offcanvas-overlay {
		    width: 0;
		    height: 0;
		    opacity: 0;
		    transition: opacity 0.5s;
		}
		
		<?php if( bizcorp_get_option( 'top_header_gradient_background') ): ?>
			.top-header {
				background: <?php echo esc_attr( $gradient_start_color ); ?>;
				/* Old browsers */
				background: -moz-linear-gradient(-45deg, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
				/* FF3.6-15 */
				background: -webkit-linear-gradient(-45deg, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
				/* Chrome10-25,Safari5.1-6 */
				background: linear-gradient(135deg, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
			}

			.top-header .site-branding .site-title,
			.top-header .site-branding .site-title a,
			.top-header .site-branding .site-description,
			.top-header .top-header-right .socialgroup a {
			    color: #ffffff !important;
			}

			.top-header .site-branding .site-description {
			    border-left: 1px solid rgba(255, 255, 255, 0.6) !important;
			}

			.top-header .site-branding .site-title a:hover, .top-header .site-branding .site-title a:focus, .top-header .site-branding .site-title a:active, .top-header .top-header-right .socialgroup a:hover, .top-header .top-header-right .socialgroup a:focus, .top-header .top-header-right .socialgroup a:active {
			    color: #0081FE !important;
			}
			/*responsive*/
			@media screen and (max-width: 767px){
				.top-header .site-branding .site-description {
				    border-left: none !important;
				}
			}
		<?php endif; ?>

		#primary-nav-container{
			padding-top: <?php echo esc_attr( $menu_padding_top ) . 'px'; ?>;
		}

		<?php if( !$slider_control ): ?>
			.block-slider .controls, .block-slider .owl-pager{
				opacity: 0;
			}
		<?php endif; ?>

		/*======================================*/
		/* Site title */
		/*======================================*/
		.top-header .site-branding .site-title,
		.top-header .site-branding .site-title a {
			color: <?php echo esc_attr( $site_title_color ); ?>;
		} 

		/*======================================*/
		/* Tagline title */
		/*======================================*/
		.top-header .site-branding .site-description {
			color: <?php echo esc_attr( $site_tagline_color ); ?>;
		}

		/*======================================*/
		/* Primary color */
		/*======================================*/

		/*======================================*/
		/* Background Primary color */
		/*======================================*/
		.button-primary,
		.site-header .header-bottom-right .cart-icon a .count,
		.block-slider #kt-slide-pager .owl-dot span:hover,
		.block-slider #kt-slide-pager .owl-dot span:focus,
		.block-slider #kt-slide-pager .owl-dot span:active,
		.block-slider #kt-slide-pager .owl-dot.active span:hover,
		.block-slider #kt-slide-pager .owl-dot.active span:focus,
		.block-slider #kt-slide-pager .owl-dot.active span:active,
		article.hentry.sticky .post-format-outer > span a {
			background-color: <?php echo esc_attr( $primary_color ); ?>
		}

		/*======================================*/
		/* Border Primary color */
		/*======================================*/
		.button-primary,
		.block-grid .post-content .post-content-inner span.cat a,
		.block-slider #kt-slide-pager .owl-dot span:hover,
		.block-slider #kt-slide-pager .owl-dot span:focus,
		.block-slider #kt-slide-pager .owl-dot span:active {
			border-color: <?php echo esc_attr( $primary_color ); ?>
		}

		/*======================================*/
		/* Gradient color */
		/*======================================*/
		
		#go-top span,
		.icon-block-outer .list-inner .icon-area .icon-outer a,
		.block-testimonial .content-inner .big-icon span,
		.block-grid .post-content .post-thumb-outer .post-detail a.date {
		  background: <?php echo esc_attr( $gradient_start_color ); ?>;
		  /* Old browsers */
		  background: -moz-linear-gradient(-45deg, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
		  /* FF3.6-15 */
		  background: -webkit-linear-gradient(-45deg, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
		  /* Chrome10-25,Safari5.1-6 */
		  background: linear-gradient(135deg, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
		}

		.block-pricing-outer .post-content .post-content-inner .recomended span {
			background: <?php echo esc_attr( $gradient_start_color ); ?>;
			/* Old browsers */
			background: -moz-linear-gradient(top, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
			/* FF3.6-15 */
			background: -webkit-linear-gradient(top, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
			/* Chrome10-25,Safari5.1-6 */
			background: linear-gradient(to bottom, <?php echo esc_attr( $gradient_start_color ); ?> 0%, <?php echo esc_attr( $gradient_end_color ); ?> 100%);
		}
		
		.block-pricing-outer .post-content .post-content-inner .recomended:before {
			border-top-color: <?php echo esc_attr( $gradient_end_color ); ?>;
		}
	</style>
	<?php
}
add_action( 'wp_head', 'bizcorp_default_styles' );

/**
* Load customizer preview js file
*/
function bizcorp_customize_preview_js() {
	wp_enqueue_script( 'bizcorp-customize-preview', get_theme_file_uri( '/assets/js/customizer/customize-preview.js' ), array( 'jquery', 'customize-preview'), '1.0', true );
}
add_action( 'customize_preview_init', 'bizcorp_customize_preview_js' );