<?php
/**
* Generates default options for customizer.
*
* @since  Bizcorp 0.1
* @access public
* @param  array $options 
* @return array
*/
	
function bizcorp_default_options( $options ){

	$defaults = array(
		# Site identiry
		'site_title'         	         => esc_html__( 'bizcorp', 'bizcorp' ),
		'site_title_color'   	         => '#ffffff',
		'site_tagline'       	         => esc_html__( 'Corporate Business WP Theme', 'bizcorp' ),
		'site_tagline_color' 	         => '#d9d9d9',

		# Primary color
		'site_primary_color' 	         => '#00BCEB',
		'site_gradient_start_color' 	 => '#558bc7',
		'site_gradient_end_color'        => '#32b8c1',

		# Menu padding top
		'menu_padding_top'               => 0,
		'top_header_gradient_background' => false,

		# Slider
		'slider_control'     	         => true,
		'slider_timeout'     	         => 5,
		'slider_autoplay'    	         => false,
		
		# About
		'disable_about'                  => false,

		# Service
		'disable_service'                => false,

		# Callback
		'disable_callback'               => false,

		# Blog
		'disable_blog'                   => false,
		'blog_title'                     => esc_html__( 'LATEST BLOG', 'bizcorp' ),
		'blog_number'                    => 3,
		'blog_category'                  => 1,

		# Theme Options
		# General
		'enable_alt_menu'                => true,
		'disable_search_icon'            => false,
		'enable_scroll_top_in_mobile'    => false,
		'disable_pricing_table'          => true,
		
		# Footer
		'footer_text'                    => bizcorp_get_footer_text(),
	);

	return array_merge( $options, $defaults );
}
add_filter( 'Bizcorp_Customizer_defaults', 'bizcorp_default_options' );

if( !function_exists( 'bizcorp_get_footer_text' ) ):
/**
* Generate Default footer text
*
* @return string
* @since Bizcorp 0.1
*/
function bizcorp_get_footer_text(){

	$text = esc_html__( '&copy Copyright 2018; All Rights Reserved. Proudly powered by', 'bizcorp' );
	$text .= ' <a href="'.esc_url( '//wordpress.org' ).'" target="_blank">'.esc_html__( 'WordPress', 'bizcorp' ).'</a> | ';

	$text .= esc_html__( 'Bizcorp Theme by', 'bizcorp' ).' <a href="'.esc_url( '//keonthemes.com' ).' target="_blank">';
	$text .= esc_html__( 'Keon Themes', 'bizcorp' ).'</a>';
							
	return $text;
}
endif;