<?php
/**
* Bizcorp breadcrumb.
*
* @since Bizcorp 0.1
* @uses breadcrumb_trail()
*/
require get_parent_theme_file_path( '/modules/breadcrumbs/breadcrumbs.php' );
if ( ! function_exists( 'bizcorp_breadcrumb' ) ) :

	function bizcorp_breadcrumb() {

		$breadcrumb_args = apply_filters( 'bizcorp_breadcrumb_args', array(
			'show_browse' => false,
		) );

		breadcrumb_trail( $breadcrumb_args );
	}

endif;

function bizcorp_modify_breadcrumb( $crumb ){

	$i = count( $crumb ) - 1;
	$title = bizcorp_remove_pipe( $crumb[ $i ] );

	$crumb[ $i ] = $title;

	return $crumb;
}
add_filter( 'breadcrumb_trail_items', 'bizcorp_modify_breadcrumb' );