<?php
/**
 * The header for our theme
 * This is the template that displays all of the <head> section and everything up.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 * @since Bizcorp 0.1
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>

	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#content">
			<?php echo esc_html__( 'Skip to content', 'bizcorp' ); ?>
		</a>
		<?php get_template_part( 'template-parts/header/offcanvas', 'menu' ); ?>
		<header class="wrapper top-header">
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-sm-6 col-md-6">
						<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-6">
						<div class="top-header-right">
							<div class="socialgroup">
								<?php bizcorp_get_menu( 'social' ); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<header id="masthead" class="wrapper site-header" role="banner">
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-sm-12 col-md-8" id="primary-nav-container">
						<div class="wrap-nav main-navigation">
							<div id="navigation" class="hidden-xs hidden-sm">
							    <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Primary Menu', 'bizcorp' ); ?>">
									<?php echo bizcorp_get_menu( 'primary' ); ?>
							    </nav>
							</div>
						</div>
					</div>
					<div class="col-xs-12 col-sm-12 col-md-4">
						<div class="header-bottom-right">
							<?php if( !bizcorp_get_option( 'disable_search_icon' ) ):?>
								<span class="search-icon">
									<a href="#">
										<button aria-expanded="false">
											<span class="kfi kfi-search" aria-hidden="true"></span>
										</button>
									</a>
									<div id="search-form">
										<?php get_search_form(); ?>
									</div><!-- /#search-form -->
								</span>
							<?php endif; ?>
							<?php if( class_exists( 'WooCommerce' ) ): ?>
								<span class="cart-icon">
									<a href="<?php echo esc_url( wc_get_cart_url() ); ?>">
										<span class="kfi kfi-cart-alt"></span>
										<span class="count">
											<?php echo absint( WC()->cart->get_cart_contents_count() ); ?>
										</span>
									</a>
								</span>
							<?php endif; ?>
							<span class="alt-menu-icon visible-sm">
								<a class="offcanvas-menu-toggler" href="#">
									<span class="kfi kfi-menu"></span>
								</a>
							</span>
						</div>
					</div>
				</div>
			</div>
		</header><!-- #masthead -->
		<div id="content" class="wrapper site-main">

