<?php
/**
 * Theme Palace basic theme structure hooks
 *
 * This file contains structural hooks.
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

$biopexel_options = biopexel_get_theme_options();  


if ( ! function_exists( 'biopexel_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since  Biopexel 1.0.0
	 */
	function biopexel_doctype() {
	?>
		<!DOCTYPE html>
			<html <?php language_attributes(); ?>>
	<?php
	}
endif;
add_action( 'biopexel_doctype', 'biopexel_doctype', 10 );


if ( ! function_exists( 'biopexel_head' ) ) :
	/**
	 * Header Codes
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
			<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
		<?php endif;
	}
endif;
add_action( 'biopexel_before_wp_head', 'biopexel_head', 10 );

if ( ! function_exists( 'biopexel_page_start' ) ) :
	/**
	 * Page starts html codes
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_page_start() {
		?>
		<div id="page" class="site">
			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'biopexel' ); ?></a>
		<?php
	}
endif;
add_action( 'biopexel_page_start_action', 'biopexel_page_start', 10 );

if ( ! function_exists( 'biopexel_page_end' ) ) :
	/**
	 * Page end html codes
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_page_end() {
		?>
		</div><!-- #page -->
		<?php
	}
endif;
add_action( 'biopexel_page_end_action', 'biopexel_page_end', 10 );

if ( ! function_exists( 'biopexel_site_branding' ) ) :
	/**
	 * Site branding codes
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_site_branding() {
		$biopexel_options  = biopexel_get_theme_options();
		$header_txt_logo_extra = $biopexel_options['header_txt_logo_extra'];	 ?>

		<div class="menu-overlay"></div>

		<header id="masthead" class="site-header" role="banner">
			<div class="wrapper">
				<div class="site-branding">
					<?php if ( in_array( $header_txt_logo_extra, array( 'show-all', 'logo-title', 'logo-tagline' ) ) && has_custom_logo()  ) : ?>
						<div class="site-logo">
							<?php the_custom_logo(); ?>
						</div>
					<?php endif; 

					if ( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title', 'show-all', 'tagline-only', 'logo-tagline' ) ) ) : ?>
						<div id="site-identity">
							<?php
							if( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title' ) )  ) {
								if ( biopexel_is_latest_posts() ) : ?>
									<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
								<?php else : ?>
									<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
								<?php
								endif;
							} 
							if ( in_array( $header_txt_logo_extra, array( 'show-all', 'tagline-only', 'logo-tagline' ) ) ) {
								$description = get_bloginfo( 'description', 'display' );
								if ( $description || is_customize_preview() ) : ?>
									<p class="site-description"><?php echo esc_html( $description ); /* WPCS: xss ok. */ ?></p>
								<?php
								endif; 
							}?>
						</div>
					<?php endif; ?>
				</div>

				<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
					<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false" title="Primary Menu">
					<?php
						echo biopexel_get_svg( array( 'icon' => 'menu', 'class' => 'icon-menu' ) );
						echo biopexel_get_svg( array( 'icon' => 'close', 'class' => 'icon-menu' ) );
					?>	
						<span class="menu-label"><?php esc_html_e('Menu', 'biopexel')?></span>		
					</button>
					<?php
						$social_html = null;
						if($biopexel_options['social_menu_enable'] && has_nav_menu( 'social' )): 
							$social_html = wp_nav_menu(
								array(
									'theme_location' => 'social',
									'container' => false,
									'items_wrap' => '%3$s',
									'echo' => false,
									'depth' => 1,
									'link_before' => '<span class="screen-reader-text">',
									'link_after' => '</span>',
									'fallback_cb' => false,
								)
							);
						else:
							$social_html = '';
						endif;
					
						$search_html = sprintf(
							'<li class="social-menu"><div class="social-icons"><ul><li class="search-menu"><a href="#" title="%1$s">%2$s%3$s</a><div id="search">%4$s</div></li>%5$s</ul></div></li>',
							esc_attr__('Search','biopexel'),
							biopexel_get_svg( array( 'icon' => 'search' ) ), 
							biopexel_get_svg( array( 'icon' => 'close' ) ), 
							get_search_form( $echo = false ),
							$social_html,

						);
							
						wp_nav_menu( array(
							'theme_location' => 'primary',
							'container' => 'div',
							'menu_class' => 'menu nav-menu',
							'menu_id' => 'primary-menu',
							'echo' => true,
							'fallback_cb' => 'biopexel_menu_fallback_cb',
							'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s'.$search_html.'</ul>',
						) );
						
						
					?>
				</nav><!-- #site-navigation -->
			</div>
		</header><!-- .header-->
<?php 
	}
endif;
add_action( 'biopexel_header_action', 'biopexel_site_branding', 10 );

if ( ! function_exists( 'biopexel_content_start' ) ) :
	/**
	 * Site content codes
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_content_start() {
		?>
		<div id="content" class="site-content">
		<?php
	}
endif;
add_action( 'biopexel_content_start_action', 'biopexel_content_start', 10 );

if ( ! function_exists( 'biopexel_header_image' ) ) :
    /**
     * Header Image codes
     *
     * @since  Biopexel 1.0.0
     *
     */
    function biopexel_header_image() {
    	$biopexel_options  = biopexel_get_theme_options();
        if ( biopexel_is_frontpage() )
            return;
        $header_image = get_header_image();
        ?>

    	<?php if ( is_singular() && $biopexel_options['single_post_hide_banner'] == false ): ?>
    		<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url( $header_image ); ?>');">
	            <div class="overlay"></div>
	            <div class="header-wrapper">
		            <div class="wrapper">
		                <header class="page-header">
		                    <?php echo biopexel_custom_header_banner_title(); ?>
		                </header>

		                <?php biopexel_add_breadcrumb(); ?>
		            </div><!-- .wrapper -->
	            </div><!-- .header-wrapper -->
	        </div><!-- #page-site-header -->
    	<?php endif ?>
    	<?php if (is_singular() && $biopexel_options['single_post_hide_banner'] == true): ?>
    		<div class="header-wrapper wrapper">
    			<header class="page-header">
    				<?php echo biopexel_custom_header_banner_title(); ?>
    			</header>

    			<?php biopexel_add_breadcrumb(); ?>
    		</div><!-- .header-wrapper -->
    	<?php endif ?>

    	<?php if ( ( is_archive() || is_home() ) && $biopexel_options['hide_banner'] == false ): ?>
    		<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url( $header_image ); ?>');">
	            <div class="overlay"></div>
	            <div class="header-wrapper">
		            <div class="wrapper">
		                <header class="page-header">
		                    <?php echo biopexel_custom_header_banner_title(); ?>
		                </header>

		                <?php biopexel_add_breadcrumb(); ?>
		            </div><!-- .wrapper -->
	            </div><!-- .header-wrapper -->
	        </div><!-- #page-site-header -->
    	<?php endif ?>
    	<?php if ( ( is_archive() || is_home() ) && $biopexel_options['hide_banner'] == true): ?>
	    		<div class="header-wrapper wrapper">
	                <header class="page-header">
	                    <?php echo biopexel_custom_header_banner_title(); ?>
	                </header>

	                <?php biopexel_add_breadcrumb(); ?>
	            </div><!-- .header-wrapper -->
    	<?php endif ?>

        <?php
    }
endif;
add_action( 'biopexel_header_image_action', 'biopexel_header_image', 10 );

if ( ! function_exists( 'biopexel_add_breadcrumb' ) ) :
	/**
	 * Add breadcrumb.
	 *
	 * @since  Biopexel 1.0.0
	 */
	function biopexel_add_breadcrumb() {
		$biopexel_options = biopexel_get_theme_options();

		// Bail if Breadcrumb disabled.
		$breadcrumb = $biopexel_options['breadcrumb_enable'];
		if ( false === $breadcrumb ) {
			return;
		}
		
		// Bail if Home Page.
		if ( biopexel_is_frontpage() ) {
			return;
		}

		echo '<div id="breadcrumb-list" >';
				/**
				 * biopexel_simple_breadcrumb hook
				 *
				 * @hooked biopexel_simple_breadcrumb -  10
				 *
				 */
				do_action( 'biopexel_simple_breadcrumb' );
		echo '</div><!-- #breadcrumb-list -->';
	}
endif;

if ( ! function_exists( 'biopexel_content_end' ) ) :
	/**
	 * Site content codes
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_content_end() {
		?>
        </div><!-- #content -->
		<?php
	}
endif;
add_action( 'biopexel_content_end_action', 'biopexel_content_end', 10 );

if ( ! function_exists( 'biopexel_footer_start' ) ) :
	/**
	 * Footer starts
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_footer_start() {
		?>
		<footer id="colophon" class="site-footer" role="contentinfo">
		<?php
	}
endif;
add_action( 'biopexel_footer', 'biopexel_footer_start', 10 );

if ( ! function_exists( 'biopexel_footer_site_info' ) ) :
	/**
	 * Footer starts
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_footer_site_info() {
		$biopexel_options = biopexel_get_theme_options();
		$theme_data = wp_get_theme();
		$search = array( '[the-year]', '[site-link]' );

        $replace = array( date( 'Y' ), '<a href="'. esc_url( home_url( '/' ) ) .'">'. esc_attr( get_bloginfo( 'name', 'display' ) ) . '</a>' );

        $biopexel_options['copyright_text'] = str_replace( $search, $replace, $biopexel_options['copyright_text'] );

		$copyright_text = $biopexel_options['copyright_text'];
		?>
		<div class="site-info col-2">
			<div class="wrapper">
				<span>
					<?php if (!empty( $copyright_text ) ):

                		echo biopexel_santize_allow_tag( $copyright_text ); 
                		if ( function_exists( 'the_privacy_policy_link' ) ) {
                			the_privacy_policy_link( ' | ' );
                		}

                	endif; ?>
				</span>
				<span>
					<?php 
						if(has_nav_menu( 'social' )){
							wp_nav_menu( 
								array(
									'theme_location' => 'social',
									'container' => 'ul',
									'menu_class' => 'social-icons',
									'echo' => true,
									'depth' => 1,
									'link_before' => '<span class="screen-reader-text">',
									'link_after' => '</span>',
									'fallback_cb' => false,
								)
							);
						}
					?>
				</span>
			</div><!-- .wrapper -->    
		</div><!-- .site-info -->

		<?php
	}
endif;
add_action( 'biopexel_footer', 'biopexel_footer_site_info', 40 );

if ( ! function_exists( 'biopexel_footer_scroll_to_top' ) ) :
	/**
	 * Footer starts
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_footer_scroll_to_top() {
		$biopexel_options  = biopexel_get_theme_options();
		if ( true === $biopexel_options['scroll_top_visible'] ) : ?>
			<div class="backtotop"><?php echo biopexel_get_svg( array( 'icon' => 'up' ) ); ?></div>
		<?php endif;
	}
endif;
add_action( 'biopexel_footer', 'biopexel_footer_scroll_to_top', 40 );


if ( ! function_exists( 'biopexel_infinite_loader_spinner' ) ) :
	/**
	 *
	 * @since  Biopexel 1.0.0
	 *
	 */
	function biopexel_infinite_loader_spinner() { 
		global $post;
		$biopexel_options = biopexel_get_theme_options();
		if ( $biopexel_options['pagination_type'] == 'infinite' ) :			
			echo '<div class="blog-loader">' . biopexel_get_svg( array( 'icon' => 'spinner-umbrella' ) ) . '</div>';			
		endif;
	}
endif;
add_action( 'biopexel_infinite_loader_spinner_action', 'biopexel_infinite_loader_spinner', 10 );
