<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */
if ( ! function_exists( 'biopexel_add_testimonial_section' ) ) :
    /**
    * Add testimonial section
    *
    *@since Biopexel 1.0.0
    */
    function biopexel_add_testimonial_section() {
    	$options = biopexel_get_theme_options();
        // Check if testimonial is enabled on frontpage
        $testimonial_enable = apply_filters( 'biopexel_section_status', true, 'testimonial_section_enable' );

        if ( true !== $testimonial_enable ) {
            return false;
        }
        // Get testimonial section details
        $section_details = array();
        $section_details = apply_filters( 'biopexel_filter_testimonial_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render testimonial section now.
        biopexel_render_testimonial_section( $section_details );
    }
endif;

if ( ! function_exists( 'biopexel_get_testimonial_section_details' ) ) :
    /**
    * testimonial section details.
    *
    * @since Biopexel 1.0.0
    * @param array $input testimonial section details.
    */
    function biopexel_get_testimonial_section_details( $input ) {
        $options = biopexel_get_theme_options();
        $content = array();
        $page_ids = array();
        
        for ( $i = 1; $i <= 3; $i++ ) {
            if ( ! empty( $options['testimonial_content_page_' . $i] ) ) :
                $page_ids[] = $options['testimonial_content_page_' . $i];

            endif;
        }
        
        $args = array(
            'post_type'         => 'page',
            'post__in'          => ( array ) $page_ids,
            'posts_per_page'    => absint( 3 ),
            'orderby'           => 'post__in',
        );                    

            // Run The Loop.
        $query = new WP_Query( $args );
        $i = 0;
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['position']  = ( ! empty( $position[$i] ) ) ? $position[$i] : '';
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = biopexel_trim_content( 50 );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : '';

                    // Push to the main array.
                array_push( $content, $page_post );
                $i++;
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// testimonial section content details.
add_filter( 'biopexel_filter_testimonial_section_details', 'biopexel_get_testimonial_section_details' );


if ( ! function_exists( 'biopexel_render_testimonial_section' ) ) :
  /**
   * Start testimonial section
   *
   * @return string testimonial content
   * @since Biopexel 1.0.0
   *
   */
   function biopexel_render_testimonial_section( $content_details = array() ) {
        $options = biopexel_get_theme_options();
        
        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="biopexel_testimonial_section" class="relative page-section same-background">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    biopexel_section_tooltip( 'biopexel_testimonial_section' );
                endif; ?>
                <div class="testimonial-content">
                    <div class="testimonial-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": true, "arrows":false, "autoplay": false, "draggable": true, "fade": false }'>
                        <?php $i=1; foreach ( $content_details as $content ) : ?>
                            <article>
                                <div class="entry-container">
                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->

                                    <div class="seperator"></div>
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        <?php if ( !empty( $options['testimonial_position_' . $i] ) ): ?>
                                            <span class="testimonial-position"><?php echo esc_html( $options['testimonial_position_' . $i] ); ?></span>
                                        <?php endif ?>                                    
                                    </header>
                                </div><!-- .entry-container -->
                            </article>
                        <?php $i++; endforeach; ?>                  
                    </div><!-- .testimonial-slider -->
                </div><!-- .testimonial-content -->
            </div><!-- .wrapper -->
        </div><!-- #biopexel_testimonial_section -->
        
    <?php }
endif;