<?php
/**
 * Project section
 *
 * This is the template for the content of project section
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */
if ( ! function_exists( 'biopexel_add_project_section' ) ) :
    /**
    * Add project section
    *
    *@since Biopexel 1.0.0
    */
    function biopexel_add_project_section() {
    	$options = biopexel_get_theme_options();
        // Check if project is enabled on frontpage
        $project_enable = apply_filters( 'biopexel_section_status', true, 'project_section_enable' );

        if ( true !== $project_enable ) {
            return false;
        }
        // Get project section details
        $section_details = array();
        $section_details = apply_filters( 'biopexel_filter_project_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render project section now.
        biopexel_render_project_section( $section_details );
    }
endif;

if ( ! function_exists( 'biopexel_get_project_section_details' ) ) :
    /**
    * project section details.
    *
    * @since Biopexel 1.0.0
    * @param array $input project section details.
    */
    function biopexel_get_project_section_details( $input ) {
        $options = biopexel_get_theme_options();

        $content = array();
        $page_id = ! empty( $options['project_content_page'] ) ? $options['project_content_page'] : '';
        $args = array(
            'post_type'         => 'page',
            'page_id'           => $page_id,
            'posts_per_page'    => 1,
        );

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = biopexel_trim_content( 50 );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';

                    // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// project section content details.
add_filter( 'biopexel_filter_project_section_details', 'biopexel_get_project_section_details' );


if ( ! function_exists( 'biopexel_render_project_section' ) ) :
  /**
   * Start project section
   *
   * @return string project content
   * @since Biopexel 1.0.0
   *
   */
function biopexel_render_project_section( $content_details = array() ) {
    $options  = biopexel_get_theme_options();
    
    if ( empty( $content_details ) ) {
        return;
    } ?>
        <div id="biopexel_project_section" class="relative page-section same-background">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    biopexel_section_tooltip( 'biopexel_project_section' );
                endif; ?>
                <?php foreach( $content_details as $content ) : ?>
                    <div class="project-wrapper">
                        <div class="section-header">
                            <?php if ( !empty( $content['title'] ) ): ?>
                                <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                            <?php endif ?>
                        </div><!-- .section-header -->

                        <div class="section-content">
                            <?php echo wp_kses_post( $content['excerpt'] ); ?>
                        </div><!-- .section-content -->

                        <?php if ( !empty($content['url'] && $options['project_btn_title'] ) ) : ?>
                            <div class="read-more">
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn"><?php echo esc_html( $options['project_btn_title'] ); ?></a>
                            </div><!-- .read-more -->
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div><!-- .wrapper -->
        </div><!-- #project-section -->
    <?php }
endif;
