<?php
/**
 * Blog section
 *
 * This is the template for the content of latest blog section
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */
if ( ! function_exists( 'biopexel_add_latest_blog_section' ) ) :
    /**
    * Add latest blog section
    *
    *@since  Biopexel 1.0.0
    */
    function biopexel_add_latest_blog_section() {
        $options = biopexel_get_theme_options();
        // Check if latest blog is enabled on frontpage
        $latest_blog_enable = apply_filters( 'biopexel_section_status', true, 'latest_blog_section_enable' );

        if ( true !== $latest_blog_enable ) {
            return false;
        }
        // Get latest blog section details
        $section_details = array();
        $section_details = apply_filters( 'biopexel_filter_latest_blog_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render latest blog section now.
        biopexel_render_latest_blog_section( $section_details );
    }
endif;

if ( ! function_exists( 'biopexel_get_latest_blog_section_details' ) ) :
    /**
    * latest blog section details.
    *
    * @since  Biopexel 1.0.0
    * @param array $input latest blog section details.
    */
    function biopexel_get_latest_blog_section_details( $input ) {
        $options = biopexel_get_theme_options();

        $content = array();
        $post_ids = array();

        for ( $i = 1; $i <= 3; $i++ ) {
            if ( ! empty( $options['latest_blog_content_post_' . $i] ) )
                $post_ids[] = $options['latest_blog_content_post_' . $i];
        }

        $args = array(
            'post_type'             => 'post',
            'post__in'              => ( array ) $post_ids,
            'posts_per_page'        => absint( 3 ),
            'orderby'               => 'post__in',
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = biopexel_trim_content( 30);
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// latest_blog section content details.
add_filter( 'biopexel_filter_latest_blog_section_details', 'biopexel_get_latest_blog_section_details' );


if ( ! function_exists( 'biopexel_render_latest_blog_section' ) ) :
  /**
   * Start latest blog section
   *
   * @return string latest blog content
   * @since  Biopexel 1.0.0
   *
   */
   function biopexel_render_latest_blog_section( $content_details = array() ) {
        $options = biopexel_get_theme_options();
        $latest_blog_btn_link = ! empty( $options['latest_blog_btn_link'] ) ? $options['latest_blog_btn_link'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>
    
        <div id="biopexel_latest_blog_section" class="relative page-section same-background">
            <div class="wrapper">
                <?php if ( is_customize_preview()):
                    biopexel_section_tooltip( 'biopexel_latest_blog_section' );
                endif; ?>
                <div class="section-header">
                    <h2 class="section-title"><?php echo esc_html( $options['latest_blog_title'] ); ?></h2>
                </div><!-- .section-header -->

                <div class="archive-blog-wrapper col-3 clear">
                    <?php foreach($content_details as $content): ?>
                        <article class="has-post-thumbnail">
                            <div class="post-wrapper clear">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url($content['image']);?>');">
                                    <a href="<?php echo esc_url($content['url']);?>" class="post-thumbnail-link"></a>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <div class="entry-meta">
                                    <?php biopexel_posted_on( $content['id'] ); ?>     
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                    </header>
                                </div><!-- .entry-container -->
                            </div>
                        </article>
                    <?php endforeach; ?>
                </div><!-- .archive-blog-wrapper -->
                <?php if ( !empty ( $latest_blog_btn_link ) ) : ?>
                    <div class="read-more">
                        <a href="<?php echo esc_url( $latest_blog_btn_link ); ?>" class="btn"><?php echo esc_html( $options['latest_blog_read_more_btn_label'] ); ?></a>
                    </div><!-- .read-more -->
                <?php endif; ?>
            </div><!-- .wrapper -->
        </div><!-- #Biopexel_latest_blog_section -->

    <?php }
endif;  ?>
